/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.committee.rules;

import java.sql.Date;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.jmock.Expectations;
import org.jmock.Mockery;
import org.jmock.integration.junit4.JUnit4Mockery;
import org.jmock.internal.ExpectationBuilder;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kra.committee.bo.Committee;
import org.kuali.kra.committee.bo.CommitteeMembership;
import org.kuali.kra.committee.bo.CommitteeSchedule;
import org.kuali.kra.committee.document.CommitteeDocument;
import org.kuali.kra.committee.rule.event.DeleteCommitteeMemberEvent;
import org.kuali.kra.committee.rules.CommitteeRuleTestBase;
import org.kuali.kra.committee.rules.DeleteCommitteeMemberRule;
import org.kuali.kra.committee.service.CommitteeService;
import org.kuali.kra.committee.service.impl.CommitteeMembershipServiceImpl;
import org.kuali.kra.common.committee.bo.CommitteeMembershipBase;
import org.kuali.kra.common.committee.rule.event.CommitteeMemberEventBase;
import org.kuali.kra.common.committee.rule.event.DeleteCommitteeMemberEventBase;
import org.kuali.kra.common.committee.service.CommitteeServiceBase;
import org.kuali.kra.irb.actions.submit.ProtocolSubmission;
import org.kuali.kra.irb.onlinereview.ProtocolOnlineReview;
import org.kuali.kra.meeting.CommitteeScheduleAttendance;
import org.kuali.kra.protocol.actions.submit.ProtocolReviewer;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.util.ErrorMessage;
import org.kuali.rice.krad.util.GlobalVariables;
import org.springframework.util.AutoPopulatingList;

public class DeleteCommitteeMemberRuleTest
extends CommitteeRuleTestBase {
    private DeleteCommitteeMemberRule rule;
    private Mockery context = new JUnit4Mockery();
    private CommitteeMembershipServiceImpl committeeMembershipService;

    @Before
    public void setup() throws Exception {
        super.setUp();
        this.committeeMembershipService = new CommitteeMembershipServiceImpl();
        this.rule = new DeleteCommitteeMemberRule(){
            private static final String ID = "document.committeeList[0].committeeMemberships[";
            private static final String AS_REVIEWER = "as the person is a reviewer of the protocol";
            private static final String AS_ATTENDANCE = "as the person has attended a schedule meeting";

            public boolean processRules(DeleteCommitteeMemberEventBase event) {
                boolean rulePassed = true;
                int i = 0;
                for (CommitteeMembershipBase member : event.getCommitteeMemberships()) {
                    if (member.isDelete() && DeleteCommitteeMemberRuleTest.this.committeeMembershipService.isMemberAssignedToReviewer(member, ((Committee)((CommitteeDocument)event.getDocument()).getCommittee()).getCommitteeId())) {
                        this.reportError(ID + i + "].delete", "error.committeeMember.delete", new String[]{AS_REVIEWER});
                        rulePassed = false;
                    }
                    if (member.isDelete() && DeleteCommitteeMemberRuleTest.this.committeeMembershipService.isMemberAttendedMeeting(member, ((Committee)((CommitteeDocument)event.getDocument()).getCommittee()).getCommitteeId())) {
                        this.reportError(ID + i + "].delete", "error.committeeMember.delete", new String[]{AS_ATTENDANCE});
                        rulePassed = false;
                    }
                    ++i;
                }
                return rulePassed;
            }
        };
    }

    @Override
    @After
    public void tearDown() throws Exception {
        this.rule = null;
        super.tearDown();
    }

    @Test
    public void testDeleteCommitteeMemberOK() throws Exception {
        final BusinessObjectService businessObjectService = (BusinessObjectService)this.context.mock(BusinessObjectService.class);
        final HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put("committeeId", "test");
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((BusinessObjectService)this.one(businessObjectService)).findMatching(ProtocolSubmission.class, fieldValues);
                this.will(2.returnValue((Object)DeleteCommitteeMemberRuleTest.this.getProtocolSubmissions(false)));
            }
        });
        this.committeeMembershipService.setBusinessObjectService(businessObjectService);
        final Committee activeCommittee = new Committee();
        activeCommittee.setCommitteeId("test");
        final CommitteeService committeeService = (CommitteeService)this.context.mock(CommitteeService.class);
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((CommitteeService)this.one(committeeService)).getCommitteeById("test");
                this.will(3.returnValue((Object)activeCommittee));
            }
        });
        this.committeeMembershipService.setCommitteeService((CommitteeServiceBase)committeeService);
        CommitteeDocument document = new CommitteeDocument();
        Committee committee = new Committee();
        committee.setCommitteeId("test");
        ArrayList<CommitteeMembership> committeeMemberships = new ArrayList<CommitteeMembership>();
        CommitteeMembership committeeMembership = this.createMembership("100", null, "1", "2009-01-01", "2009-01-10");
        committeeMembership.setDelete(true);
        committeeMemberships.add(committeeMembership);
        ArrayList<Committee> committees = new ArrayList<Committee>();
        committees.add(committee);
        committee.setCommitteeMemberships(committeeMemberships);
        document.setCommitteeList(committees);
        DeleteCommitteeMemberEvent event = new DeleteCommitteeMemberEvent("", document, committeeMemberships, CommitteeMemberEventBase.ErrorType.HARDERROR);
        Assert.assertTrue((boolean)this.rule.processRules((DeleteCommitteeMemberEventBase)event));
    }

    @Test
    public void testDeleteCommitteeMemberAsReviewer() throws Exception {
        final BusinessObjectService businessObjectService = (BusinessObjectService)this.context.mock(BusinessObjectService.class);
        final HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put("committeeId", "test");
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((BusinessObjectService)this.one(businessObjectService)).findMatching(ProtocolSubmission.class, fieldValues);
                this.will(4.returnValue((Object)DeleteCommitteeMemberRuleTest.this.getProtocolSubmissions(true)));
            }
        });
        this.committeeMembershipService.setBusinessObjectService(businessObjectService);
        final Committee activeCommittee = new Committee();
        activeCommittee.setCommitteeId("test");
        final CommitteeService committeeService = (CommitteeService)this.context.mock(CommitteeService.class);
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((CommitteeService)this.one(committeeService)).getCommitteeById("test");
                this.will(5.returnValue((Object)activeCommittee));
            }
        });
        this.committeeMembershipService.setCommitteeService((CommitteeServiceBase)committeeService);
        CommitteeDocument document = new CommitteeDocument();
        Committee committee = new Committee();
        committee.setCommitteeId("test");
        ArrayList<CommitteeMembership> committeeMemberships = new ArrayList<CommitteeMembership>();
        CommitteeMembership committeeMembership = this.createMembership("100", null, "1", "2009-01-01", "2009-01-10");
        committeeMembership.setDelete(true);
        committeeMemberships.add(committeeMembership);
        ArrayList<Committee> committees = new ArrayList<Committee>();
        committees.add(committee);
        committee.setCommitteeMemberships(committeeMemberships);
        document.setCommitteeList(committees);
        DeleteCommitteeMemberEvent event = new DeleteCommitteeMemberEvent("", document, committeeMemberships, CommitteeMemberEventBase.ErrorType.HARDERROR);
        Assert.assertFalse((boolean)this.rule.processRules((DeleteCommitteeMemberEventBase)event));
    }

    @Test
    public void testDeleteCommitteeMemberAsAttendance() throws Exception {
        final BusinessObjectService businessObjectService = (BusinessObjectService)this.context.mock(BusinessObjectService.class);
        final HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put("committeeId", "test");
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((BusinessObjectService)this.one(businessObjectService)).findMatching(ProtocolSubmission.class, fieldValues);
                this.will(6.returnValue((Object)DeleteCommitteeMemberRuleTest.this.getProtocolSubmissions(false)));
            }
        });
        this.committeeMembershipService.setBusinessObjectService(businessObjectService);
        final Committee activeCommittee = new Committee();
        activeCommittee.setCommitteeId("test");
        ArrayList<CommitteeSchedule> schedules = new ArrayList<CommitteeSchedule>();
        CommitteeScheduleAttendance attendance = new CommitteeScheduleAttendance();
        CommitteeSchedule schedule = new CommitteeSchedule();
        ArrayList<CommitteeScheduleAttendance> attendances = new ArrayList<CommitteeScheduleAttendance>();
        attendance.setPersonId("100");
        attendances.add(attendance);
        schedules.add(schedule);
        schedule.setCommitteeScheduleAttendances(attendances);
        activeCommittee.setCommitteeSchedules(schedules);
        final CommitteeService committeeService = (CommitteeService)this.context.mock(CommitteeService.class);
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((CommitteeService)this.one(committeeService)).getCommitteeById("test");
                this.will(7.returnValue((Object)activeCommittee));
            }
        });
        this.committeeMembershipService.setCommitteeService((CommitteeServiceBase)committeeService);
        CommitteeDocument document = new CommitteeDocument();
        Committee committee = new Committee();
        committee.setCommitteeId("test");
        ArrayList<CommitteeMembership> committeeMemberships = new ArrayList<CommitteeMembership>();
        CommitteeMembership committeeMembership = this.createMembership("100", null, "1", "2009-01-01", "2009-01-10");
        committeeMembership.setDelete(true);
        committeeMemberships.add(committeeMembership);
        ArrayList<Committee> committees = new ArrayList<Committee>();
        committees.add(committee);
        committee.setCommitteeMemberships(committeeMemberships);
        document.setCommitteeList(committees);
        DeleteCommitteeMemberEvent event = new DeleteCommitteeMemberEvent("", document, committeeMemberships, CommitteeMemberEventBase.ErrorType.HARDERROR);
        Assert.assertFalse((boolean)this.rule.processRules((DeleteCommitteeMemberEventBase)event));
        this.assertError("document.committeeList[0].committeeMemberships[0].delete", "error.committeeMember.delete");
    }

    @Override
    protected void assertError(String propertyKey, String errorKey) {
        AutoPopulatingList errors = GlobalVariables.getMessageMap().getMessages(propertyKey);
        Assert.assertNotNull((Object)errors);
        Assert.assertTrue((errors.size() == 1 ? 1 : 0) != 0);
        ErrorMessage message = (ErrorMessage)errors.get(0);
        Assert.assertNotNull((Object)message);
        Assert.assertEquals((Object)message.getErrorKey(), (Object)errorKey);
    }

    private List<ProtocolSubmission> getProtocolSubmissions(boolean isSameReviewer) {
        ArrayList<ProtocolSubmission> submissions = new ArrayList<ProtocolSubmission>();
        ArrayList<ProtocolOnlineReview> reviews = new ArrayList<ProtocolOnlineReview>();
        ProtocolOnlineReview review = new ProtocolOnlineReview();
        org.kuali.kra.irb.actions.submit.ProtocolReviewer reviewer = new org.kuali.kra.irb.actions.submit.ProtocolReviewer();
        if (isSameReviewer) {
            reviewer.setPersonId("100");
        } else {
            reviewer.setPersonId("101");
        }
        review.setProtocolReviewer((ProtocolReviewer)reviewer);
        reviews.add(review);
        ProtocolSubmission submission = new ProtocolSubmission();
        submission.setProtocolOnlineReviews(reviews);
        submissions.add(submission);
        return submissions;
    }

    private CommitteeMembership createMembership(String personID, Integer rolodexID, String membershipTypeCode, String termStartDate, String termEndDate) {
        CommitteeMembership committeeMembership = new CommitteeMembership();
        committeeMembership.setPersonId(personID);
        committeeMembership.setRolodexId(rolodexID);
        committeeMembership.setMembershipTypeCode(membershipTypeCode);
        if (termStartDate != null) {
            committeeMembership.setTermStartDate(Date.valueOf(termStartDate));
        }
        if (termEndDate != null) {
            committeeMembership.setTermEndDate(Date.valueOf(termEndDate));
        }
        return committeeMembership;
    }
}

