/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.committee.rules;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.jmock.Expectations;
import org.jmock.Mockery;
import org.jmock.integration.junit4.JUnit4Mockery;
import org.jmock.internal.ExpectationBuilder;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kra.committee.bo.Committee;
import org.kuali.kra.committee.bo.CommitteeSchedule;
import org.kuali.kra.committee.document.CommitteeDocument;
import org.kuali.kra.committee.rule.event.DeleteCommitteeScheduleEvent;
import org.kuali.kra.committee.rules.CommitteeRuleTestBase;
import org.kuali.kra.committee.rules.DeleteCommitteeScheduleRule;
import org.kuali.kra.committee.service.impl.CommitteeServiceImpl;
import org.kuali.kra.common.committee.bo.CommitteeScheduleBase;
import org.kuali.kra.common.committee.document.CommitteeDocumentBase;
import org.kuali.kra.common.committee.rule.event.CommitteeScheduleEventBase;
import org.kuali.kra.common.committee.rule.event.DeleteCommitteeScheduleEventBase;
import org.kuali.kra.irb.actions.submit.ProtocolSubmission;
import org.kuali.kra.irb.onlinereview.ProtocolOnlineReview;
import org.kuali.kra.protocol.actions.submit.ProtocolReviewer;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.util.ErrorMessage;
import org.kuali.rice.krad.util.GlobalVariables;
import org.springframework.util.AutoPopulatingList;

public class DeleteCommitteeScheduleRuleTest
extends CommitteeRuleTestBase {
    private DeleteCommitteeScheduleRule rule;
    private Mockery context = new JUnit4Mockery();
    private CommitteeServiceImpl committeeService;

    @Before
    public void setup() throws Exception {
        super.setUp();
        this.committeeService = new CommitteeServiceImpl();
        this.rule = new DeleteCommitteeScheduleRule(){
            private static final String ID = "document.committeeList[0].committeeSchedules[";

            public boolean processRules(DeleteCommitteeScheduleEventBase deleteCommitteeScheduleEvent) {
                boolean rulePassed = true;
                List schedules = deleteCommitteeScheduleEvent.getCommitteeSchedules();
                Committee activeCommittee = (Committee)DeleteCommitteeScheduleRuleTest.this.committeeService.getCommitteeById(((Committee)((CommitteeDocument)deleteCommitteeScheduleEvent.getDocument()).getCommittee()).getCommitteeId());
                if (activeCommittee != null) {
                    int i = 0;
                    for (CommitteeScheduleBase schedule : schedules) {
                        if (schedule.isSelected() && this.canNotDelete(activeCommittee.getCommitteeSchedules(), schedule.getScheduleId())) {
                            this.reportError(ID + i + "].selected", "error.committeeSchedule.delete", new String[0]);
                            rulePassed = false;
                        }
                        ++i;
                    }
                }
                return rulePassed;
            }

            private boolean canNotDelete(List<CommitteeSchedule> schedules, String scheduleId) {
                for (CommitteeSchedule committeeSchedule : schedules) {
                    if (!StringUtils.equals((String)committeeSchedule.getScheduleId(), (String)scheduleId)) continue;
                    return this.isNotEmptyData(committeeSchedule);
                }
                return false;
            }

            private boolean isNotEmptyData(CommitteeSchedule schedule) {
                return CollectionUtils.isNotEmpty((Collection)schedule.getCommitteeScheduleAttendances()) || CollectionUtils.isNotEmpty((Collection)schedule.getCommitteeScheduleMinutes()) || CollectionUtils.isNotEmpty((Collection)schedule.getCommScheduleActItems()) || CollectionUtils.isNotEmpty((Collection)schedule.getMinuteDocs()) || CollectionUtils.isNotEmpty((Collection)schedule.getScheduleAgendas()) || CollectionUtils.isNotEmpty((Collection)schedule.getProtocolSubmissions());
            }
        };
    }

    @Override
    @After
    public void tearDown() throws Exception {
        this.rule = null;
        super.tearDown();
    }

    @Test
    public void testDeleteCommitteeScheduleOk() throws Exception {
        final BusinessObjectService businessObjectService = (BusinessObjectService)this.context.mock(BusinessObjectService.class);
        final HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put("committeeId", "test");
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((BusinessObjectService)this.one(businessObjectService)).findMatching(Committee.class, fieldValues);
                this.will(2.returnValue((Object)DeleteCommitteeScheduleRuleTest.this.getCommittees(false)));
            }
        });
        this.committeeService.setBusinessObjectService(businessObjectService);
        CommitteeDocument document = new CommitteeDocument();
        Committee committee = new Committee();
        committee.setCommitteeId("test");
        ArrayList<Committee> committees = new ArrayList<Committee>();
        committees.add(committee);
        document.setCommitteeList(committees);
        DeleteCommitteeScheduleEvent event = new DeleteCommitteeScheduleEvent("", (CommitteeDocumentBase)document, null, this.getCommitteeSchedules(false), CommitteeScheduleEventBase.ErrorType.HARDERROR);
        Assert.assertTrue((boolean)this.rule.processRules((DeleteCommitteeScheduleEventBase)event));
    }

    @Test
    public void testDeleteCommitteeSchedule() throws Exception {
        final BusinessObjectService businessObjectService = (BusinessObjectService)this.context.mock(BusinessObjectService.class);
        final HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put("committeeId", "test");
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((BusinessObjectService)this.one(businessObjectService)).findMatching(Committee.class, fieldValues);
                this.will(3.returnValue((Object)DeleteCommitteeScheduleRuleTest.this.getCommittees(true)));
            }
        });
        this.committeeService.setBusinessObjectService(businessObjectService);
        CommitteeDocument document = new CommitteeDocument();
        Committee committee = new Committee();
        committee.setCommitteeId("test");
        ArrayList<Committee> committees = new ArrayList<Committee>();
        committees.add(committee);
        document.setCommitteeList(committees);
        DeleteCommitteeScheduleEvent event = new DeleteCommitteeScheduleEvent("", (CommitteeDocumentBase)document, null, this.getCommitteeSchedules(false), CommitteeScheduleEventBase.ErrorType.HARDERROR);
        Assert.assertFalse((boolean)this.rule.processRules((DeleteCommitteeScheduleEventBase)event));
        this.assertError("document.committeeList[0].committeeSchedules[0].selected", "error.committeeSchedule.delete");
    }

    private List<Committee> getCommittees(boolean containMeetingData) {
        ArrayList<Committee> committees = new ArrayList<Committee>();
        Committee committee = new Committee();
        committee.setCommitteeId("test");
        committee.setSequenceNumber(Integer.valueOf(1));
        committee.setCommitteeSchedules(this.getCommitteeSchedules(containMeetingData));
        committees.add(committee);
        return committees;
    }

    @Override
    protected void assertError(String propertyKey, String errorKey) {
        AutoPopulatingList errors = GlobalVariables.getMessageMap().getMessages(propertyKey);
        Assert.assertNotNull((Object)errors);
        Assert.assertTrue((errors.size() == 1 ? 1 : 0) != 0);
        ErrorMessage message = (ErrorMessage)errors.get(0);
        Assert.assertNotNull((Object)message);
        Assert.assertEquals((Object)message.getErrorKey(), (Object)errorKey);
    }

    private List<CommitteeScheduleBase> getCommitteeSchedules(boolean containMeetingData) {
        ArrayList<CommitteeScheduleBase> committeeSchedules = new ArrayList<CommitteeScheduleBase>();
        CommitteeSchedule committeeSchedule = new CommitteeSchedule();
        committeeSchedules.add((CommitteeScheduleBase)committeeSchedule);
        committeeSchedule.setSelected(true);
        if (containMeetingData) {
            committeeSchedule.setProtocolSubmissions(this.getProtocolSubmissions());
        }
        return committeeSchedules;
    }

    private List<ProtocolSubmission> getProtocolSubmissions() {
        ArrayList<ProtocolSubmission> submissions = new ArrayList<ProtocolSubmission>();
        ArrayList<ProtocolOnlineReview> reviews = new ArrayList<ProtocolOnlineReview>();
        ProtocolOnlineReview review = new ProtocolOnlineReview();
        org.kuali.kra.irb.actions.submit.ProtocolReviewer reviewer = new org.kuali.kra.irb.actions.submit.ProtocolReviewer();
        reviewer.setPersonId("100");
        review.setProtocolReviewer((ProtocolReviewer)reviewer);
        reviews.add(review);
        ProtocolSubmission submission = new ProtocolSubmission();
        submission.setProtocolOnlineReviews(reviews);
        submissions.add(submission);
        return submissions;
    }
}

