/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.committee.service;

import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import org.jmock.Expectations;
import org.jmock.Mockery;
import org.jmock.integration.junit4.JUnit4Mockery;
import org.jmock.internal.ExpectationBuilder;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kra.committee.bo.Committee;
import org.kuali.kra.committee.bo.CommitteeBatchCorrespondence;
import org.kuali.kra.committee.service.impl.CommitteeBatchCorrespondenceServiceImpl;
import org.kuali.kra.committee.test.CommitteeTestHelper;
import org.kuali.kra.common.committee.bo.CommitteeBatchCorrespondenceDetailBase;
import org.kuali.kra.common.notification.service.KcNotificationService;
import org.kuali.kra.irb.Protocol;
import org.kuali.kra.irb.ProtocolDocument;
import org.kuali.kra.irb.actions.ProtocolAction;
import org.kuali.kra.irb.correspondence.ProtocolCorrespondenceTemplate;
import org.kuali.kra.irb.correspondence.ProtocolCorrespondenceTemplateService;
import org.kuali.kra.irb.personnel.ProtocolPerson;
import org.kuali.kra.protocol.ProtocolDao;
import org.kuali.kra.protocol.ProtocolDocumentBase;
import org.kuali.kra.service.KcPersonService;
import org.kuali.kra.service.impl.mocks.MockKcPersonService;
import org.kuali.kra.test.infrastructure.KcUnitTestBase;
import org.kuali.kra.util.DateUtils;
import org.kuali.rice.core.api.datetime.DateTimeService;
import org.kuali.rice.krad.service.BusinessObjectService;

public class CommitteeBatchCorrespondenceServiceTest
extends KcUnitTestBase {
    private static final String PROTOCOL_NUMBER = "1";
    private static final int SEQUENCE_NUMBER = 0;
    private Mockery context = new JUnit4Mockery();
    private CommitteeBatchCorrespondenceServiceImpl committeeBatchCorrespondenceServiceImpl;

    @Override
    @Before
    public void setUp() {
        this.committeeBatchCorrespondenceServiceImpl = new CommitteeBatchCorrespondenceServiceImpl();
        this.committeeBatchCorrespondenceServiceImpl.setKcNotificationService(this.getMockKcNotificationService());
        this.committeeBatchCorrespondenceServiceImpl.setDateTimeService(this.getMockDateTimeService());
    }

    @Test
    public void testGenerateBatchCorrespondenceForRenewalReminders() throws Exception {
        String batchCorrespondenceTypeCode = PROTOCOL_NUMBER;
        Committee committee = (Committee)((List)this.getBusinessObjectService().findAll(Committee.class)).get(0);
        final String committeeId = committee.getCommitteeId();
        final Date startDate = Date.valueOf("2010-06-01");
        final Date endDate = Date.valueOf("2010-06-15");
        this.committeeBatchCorrespondenceServiceImpl.setBusinessObjectService((BusinessObjectService)new CommitteeTestHelper.MockBusinessObjectService());
        this.committeeBatchCorrespondenceServiceImpl.setKcPersonService((KcPersonService)new MockKcPersonService());
        final org.kuali.kra.irb.ProtocolDao protocolDao = (org.kuali.kra.irb.ProtocolDao)this.context.mock(org.kuali.kra.irb.ProtocolDao.class);
        final List<Protocol> protocols = this.initProtocols();
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((org.kuali.kra.irb.ProtocolDao)this.oneOf(protocolDao)).getExpiringProtocols(committeeId, startDate, endDate);
                this.will(1.returnValue((Object)protocols));
            }
        });
        this.committeeBatchCorrespondenceServiceImpl.setProtocolDao((ProtocolDao)protocolDao);
        final ProtocolCorrespondenceTemplateService protocolCorrespondenceTemplateService = (ProtocolCorrespondenceTemplateService)this.context.mock(ProtocolCorrespondenceTemplateService.class);
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((ProtocolCorrespondenceTemplateService)this.oneOf(protocolCorrespondenceTemplateService)).getProtocolCorrespondenceTemplate((String)this.with(2.any(String.class)), (String)this.with(2.any(String.class)));
                this.will(2.returnValue((Object)new ProtocolCorrespondenceTemplate()));
            }
        });
        this.committeeBatchCorrespondenceServiceImpl.setProtocolCorrespondenceTemplateService((org.kuali.kra.protocol.correspondence.ProtocolCorrespondenceTemplateService)protocolCorrespondenceTemplateService);
        CommitteeBatchCorrespondence committeeBatchCorrespondence = (CommitteeBatchCorrespondence)this.committeeBatchCorrespondenceServiceImpl.generateBatchCorrespondence(batchCorrespondenceTypeCode, committeeId, startDate, endDate);
        CommitteeBatchCorrespondenceServiceTest.assertEquals((Object)committeeId, (Object)committeeBatchCorrespondence.getCommitteeId());
        CommitteeBatchCorrespondenceServiceTest.assertEquals((Object)batchCorrespondenceTypeCode, (Object)committeeBatchCorrespondence.getBatchCorrespondenceTypeCode());
        CommitteeBatchCorrespondenceServiceTest.assertEquals((Object)startDate, (Object)committeeBatchCorrespondence.getTimeWindowStart());
        CommitteeBatchCorrespondenceServiceTest.assertEquals((Object)endDate, (Object)committeeBatchCorrespondence.getTimeWindowEnd());
        CommitteeBatchCorrespondenceServiceTest.assertEquals((long)1L, (long)committeeBatchCorrespondence.getCommitteeBatchCorrespondenceDetails().size());
        CommitteeBatchCorrespondenceServiceTest.assertEquals((Object)committeeBatchCorrespondence.getCommitteeBatchCorrespondenceId(), (Object)((CommitteeBatchCorrespondenceDetailBase)committeeBatchCorrespondence.getCommitteeBatchCorrespondenceDetails().get(0)).getCommitteeBatchCorrespondenceId());
        CommitteeBatchCorrespondenceServiceTest.assertEquals((Object)"Renewal Reminder Letter #1", (Object)((CommitteeBatchCorrespondenceDetailBase)committeeBatchCorrespondence.getCommitteeBatchCorrespondenceDetails().get(0)).getProtocolAction().getComments());
    }

    @Test
    public void testGenerateBatchCorrespondenceForIrbNotifications() throws Exception {
        String batchCorrespondenceTypeCode = "2";
        Committee committee = (Committee)((List)this.getBusinessObjectService().findAll(Committee.class)).get(0);
        final String committeeId = committee.getCommitteeId();
        final Date startDate = Date.valueOf("2010-06-01");
        final Date endDate = Date.valueOf("2010-06-15");
        this.committeeBatchCorrespondenceServiceImpl.setBusinessObjectService((BusinessObjectService)new CommitteeTestHelper.MockBusinessObjectService());
        this.committeeBatchCorrespondenceServiceImpl.setKcPersonService((KcPersonService)new MockKcPersonService());
        final org.kuali.kra.irb.ProtocolDao protocolDao = (org.kuali.kra.irb.ProtocolDao)this.context.mock(org.kuali.kra.irb.ProtocolDao.class);
        final List<Protocol> protocols = this.initProtocols();
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((org.kuali.kra.irb.ProtocolDao)this.oneOf(protocolDao)).getNotifiedProtocols(committeeId, startDate, endDate);
                this.will(3.returnValue((Object)protocols));
            }
        });
        this.committeeBatchCorrespondenceServiceImpl.setProtocolDao((ProtocolDao)protocolDao);
        final ProtocolCorrespondenceTemplateService protocolCorrespondenceTemplateService = (ProtocolCorrespondenceTemplateService)this.context.mock(ProtocolCorrespondenceTemplateService.class);
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((ProtocolCorrespondenceTemplateService)this.oneOf(protocolCorrespondenceTemplateService)).getProtocolCorrespondenceTemplate((String)this.with(4.any(String.class)), (String)this.with(4.any(String.class)));
                this.will(4.returnValue((Object)new ProtocolCorrespondenceTemplate()));
            }
        });
        this.committeeBatchCorrespondenceServiceImpl.setProtocolCorrespondenceTemplateService((org.kuali.kra.protocol.correspondence.ProtocolCorrespondenceTemplateService)protocolCorrespondenceTemplateService);
        CommitteeBatchCorrespondence committeeBatchCorrespondence = (CommitteeBatchCorrespondence)this.committeeBatchCorrespondenceServiceImpl.generateBatchCorrespondence(batchCorrespondenceTypeCode, committeeId, startDate, endDate);
        CommitteeBatchCorrespondenceServiceTest.assertEquals((Object)committeeId, (Object)committeeBatchCorrespondence.getCommitteeId());
        CommitteeBatchCorrespondenceServiceTest.assertEquals((Object)batchCorrespondenceTypeCode, (Object)committeeBatchCorrespondence.getBatchCorrespondenceTypeCode());
        CommitteeBatchCorrespondenceServiceTest.assertEquals((Object)startDate, (Object)committeeBatchCorrespondence.getTimeWindowStart());
        CommitteeBatchCorrespondenceServiceTest.assertEquals((Object)endDate, (Object)committeeBatchCorrespondence.getTimeWindowEnd());
        CommitteeBatchCorrespondenceServiceTest.assertEquals((long)1L, (long)committeeBatchCorrespondence.getCommitteeBatchCorrespondenceDetails().size());
        CommitteeBatchCorrespondenceServiceTest.assertEquals((Object)committeeBatchCorrespondence.getCommitteeBatchCorrespondenceId(), (Object)((CommitteeBatchCorrespondenceDetailBase)committeeBatchCorrespondence.getCommitteeBatchCorrespondenceDetails().get(0)).getCommitteeBatchCorrespondenceId());
        CommitteeBatchCorrespondenceServiceTest.assertEquals((Object)"Reminder to IRB Notification #1", (Object)((CommitteeBatchCorrespondenceDetailBase)committeeBatchCorrespondence.getCommitteeBatchCorrespondenceDetails().get(0)).getProtocolAction().getComments());
    }

    private List<Protocol> initProtocols() {
        ArrayList<Protocol> protocols = new ArrayList<Protocol>();
        Protocol protocol1 = new Protocol(){
            private static final long serialVersionUID = 1L;

            public void refreshReferenceObject(String referenceObjectName) {
            }

            public Integer getNextValue(String key) {
                return 2;
            }

            public ProtocolPerson getPrincipalInvestigator() {
                ProtocolPerson pPerson = new ProtocolPerson();
                pPerson.setFullName("PI Test");
                return pPerson;
            }

            public void refreshNonUpdateableReferences() {
            }
        };
        protocol1.setProtocolNumber(PROTOCOL_NUMBER);
        protocol1.setSequenceNumber(Integer.valueOf(0));
        protocol1.setExpirationDate(new Date(DateUtils.addDays((java.util.Date)new Date(System.currentTimeMillis()), (int)17).getTime()));
        protocol1.setProtocolActions(new ArrayList());
        ProtocolAction protocolAction1 = new ProtocolAction();
        protocolAction1.setActionDate(new Timestamp(DateUtils.addDays((java.util.Date)new Date(System.currentTimeMillis()), (int)-2).getTime()));
        protocolAction1.setUpdateTimestamp(protocolAction1.getActionDate());
        protocol1.getProtocolActions().add(protocolAction1);
        protocol1.setProtocolDocument((ProtocolDocumentBase)this.getProtocolDocument(PROTOCOL_NUMBER));
        protocols.add(protocol1);
        Protocol protocol2 = new Protocol(){
            private static final long serialVersionUID = 1L;

            public void refreshReferenceObject(String referenceObjectName) {
            }

            public Integer getNextValue(String key) {
                return 2;
            }

            public ProtocolPerson getPrincipalInvestigator() {
                ProtocolPerson pPerson = new ProtocolPerson();
                pPerson.setFullName("PI Test");
                return pPerson;
            }

            public void refreshNonUpdateableReferences() {
            }
        };
        protocol2.setProtocolNumber(PROTOCOL_NUMBER);
        protocol2.setSequenceNumber(Integer.valueOf(0));
        protocol2.setExpirationDate(new Date(DateUtils.addDays((java.util.Date)new Date(System.currentTimeMillis()), (int)130).getTime()));
        protocol2.setProtocolActions(new ArrayList());
        ProtocolAction protocolAction2 = new ProtocolAction();
        protocolAction2.setActionDate(new Timestamp(DateUtils.addDays((java.util.Date)new Date(System.currentTimeMillis()), (int)-16).getTime()));
        protocolAction2.setUpdateTimestamp(protocolAction2.getActionDate());
        protocol2.getProtocolActions().add(protocolAction2);
        protocol2.setProtocolDocument((ProtocolDocumentBase)this.getProtocolDocument("2"));
        protocols.add(protocol2);
        return protocols;
    }

    private ProtocolDocument getProtocolDocument(String documentNumber) {
        ProtocolDocument document = new ProtocolDocument();
        document.setDocumentNumber(documentNumber);
        return document;
    }

    private KcNotificationService getMockKcNotificationService() {
        final KcNotificationService service = (KcNotificationService)this.context.mock(KcNotificationService.class);
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                this.ignoring(service);
            }
        });
        return service;
    }

    private DateTimeService getMockDateTimeService() {
        final DateTimeService service = (DateTimeService)this.context.mock(DateTimeService.class);
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                this.ignoring(service);
            }
        });
        return service;
    }
}

