/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.committee.service;

import java.util.ArrayList;
import java.util.List;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kra.committee.bo.Committee;
import org.kuali.kra.committee.document.CommitteeDocument;
import org.kuali.kra.committee.lookup.CommitteeLookupableHelperServiceImpl;
import org.kuali.kra.common.committee.document.CommitteeDocumentBase;
import org.kuali.kra.test.infrastructure.KcUnitTestBase;
import org.kuali.rice.kns.lookup.HtmlData;
import org.kuali.rice.kns.web.ui.Field;
import org.kuali.rice.kns.web.ui.Row;
import org.kuali.rice.krad.bo.BusinessObject;

public class CommitteeLookupHelperServiceTest
extends KcUnitTestBase {
    private static final int NUMBER_LOOKUP_CRITERIA_FIELDS = 9;
    private static final String EDIT_URL = "../committeeCommittee.do?committeeId=100&docTypeName=CommitteeDocument&methodToCall=docHandler&command=initiate";
    private CommitteeLookupableHelperServiceImpl committeeLookupableHelperServiceImpl;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.committeeLookupableHelperServiceImpl = new CommitteeLookupableHelperServiceImpl();
        this.committeeLookupableHelperServiceImpl.setBusinessObjectClass(Committee.class);
    }

    @Override
    @After
    public void tearDown() throws Exception {
        super.tearDown();
        this.committeeLookupableHelperServiceImpl = null;
    }

    @Test
    public void testGetRows() {
        List rows = this.committeeLookupableHelperServiceImpl.getRows();
        CommitteeLookupHelperServiceTest.assertEquals((long)rows.size(), (long)9L);
        for (Row row : rows) {
            for (Field field : row.getFields()) {
                if (field.getPropertyName().equals("researchAreaCode")) {
                    this.assertDropDownField(field, "researchAreaCode", "org.kuali.kra.bo.ResearchArea");
                    continue;
                }
                if (!field.getPropertyName().equals("memberName")) continue;
                this.assertDropDownField(field, "personName", "org.kuali.kra.committee.bo.CommitteeMembership");
            }
        }
    }

    @Test
    public void testGetCustomActionUrl() {
        ArrayList<String> pkNames = new ArrayList<String>();
        pkNames.add("committeeId");
        Committee committee = new Committee();
        committee.setCommitteeId("100");
        committee.setHomeUnitNumber("000001");
        CommitteeDocument document = new CommitteeDocument();
        document.setDocumentNumber("101");
        committee.setCommitteeDocument((CommitteeDocumentBase)document);
        List actionUrls = this.committeeLookupableHelperServiceImpl.getCustomActionUrls((BusinessObject)committee, pkNames);
        CommitteeLookupHelperServiceTest.assertEquals((Object)((HtmlData.AnchorHtmlData)actionUrls.get(0)).getHref(), (Object)EDIT_URL);
    }

    private void assertDropDownField(Field field, String keyName, String className) {
        CommitteeLookupHelperServiceTest.assertEquals((Object)field.getFieldConversions(), (Object)(keyName + ":" + field.getPropertyName()));
        CommitteeLookupHelperServiceTest.assertEquals((Object)field.getLookupParameters(), (Object)(field.getPropertyName() + ":" + keyName));
        CommitteeLookupHelperServiceTest.assertEquals((Object)field.getInquiryParameters(), (Object)(field.getPropertyName() + ":" + keyName));
        CommitteeLookupHelperServiceTest.assertEquals((Object)field.getQuickFinderClassNameImpl(), (Object)className);
    }
}

