/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.committee.service;

import java.sql.Date;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.jmock.Expectations;
import org.jmock.Mockery;
import org.jmock.integration.junit4.JUnit4Mockery;
import org.jmock.internal.ExpectationBuilder;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kra.committee.bo.Committee;
import org.kuali.kra.committee.bo.CommitteeMembership;
import org.kuali.kra.committee.bo.CommitteeMembershipExpertise;
import org.kuali.kra.committee.bo.CommitteeSchedule;
import org.kuali.kra.committee.service.CommitteeService;
import org.kuali.kra.committee.service.impl.CommitteeMembershipServiceImpl;
import org.kuali.kra.common.committee.bo.CommitteeBase;
import org.kuali.kra.common.committee.bo.CommitteeMembershipBase;
import org.kuali.kra.common.committee.bo.CommitteeMembershipExpertiseBase;
import org.kuali.kra.common.committee.bo.CommitteeMembershipRole;
import org.kuali.kra.common.committee.service.CommitteeServiceBase;
import org.kuali.kra.irb.ResearchArea;
import org.kuali.kra.irb.actions.submit.ProtocolSubmission;
import org.kuali.kra.irb.onlinereview.ProtocolOnlineReview;
import org.kuali.kra.meeting.CommitteeScheduleAttendance;
import org.kuali.kra.protocol.actions.submit.ProtocolReviewer;
import org.kuali.rice.krad.service.BusinessObjectService;

public class CommitteeMembershipServiceTest {
    private static final String PERSON_ID = "jtester";
    private static final Integer ROLODEX_ID = 1746;
    private static final String MEMBERSHIP_TYPE_CD = "1";
    private static final Date TERM_START_DATE = Date.valueOf("2009-01-01");
    private static final Date TERM_END_DATE = Date.valueOf("2009-01-31");
    private static final String MEMBERSHIP_ROLE_CD_1 = "1";
    private static final String MEMBERSHIP_ROLE_CD_4 = "4";
    private static final String MEMBERSHIP_ROLE_CD_7 = "7";
    private static final Date ROLE_START_DATE = Date.valueOf("2009-01-10");
    private static final Date ROLE_END_DATE = Date.valueOf("2009-01-20");
    private static final String RESEARCH_AREA_CODE_1 = "000001";
    private static final String RESEARCH_AREA_CODE_3 = "000003";
    private static final String RESEARCH_AREA_CODE_5 = "000005";
    private Mockery context = new JUnit4Mockery();
    private CommitteeMembershipServiceImpl committeeMembershipService;

    @Before
    public void setUp() {
        this.committeeMembershipService = new CommitteeMembershipServiceImpl();
    }

    @Test
    public void testAddCommitteeMembership() throws Exception {
        Committee committee = new Committee();
        this.committeeMembershipService.addCommitteeMembership((CommitteeBase)committee, (CommitteeMembershipBase)this.getMembership(PERSON_ID, null, "1", TERM_START_DATE, TERM_END_DATE));
        this.committeeMembershipService.addCommitteeMembership((CommitteeBase)committee, (CommitteeMembershipBase)this.getMembership(null, ROLODEX_ID, "1", TERM_START_DATE, TERM_END_DATE));
        Assert.assertEquals((long)2L, (long)committee.getCommitteeMemberships().size());
        Assert.assertEquals((Object)PERSON_ID, (Object)((CommitteeMembershipBase)committee.getCommitteeMemberships().get(0)).getPersonId());
        Assert.assertEquals(null, (Object)((CommitteeMembershipBase)committee.getCommitteeMemberships().get(0)).getRolodexId());
        Assert.assertEquals(null, (Object)((CommitteeMembershipBase)committee.getCommitteeMemberships().get(1)).getPersonId());
        Assert.assertEquals((Object)ROLODEX_ID, (Object)((CommitteeMembershipBase)committee.getCommitteeMemberships().get(1)).getRolodexId());
    }

    @Test
    public void testDeleteCommitteeMembership() throws Exception {
        Committee committee = new Committee();
        committee.getCommitteeMemberships().add(this.getMembership(PERSON_ID, null, "1", TERM_START_DATE, TERM_END_DATE));
        committee.getCommitteeMemberships().add(this.getMembership(null, ROLODEX_ID, "1", TERM_START_DATE, TERM_END_DATE));
        Assert.assertEquals((long)2L, (long)committee.getCommitteeMemberships().size());
        ((CommitteeMembershipBase)committee.getCommitteeMemberships().get(0)).setDelete(true);
        this.committeeMembershipService.deleteCommitteeMembership((CommitteeBase)committee);
        Assert.assertEquals((long)1L, (long)committee.getCommitteeMemberships().size());
        Assert.assertEquals(null, (Object)((CommitteeMembershipBase)committee.getCommitteeMemberships().get(0)).getPersonId());
        Assert.assertEquals((Object)ROLODEX_ID, (Object)((CommitteeMembershipBase)committee.getCommitteeMemberships().get(0)).getRolodexId());
    }

    @Test
    public void testAddCommitteeMembershipRole() throws Exception {
        Committee committee = new Committee();
        committee.getCommitteeMemberships().add(this.getMembership(PERSON_ID, null, "1", TERM_START_DATE, TERM_END_DATE));
        this.committeeMembershipService.addCommitteeMembershipRole((CommitteeBase)committee, 0, this.getRole("1", ROLE_START_DATE, ROLE_END_DATE));
        Assert.assertEquals((long)1L, (long)((CommitteeMembershipBase)committee.getCommitteeMemberships().get(0)).getMembershipRoles().size());
        Assert.assertEquals((Object)"1", (Object)((CommitteeMembershipRole)((CommitteeMembershipBase)committee.getCommitteeMemberships().get(0)).getMembershipRoles().get(0)).getMembershipRoleCode());
        Assert.assertEquals((Object)ROLE_END_DATE, (Object)((CommitteeMembershipRole)((CommitteeMembershipBase)committee.getCommitteeMemberships().get(0)).getMembershipRoles().get(0)).getEndDate());
    }

    @Test
    public void testDeleteCommitteeMembershipRole() throws Exception {
        Committee committee = new Committee();
        CommitteeMembership committeeMembership = this.getMembership(PERSON_ID, null, "1", TERM_START_DATE, TERM_END_DATE);
        committeeMembership.getMembershipRoles().add(this.getRole("1", null, null));
        committeeMembership.getMembershipRoles().add(this.getRole(MEMBERSHIP_ROLE_CD_4, null, null));
        committeeMembership.getMembershipRoles().add(this.getRole(MEMBERSHIP_ROLE_CD_7, null, null));
        committee.getCommitteeMemberships().add(committeeMembership);
        Assert.assertEquals((long)3L, (long)((CommitteeMembershipBase)committee.getCommitteeMemberships().get(0)).getMembershipRoles().size());
        this.committeeMembershipService.deleteCommitteeMembershipRole((CommitteeBase)committee, 0, 1);
        Assert.assertEquals((long)2L, (long)((CommitteeMembershipBase)committee.getCommitteeMemberships().get(0)).getMembershipRoles().size());
        Assert.assertEquals((Object)"1", (Object)((CommitteeMembershipRole)((CommitteeMembershipBase)committee.getCommitteeMemberships().get(0)).getMembershipRoles().get(0)).getMembershipRoleCode());
        Assert.assertEquals((Object)MEMBERSHIP_ROLE_CD_7, (Object)((CommitteeMembershipRole)((CommitteeMembershipBase)committee.getCommitteeMemberships().get(0)).getMembershipRoles().get(1)).getMembershipRoleCode());
    }

    @Test
    public void testAddCommitteeMembershipExpertise() throws Exception {
        CommitteeMembership committeeMembership = this.getMembership(PERSON_ID, null, "1", TERM_START_DATE, TERM_END_DATE);
        this.committeeMembershipService.addCommitteeMembershipExpertise((CommitteeMembershipBase)committeeMembership, this.getResearchAreas());
        Assert.assertEquals((long)3L, (long)committeeMembership.getMembershipExpertise().size());
        Assert.assertEquals((Object)RESEARCH_AREA_CODE_1, (Object)((CommitteeMembershipExpertiseBase)committeeMembership.getMembershipExpertise().get(0)).getResearchAreaCode());
        Assert.assertEquals((Object)RESEARCH_AREA_CODE_3, (Object)((CommitteeMembershipExpertiseBase)committeeMembership.getMembershipExpertise().get(1)).getResearchAreaCode());
        Assert.assertEquals((Object)RESEARCH_AREA_CODE_5, (Object)((CommitteeMembershipExpertiseBase)committeeMembership.getMembershipExpertise().get(2)).getResearchAreaCode());
    }

    @Test
    public void testDeleteCommitteeMembershipExpertise() throws Exception {
        Committee committee = new Committee();
        CommitteeMembership committeeMembership = this.getMembership(PERSON_ID, null, "1", TERM_START_DATE, TERM_END_DATE);
        committeeMembership.getMembershipExpertise().add(this.getExpertise(RESEARCH_AREA_CODE_1));
        committeeMembership.getMembershipExpertise().add(this.getExpertise(RESEARCH_AREA_CODE_3));
        committeeMembership.getMembershipExpertise().add(this.getExpertise(RESEARCH_AREA_CODE_5));
        committee.getCommitteeMemberships().add(committeeMembership);
        Assert.assertEquals((long)3L, (long)((CommitteeMembershipBase)committee.getCommitteeMemberships().get(0)).getMembershipExpertise().size());
        this.committeeMembershipService.deleteCommitteeMembershipExpertise((CommitteeBase)committee, 0, 1);
        Assert.assertEquals((long)2L, (long)((CommitteeMembershipBase)committee.getCommitteeMemberships().get(0)).getMembershipExpertise().size());
        Assert.assertEquals((Object)RESEARCH_AREA_CODE_1, (Object)((CommitteeMembershipExpertiseBase)((CommitteeMembershipBase)committee.getCommitteeMemberships().get(0)).getMembershipExpertise().get(0)).getResearchAreaCode());
        Assert.assertEquals((Object)RESEARCH_AREA_CODE_5, (Object)((CommitteeMembershipExpertiseBase)((CommitteeMembershipBase)committee.getCommitteeMemberships().get(0)).getMembershipExpertise().get(1)).getResearchAreaCode());
    }

    @Test
    public void testIsMemberAssignedToReviewer() throws Exception {
        final BusinessObjectService businessObjectService = (BusinessObjectService)this.context.mock(BusinessObjectService.class);
        final HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put("committeeId", "test");
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((BusinessObjectService)this.one(businessObjectService)).findMatching(ProtocolSubmission.class, fieldValues);
                this.will(1.returnValue((Object)CommitteeMembershipServiceTest.this.getProtocolSubmissions()));
            }
        });
        this.committeeMembershipService.setBusinessObjectService(businessObjectService);
        ArrayList committeeMemberships = new ArrayList();
        CommitteeMembership committeeMembership = this.createMembership("100", null, "1", "2009-01-01", "2009-01-10");
        committeeMembership.setDelete(true);
        Assert.assertTrue((boolean)this.committeeMembershipService.isMemberAssignedToReviewer((CommitteeMembershipBase)committeeMembership, "test"));
    }

    @Test
    public void testIsMemberAssignedAsAttendance() throws Exception {
        final Committee activeCommittee = new Committee();
        activeCommittee.setCommitteeId("test");
        ArrayList<CommitteeSchedule> schedules = new ArrayList<CommitteeSchedule>();
        CommitteeScheduleAttendance attendance = new CommitteeScheduleAttendance();
        CommitteeSchedule schedule = new CommitteeSchedule();
        ArrayList<CommitteeScheduleAttendance> attendances = new ArrayList<CommitteeScheduleAttendance>();
        attendance.setPersonId("100");
        attendances.add(attendance);
        schedules.add(schedule);
        schedule.setCommitteeScheduleAttendances(attendances);
        activeCommittee.setCommitteeSchedules(schedules);
        final CommitteeService committeeService = (CommitteeService)this.context.mock(CommitteeService.class);
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((CommitteeService)this.one(committeeService)).getCommitteeById("test");
                this.will(2.returnValue((Object)activeCommittee));
            }
        });
        this.committeeMembershipService.setCommitteeService((CommitteeServiceBase)committeeService);
        ArrayList committeeMemberships = new ArrayList();
        CommitteeMembership committeeMembership = this.createMembership("100", null, "1", "2009-01-01", "2009-01-10");
        committeeMembership.setDelete(true);
        Assert.assertTrue((boolean)this.committeeMembershipService.isMemberAttendedMeeting((CommitteeMembershipBase)committeeMembership, "test"));
    }

    private List<ProtocolSubmission> getProtocolSubmissions() {
        ArrayList<ProtocolSubmission> submissions = new ArrayList<ProtocolSubmission>();
        ArrayList<ProtocolOnlineReview> reviews = new ArrayList<ProtocolOnlineReview>();
        ProtocolOnlineReview review = new ProtocolOnlineReview();
        org.kuali.kra.irb.actions.submit.ProtocolReviewer reviewer = new org.kuali.kra.irb.actions.submit.ProtocolReviewer();
        reviewer.setPersonId("100");
        review.setProtocolReviewer((ProtocolReviewer)reviewer);
        reviews.add(review);
        ProtocolSubmission submission = new ProtocolSubmission();
        submission.setProtocolOnlineReviews(reviews);
        submissions.add(submission);
        return submissions;
    }

    private CommitteeMembership createMembership(String personID, Integer rolodexID, String membershipTypeCode, String termStartDate, String termEndDate) {
        CommitteeMembership committeeMembership = new CommitteeMembership();
        committeeMembership.setPersonId(personID);
        committeeMembership.setRolodexId(rolodexID);
        committeeMembership.setMembershipTypeCode(membershipTypeCode);
        if (termStartDate != null) {
            committeeMembership.setTermStartDate(Date.valueOf(termStartDate));
        }
        if (termEndDate != null) {
            committeeMembership.setTermEndDate(Date.valueOf(termEndDate));
        }
        return committeeMembership;
    }

    private CommitteeMembership getMembership(String personID, Integer rolodexID, String membershipTypeCode, Date termStartDate, Date termEndDate) {
        CommitteeMembership committeeMembership = new CommitteeMembership();
        committeeMembership.setPersonId(personID);
        committeeMembership.setRolodexId(rolodexID);
        committeeMembership.setMembershipTypeCode(membershipTypeCode);
        committeeMembership.setTermStartDate(termStartDate);
        committeeMembership.setTermEndDate(termEndDate);
        return committeeMembership;
    }

    private CommitteeMembershipRole getRole(String membershipRoleCode, Date startDate, Date endDate) {
        CommitteeMembershipRole committeeMembershipRole = new CommitteeMembershipRole();
        committeeMembershipRole.setMembershipRoleCode(membershipRoleCode);
        committeeMembershipRole.setStartDate(startDate);
        committeeMembershipRole.setEndDate(endDate);
        return committeeMembershipRole;
    }

    private CommitteeMembershipExpertise getExpertise(String researchAreaCode) {
        CommitteeMembershipExpertise committeeMembershipExpertise = new CommitteeMembershipExpertise();
        committeeMembershipExpertise.setResearchAreaCode(researchAreaCode);
        return committeeMembershipExpertise;
    }

    private Collection<ResearchArea> getResearchAreas() {
        ArrayList<ResearchArea> researchAreas = new ArrayList<ResearchArea>();
        researchAreas.add(new ResearchArea(RESEARCH_AREA_CODE_1, null, null, true));
        researchAreas.add(new ResearchArea(RESEARCH_AREA_CODE_3, null, null, true));
        researchAreas.add(new ResearchArea(RESEARCH_AREA_CODE_5, null, null, true));
        return researchAreas;
    }
}

