/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.committee.service;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jmock.Expectations;
import org.jmock.Mockery;
import org.jmock.integration.junit4.JUnit4Mockery;
import org.jmock.internal.ExpectationBuilder;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kra.authorization.Task;
import org.kuali.kra.committee.bo.Committee;
import org.kuali.kra.committee.bo.CommitteeSchedule;
import org.kuali.kra.committee.document.CommitteeDocument;
import org.kuali.kra.committee.lookup.CommitteeScheduleLookupableHelperServiceImpl;
import org.kuali.kra.common.committee.document.CommitteeDocumentBase;
import org.kuali.kra.service.TaskAuthorizationService;
import org.kuali.kra.test.infrastructure.KcUnitTestBase;
import org.kuali.rice.kns.lookup.HtmlData;
import org.kuali.rice.krad.UserSession;
import org.kuali.rice.krad.bo.BusinessObject;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.util.GlobalVariables;

public class CommitteeScheduleLookupableHelperServiceTest
extends KcUnitTestBase {
    private static final String COMMITTEE_ID = "committeeId";
    private static final String SEQUENCE_NUMBER = "sequenceNumber";
    private static final Long C1_LATEST_PK = 1L;
    private static final Long C2_LATEST_PK = 2L;
    private static final Long C3_LATEST_PK = 3L;
    private static final Long C4_LATEST_PK = 4L;
    private static final Long C1_OLD_PK = 11L;
    private static final Long C2_OLD_PK = 22L;
    private static final Long C3_OLD_PK = 33L;
    private static final Long C3_OLDER_PK = 333L;
    private static final String EDIT_URL = "../meetingManagement.do?scheduleId=102&methodToCall=start&readOnly=false";
    private static final String VIEW_URL = "../meetingManagement.do?scheduleId=102&methodToCall=start&readOnly=true";
    private static final String COMMITTEE_INQ_URL = "inquiry.do?businessObjectClassName=org.kuali.kra.committee.bo.Committee&methodToCall=start&id=103";
    private CommitteeScheduleLookupableHelperServiceImpl service;
    private Mockery context = new JUnit4Mockery();

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.service = new CommitteeScheduleLookupableHelperServiceImpl();
        this.service.setBusinessObjectClass(CommitteeSchedule.class);
        GlobalVariables.setUserSession((UserSession)new UserSession("quickstart"));
    }

    @Override
    @After
    public void tearDown() throws Exception {
        super.tearDown();
        this.service = null;
        GlobalVariables.setUserSession(null);
    }

    @Test
    public void testGetCustomActionUrl() {
        this.service.setTaskAuthorizationService(this.getMockTaskAuthorizationService());
        List actionUrls = this.service.getCustomActionUrls((BusinessObject)this.initCommitteeSchedule(), Collections.singletonList(COMMITTEE_ID));
        CommitteeScheduleLookupableHelperServiceTest.assertEquals((long)2L, (long)actionUrls.size());
        CommitteeScheduleLookupableHelperServiceTest.assertTrue((boolean)((HtmlData)actionUrls.get(0)).getDisplayText().equals("edit"));
        CommitteeScheduleLookupableHelperServiceTest.assertEquals((Object)((HtmlData.AnchorHtmlData)actionUrls.get(0)).getHref(), (Object)EDIT_URL);
        CommitteeScheduleLookupableHelperServiceTest.assertTrue((boolean)((HtmlData)actionUrls.get(1)).getDisplayText().equals("view"));
        CommitteeScheduleLookupableHelperServiceTest.assertEquals((Object)((HtmlData.AnchorHtmlData)actionUrls.get(1)).getHref(), (Object)VIEW_URL);
        this.context.assertIsSatisfied();
    }

    private TaskAuthorizationService getMockTaskAuthorizationService() {
        final TaskAuthorizationService service = (TaskAuthorizationService)this.context.mock(TaskAuthorizationService.class);
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((TaskAuthorizationService)this.one(service)).isAuthorized((String)this.with(1.any(String.class)), (Task)this.with(1.any(Task.class)));
                this.will(1.returnValue((Object)true));
            }
        });
        return service;
    }

    @Test
    public void testIsCurrentVersion() throws Exception {
        Committee committee1 = new Committee();
        committee1.setCommitteeId("c1");
        committee1.setId(C1_LATEST_PK);
        Committee committee1Old = new Committee();
        committee1Old.setCommitteeId("c1");
        committee1Old.setId(C1_OLD_PK);
        final ArrayList<Committee> c1Versionslist = new ArrayList<Committee>();
        c1Versionslist.add(committee1);
        c1Versionslist.add(committee1Old);
        Committee committee2 = new Committee();
        committee2.setCommitteeId("c2");
        committee2.setId(C2_LATEST_PK);
        Committee committee2Old = new Committee();
        committee2Old.setCommitteeId("c2");
        committee2Old.setId(C2_OLD_PK);
        final ArrayList<Committee> c2Versionslist = new ArrayList<Committee>();
        c2Versionslist.add(committee2);
        c2Versionslist.add(committee2Old);
        Committee committee3 = new Committee();
        committee3.setCommitteeId("c3");
        committee3.setId(C3_LATEST_PK);
        Committee committee3Old = new Committee();
        committee3Old.setCommitteeId("c3");
        committee3Old.setId(C3_OLD_PK);
        Committee committee3Older = new Committee();
        committee3Older.setCommitteeId("c3");
        committee3Older.setId(C3_OLDER_PK);
        final ArrayList<Committee> c3Versionslist = new ArrayList<Committee>();
        c3Versionslist.add(committee3);
        c3Versionslist.add(committee3Old);
        c3Versionslist.add(committee3Older);
        Committee committee4 = new Committee();
        committee4.setCommitteeId("c4");
        committee4.setId(C4_LATEST_PK);
        final ArrayList<Committee> c4Versionslist = new ArrayList<Committee>();
        c4Versionslist.add(committee4);
        final HashMap<String, String> hm1 = new HashMap<String, String>();
        hm1.put(COMMITTEE_ID, "c1");
        final HashMap<String, String> hm2 = new HashMap<String, String>();
        hm2.put(COMMITTEE_ID, "c2");
        final HashMap<String, String> hm3 = new HashMap<String, String>();
        hm3.put(COMMITTEE_ID, "c3");
        final HashMap<String, String> hm4 = new HashMap<String, String>();
        hm4.put(COMMITTEE_ID, "c4");
        final BusinessObjectService businessObjectService = (BusinessObjectService)this.context.mock(BusinessObjectService.class);
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((BusinessObjectService)this.oneOf(businessObjectService)).findMatchingOrderBy(Committee.class, (Map)hm1, CommitteeScheduleLookupableHelperServiceTest.SEQUENCE_NUMBER, false);
                this.will(2.returnValue((Object)c1Versionslist));
                ((BusinessObjectService)this.oneOf(businessObjectService)).findMatchingOrderBy(Committee.class, (Map)hm2, CommitteeScheduleLookupableHelperServiceTest.SEQUENCE_NUMBER, false);
                this.will(2.returnValue((Object)c2Versionslist));
                ((BusinessObjectService)this.oneOf(businessObjectService)).findMatchingOrderBy(Committee.class, (Map)hm3, CommitteeScheduleLookupableHelperServiceTest.SEQUENCE_NUMBER, false);
                this.will(2.returnValue((Object)c3Versionslist));
                ((BusinessObjectService)this.oneOf(businessObjectService)).findMatchingOrderBy(Committee.class, (Map)hm4, CommitteeScheduleLookupableHelperServiceTest.SEQUENCE_NUMBER, false);
                this.will(2.returnValue((Object)c4Versionslist));
            }
        });
        this.service = new CommitteeScheduleLookupableHelperServiceImpl();
        this.service.setBusinessObjectService(businessObjectService);
        Assert.assertTrue((boolean)this.invoke_isCurrentVersion(committee1));
        Assert.assertTrue((boolean)this.invoke_isCurrentVersion(committee2));
        Assert.assertTrue((boolean)this.invoke_isCurrentVersion(committee3));
        Assert.assertTrue((boolean)this.invoke_isCurrentVersion(committee4));
        Assert.assertFalse((boolean)this.invoke_isCurrentVersion(committee1Old));
        Assert.assertFalse((boolean)this.invoke_isCurrentVersion(committee2Old));
        Assert.assertFalse((boolean)this.invoke_isCurrentVersion(committee3Old));
        Assert.assertFalse((boolean)this.invoke_isCurrentVersion(committee3Older));
        this.context.assertIsSatisfied();
    }

    private boolean invoke_isCurrentVersion(Committee committee) throws Exception {
        Method m = this.service.getClass().getDeclaredMethod("isCurrentVersion", Committee.class);
        m.setAccessible(true);
        return (Boolean)m.invoke((Object)this.service, committee);
    }

    @Test
    public void testGetInquiryUrl() {
        HtmlData inquiryUrl = this.service.getInquiryUrl((BusinessObject)this.initCommitteeSchedule(), "committee.committeeId");
        CommitteeScheduleLookupableHelperServiceTest.assertEquals((Object)((HtmlData.AnchorHtmlData)inquiryUrl).getHref(), (Object)COMMITTEE_INQ_URL);
        this.context.assertIsSatisfied();
    }

    private CommitteeSchedule initCommitteeSchedule() {
        Committee committee = new Committee();
        committee.setId(Long.valueOf(103L));
        committee.setCommitteeId("100");
        committee.setHomeUnitNumber("000001");
        CommitteeDocument document = new CommitteeDocument();
        document.setDocumentNumber("101");
        committee.setCommitteeDocument((CommitteeDocumentBase)document);
        CommitteeSchedule committeeSchedule = new CommitteeSchedule();
        committeeSchedule.setId(Long.valueOf(102L));
        committeeSchedule.setCommittee(committee);
        return committeeSchedule;
    }
}

