/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.committee.service;

import java.sql.Date;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.LinkedList;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.time.DateUtils;
import org.jmock.Expectations;
import org.jmock.Mockery;
import org.jmock.integration.junit4.JUnit4Mockery;
import org.jmock.internal.ExpectationBuilder;
import org.jmock.lib.legacy.ClassImposteriser;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kra.committee.bo.Committee;
import org.kuali.kra.committee.bo.CommitteeSchedule;
import org.kuali.kra.committee.service.impl.CommitteeScheduleServiceImpl;
import org.kuali.kra.common.committee.bo.CommitteeBase;
import org.kuali.kra.common.committee.bo.CommitteeScheduleBase;
import org.kuali.kra.common.committee.bo.ScheduleStatus;
import org.kuali.kra.common.committee.web.struts.form.schedule.DailyScheduleDetails;
import org.kuali.kra.common.committee.web.struts.form.schedule.DayOfWeek;
import org.kuali.kra.common.committee.web.struts.form.schedule.MonthlyScheduleDetails;
import org.kuali.kra.common.committee.web.struts.form.schedule.ScheduleData;
import org.kuali.kra.common.committee.web.struts.form.schedule.StyleKey;
import org.kuali.kra.common.committee.web.struts.form.schedule.Time12HrFmt;
import org.kuali.kra.common.committee.web.struts.form.schedule.WeeklyScheduleDetails;
import org.kuali.kra.common.committee.web.struts.form.schedule.YearlyScheduleDetails;
import org.kuali.kra.irb.Protocol;
import org.kuali.kra.scheduling.expr.util.CronSpecialChars;
import org.kuali.kra.scheduling.sequence.DefaultScheduleSequence;
import org.kuali.kra.scheduling.sequence.ScheduleSequence;
import org.kuali.kra.scheduling.sequence.WeekScheduleSequenceDecorator;
import org.kuali.kra.scheduling.service.ScheduleService;
import org.kuali.kra.scheduling.util.Time24HrFmt;
import org.kuali.rice.krad.service.BusinessObjectService;

public class CommitteeScheduleServiceImplTest {
    public static final String TIME24HR_0_1 = "0:1";
    public static final String TIME24HR_23_59 = "23:59";
    public static final String TIME12HR_11_59 = "11:59";
    public static final String TIME12HR_00_01 = "00:01";
    private Mockery context;
    private BusinessObjectService boService;
    private ScheduleService scheduleService;
    private CommitteeScheduleServiceImpl service;
    private CommitteeSchedule committeeSchedule;
    private ScheduleData scheduleData;
    private Committee committee;

    @Before
    public void setUp() throws Exception {
        this.context = new JUnit4Mockery(){
            {
                this.setImposteriser(ClassImposteriser.INSTANCE);
            }
        };
        this.boService = (BusinessObjectService)this.context.mock(BusinessObjectService.class);
        this.scheduleService = (ScheduleService)this.context.mock(ScheduleService.class);
        this.service = new CommitteeScheduleServiceImpl();
        this.service.setBusinessObjectService(this.boService);
        this.service.setScheduleService(this.scheduleService);
        this.committeeSchedule = new CommitteeSchedule();
    }

    @Test
    public void testAddScheduleYearlyRecurrenceCmplx() throws Exception {
        this.prerequisite();
        this.yearlyPrerequisite();
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                Date dt = CommitteeScheduleServiceImplTest.this.scheduleData.getScheduleStartDate();
                Date endDt = CommitteeScheduleServiceImplTest.this.scheduleData.getYearlySchedule().getScheduleEndDate();
                LinkedList<java.util.Date> dates = new LinkedList<java.util.Date>();
                dates.add(new java.util.Date());
                Time24HrFmt time = new Time24HrFmt(CommitteeScheduleServiceImplTest.TIME24HR_0_1);
                CronSpecialChars weekOfMonth = ScheduleData.getWeekOfMonth((String)CommitteeScheduleServiceImplTest.this.scheduleData.getYearlySchedule().getSelectedMonthsWeek());
                CronSpecialChars dayOfWeek = ScheduleData.getDayOfWeek((String)CommitteeScheduleServiceImplTest.this.scheduleData.getYearlySchedule().getSelectedDayOfWeek());
                CronSpecialChars month = ScheduleData.getMonthOfWeek((String)CommitteeScheduleServiceImplTest.this.scheduleData.getYearlySchedule().getSelectedOption2Month());
                int frequency = CommitteeScheduleServiceImplTest.this.scheduleData.getYearlySchedule().getOption2Year();
                ((ScheduleService)this.one(CommitteeScheduleServiceImplTest.this.scheduleService)).getScheduledDates((java.util.Date)dt, (java.util.Date)endDt, time, weekOfMonth, dayOfWeek, month, Integer.valueOf(frequency), null);
                this.will(2.returnValue(dates));
            }
        });
        this.scheduleData.getYearlySchedule().setYearOption(YearlyScheduleDetails.yearOptionValues.CMPLX.toString());
        this.test(1);
    }

    @Test
    public void testAddScheduleYearlyRecurrenceXday() throws Exception {
        this.prerequisite();
        this.yearlyPrerequisite();
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                Date dt = CommitteeScheduleServiceImplTest.this.scheduleData.getScheduleStartDate();
                Date endDt = CommitteeScheduleServiceImplTest.this.scheduleData.getYearlySchedule().getScheduleEndDate();
                LinkedList<java.util.Date> dates = new LinkedList<java.util.Date>();
                dates.add(new java.util.Date());
                Time24HrFmt time = new Time24HrFmt(CommitteeScheduleServiceImplTest.TIME24HR_0_1);
                CronSpecialChars month = ScheduleData.getMonthOfWeek((String)CommitteeScheduleServiceImplTest.this.scheduleData.getYearlySchedule().getSelectedOption1Month());
                int day = CommitteeScheduleServiceImplTest.this.scheduleData.getYearlySchedule().getDay();
                int frequency = CommitteeScheduleServiceImplTest.this.scheduleData.getYearlySchedule().getOption1Year();
                ((ScheduleService)this.one(CommitteeScheduleServiceImplTest.this.scheduleService)).getScheduledDates((java.util.Date)dt, (java.util.Date)endDt, time, month, Integer.valueOf(day), Integer.valueOf(frequency), null);
                this.will(3.returnValue(dates));
            }
        });
        this.scheduleData.getYearlySchedule().setYearOption(YearlyScheduleDetails.yearOptionValues.XDAY.toString());
        this.test(1);
    }

    private void yearlyPrerequisite() {
        this.scheduleData.setRecurrenceType(StyleKey.YEARLY.toString());
        this.scheduleData.setYearlySchedule(new YearlyScheduleDetails());
        int day = this.getDay(this.scheduleData.getScheduleStartDate(), 5);
        int month = this.getDay(this.scheduleData.getScheduleStartDate(), 2);
        this.scheduleData.setScheduleStartDate(this.getDate(-day - month * 31));
        this.scheduleData.getYearlySchedule().setScheduleEndDate(this.getDate(-day - month * 31 + 10));
    }

    @Test
    public void testAddScheduleMonthlyRecurrenceXdayofweekAndXmonth() throws Exception {
        this.prerequisite();
        this.monthlyPrerequisite();
        int day = this.getDay(this.scheduleData.getScheduleStartDate(), 5);
        this.scheduleData.setScheduleStartDate(this.getDate(-day));
        this.scheduleData.getMonthlySchedule().setScheduleEndDate(this.getDate(-day + 7));
        this.scheduleData.getMonthlySchedule().setMonthOption(MonthlyScheduleDetails.optionValues.XDAYOFWEEKANDXMONTH.toString());
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                Date dt = CommitteeScheduleServiceImplTest.this.scheduleData.getScheduleStartDate();
                Date endDt = CommitteeScheduleServiceImplTest.this.scheduleData.getMonthlySchedule().getScheduleEndDate();
                LinkedList<java.util.Date> dates = new LinkedList<java.util.Date>();
                dates.add(new java.util.Date());
                Time24HrFmt time = new Time24HrFmt(CommitteeScheduleServiceImplTest.TIME24HR_0_1);
                CronSpecialChars weekOfMonth = ScheduleData.getWeekOfMonth((String)CommitteeScheduleServiceImplTest.this.scheduleData.getMonthlySchedule().getSelectedMonthsWeek());
                CronSpecialChars dayOfWeek = ScheduleData.getDayOfWeek((String)CommitteeScheduleServiceImplTest.this.scheduleData.getMonthlySchedule().getSelectedDayOfWeek());
                int frequency = CommitteeScheduleServiceImplTest.this.scheduleData.getMonthlySchedule().getOption2Month();
                ((ScheduleService)this.one(CommitteeScheduleServiceImplTest.this.scheduleService)).getScheduledDates((java.util.Date)dt, (java.util.Date)endDt, time, dayOfWeek, weekOfMonth, Integer.valueOf(frequency), null);
                this.will(4.returnValue(dates));
            }
        });
        this.test(1);
    }

    @Test
    public void testAddScheduleMonthlyRecurrenceXdayAndXmonth() throws Exception {
        this.prerequisite();
        this.monthlyPrerequisite();
        int day = this.getDay(this.scheduleData.getScheduleStartDate(), 5);
        this.scheduleData.getMonthlySchedule().setDay(Integer.valueOf(day + 1));
        this.scheduleData.getMonthlySchedule().setScheduleEndDate(this.getDate(1));
        this.scheduleData.getMonthlySchedule().setMonthOption(MonthlyScheduleDetails.optionValues.XDAYANDXMONTH.toString());
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                Date dt = CommitteeScheduleServiceImplTest.this.scheduleData.getScheduleStartDate();
                Date endDt = CommitteeScheduleServiceImplTest.this.scheduleData.getMonthlySchedule().getScheduleEndDate();
                LinkedList<java.util.Date> dates = new LinkedList<java.util.Date>();
                dates.add(new java.util.Date());
                Time24HrFmt time = new Time24HrFmt(CommitteeScheduleServiceImplTest.TIME24HR_0_1);
                int day = CommitteeScheduleServiceImplTest.this.scheduleData.getMonthlySchedule().getDay();
                int frequency = CommitteeScheduleServiceImplTest.this.scheduleData.getMonthlySchedule().getOption1Month();
                ((ScheduleService)this.one(CommitteeScheduleServiceImplTest.this.scheduleService)).getScheduledDates((java.util.Date)dt, (java.util.Date)endDt, time, Integer.valueOf(day), Integer.valueOf(frequency), null);
                this.will(5.returnValue(dates));
            }
        });
        this.test(1);
    }

    private int getDay(java.util.Date dt, int type) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(dt);
        int day = cal.get(type);
        return day;
    }

    private void monthlyPrerequisite() {
        this.scheduleData.setRecurrenceType(StyleKey.MONTHLY.toString());
        this.scheduleData.setMonthlySchedule(new MonthlyScheduleDetails());
    }

    @Test
    public void testAddScheduleWeeklyRecurrence() throws Exception {
        this.prerequisite();
        this.scheduleData.setRecurrenceType(StyleKey.WEEKLY.toString());
        this.scheduleData.setWeeklySchedule(new WeeklyScheduleDetails());
        this.scheduleData.getWeeklySchedule().setScheduleEndDate(this.getDate(7));
        ArrayList<String> daysOfWeek = new ArrayList<String>(2);
        daysOfWeek.add(DayOfWeek.Monday.name());
        daysOfWeek.add("Hidden");
        this.scheduleData.getWeeklySchedule().setDaysOfWeek(daysOfWeek);
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                Date dt = CommitteeScheduleServiceImplTest.this.scheduleData.getScheduleStartDate();
                Date endDt = CommitteeScheduleServiceImplTest.this.scheduleData.getWeeklySchedule().getScheduleEndDate();
                LinkedList<java.util.Date> dates = new LinkedList<java.util.Date>();
                dates.add(new java.util.Date());
                Time24HrFmt time = new Time24HrFmt(CommitteeScheduleServiceImplTest.TIME24HR_0_1);
                CronSpecialChars[] dow = null;
                if (CollectionUtils.isNotEmpty((Collection)CommitteeScheduleServiceImplTest.this.scheduleData.getWeeklySchedule().getDaysOfWeek())) {
                    dow = ScheduleData.convertToWeekdays((String[])CommitteeScheduleServiceImplTest.this.scheduleData.getWeeklySchedule().getDaysOfWeek().toArray(new String[CommitteeScheduleServiceImplTest.this.scheduleData.getWeeklySchedule().getDaysOfWeek().size()]));
                }
                WeekScheduleSequenceDecorator scheduleSequence = new WeekScheduleSequenceDecorator((ScheduleSequence)new DefaultScheduleSequence(), CommitteeScheduleServiceImplTest.this.scheduleData.getWeeklySchedule().getWeek(), Integer.valueOf(dow.length));
                ((ScheduleService)this.one(CommitteeScheduleServiceImplTest.this.scheduleService)).getScheduledDates((java.util.Date)dt, (java.util.Date)endDt, time, dow, (ScheduleSequence)scheduleSequence);
                this.will(6.returnValue(dates));
            }
        });
        this.test(1);
    }

    @Test
    public void testAddScheduleDailyRecurrenceWeekday() throws Exception {
        this.prerequisite();
        this.scheduleData.setRecurrenceType(StyleKey.DAILY.toString());
        this.scheduleData.setDailySchedule(new DailyScheduleDetails());
        this.scheduleData.getDailySchedule().setScheduleEndDate(this.getDate(1));
        this.scheduleData.getDailySchedule().setDayOption(DailyScheduleDetails.optionValues.WEEKDAY.toString());
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                Date dt = CommitteeScheduleServiceImplTest.this.scheduleData.getScheduleStartDate();
                Date endDt = CommitteeScheduleServiceImplTest.this.scheduleData.getDailySchedule().getScheduleEndDate();
                LinkedList<java.util.Date> dates = new LinkedList<java.util.Date>();
                dates.add(new java.util.Date());
                Time24HrFmt time = new Time24HrFmt(CommitteeScheduleServiceImplTest.TIME24HR_0_1);
                CronSpecialChars[] dow = ScheduleData.convertToWeekdays((String[])CommitteeScheduleServiceImplTest.this.scheduleData.getDailySchedule().getDaysOfWeek());
                WeekScheduleSequenceDecorator scheduleSequence = new WeekScheduleSequenceDecorator((ScheduleSequence)new DefaultScheduleSequence(), Integer.valueOf(1), Integer.valueOf(dow.length));
                ((ScheduleService)this.one(CommitteeScheduleServiceImplTest.this.scheduleService)).getScheduledDates((java.util.Date)dt, (java.util.Date)endDt, time, dow, (ScheduleSequence)scheduleSequence);
                this.will(7.returnValue(dates));
            }
        });
        this.test(1);
    }

    @Test
    public void testAddScheduleDailyRecurrenceXday() throws Exception {
        this.prerequisite();
        this.dailyPrerequisite();
        this.scheduleData.getDailySchedule().setDayOption(DailyScheduleDetails.optionValues.XDAY.toString());
        this.test(2);
    }

    @Test
    public void testAddScheduleAdvancedSubmissionDays() throws Exception {
        this.prerequisite();
        this.scheduleData.setRecurrenceType(StyleKey.NEVER.toString());
        this.scheduleData.setTime(new Time12HrFmt(TIME12HR_11_59, Time12HrFmt.MERIDIEM.PM));
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                Date dt = CommitteeScheduleServiceImplTest.this.scheduleData.getScheduleStartDate();
                LinkedList<java.util.Date> dates = new LinkedList<java.util.Date>();
                dates.add(new java.util.Date());
                Time24HrFmt time = new Time24HrFmt(CommitteeScheduleServiceImplTest.TIME24HR_23_59);
                ((ScheduleService)this.one(CommitteeScheduleServiceImplTest.this.scheduleService)).getScheduledDates((java.util.Date)dt, (java.util.Date)dt, time, null);
                this.will(8.returnValue(dates));
            }
        });
        this.test(1);
        Date testDate = ((CommitteeSchedule)this.committee.getCommitteeSchedules().get(0)).getProtocolSubDeadline();
        Date expectedDate = new Date(DateUtils.addDays((java.util.Date)new java.util.Date(), (int)(-this.committee.getAdvancedSubmissionDaysRequired().intValue())).getTime());
        Assert.assertEquals((Object)expectedDate.toString(), (Object)testDate.toString());
    }

    @Test
    public void testAddScheduleDuplicateDates() throws Exception {
        this.prerequisite();
        this.scheduleData.setRecurrenceType(StyleKey.DAILY.toString());
        this.scheduleData.setDailySchedule(new DailyScheduleDetails());
        this.scheduleData.getDailySchedule().setScheduleEndDate(this.getDate(2));
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                Date dt = CommitteeScheduleServiceImplTest.this.scheduleData.getScheduleStartDate();
                Date endDt = CommitteeScheduleServiceImplTest.this.scheduleData.getDailySchedule().getScheduleEndDate();
                LinkedList<java.util.Date> dates = new LinkedList<java.util.Date>();
                dates.add(new java.util.Date());
                dates.add(new java.util.Date());
                dates.add(DateUtils.addDays((java.util.Date)new java.util.Date(), (int)2));
                Time24HrFmt time = new Time24HrFmt(CommitteeScheduleServiceImplTest.TIME24HR_0_1);
                int day = CommitteeScheduleServiceImplTest.this.scheduleData.getDailySchedule().getDay();
                ((ScheduleService)this.one(CommitteeScheduleServiceImplTest.this.scheduleService)).getIntervalInDaysScheduledDates((java.util.Date)dt, (java.util.Date)endDt, time, Integer.valueOf(day));
                this.will(9.returnValue(dates));
            }
        });
        this.scheduleData.getDailySchedule().setDayOption(DailyScheduleDetails.optionValues.XDAY.toString());
        this.test(2);
        Assert.assertEquals((long)1L, (long)this.scheduleData.getDatesInConflict().size());
    }

    private void dailyPrerequisite() throws ParseException {
        this.scheduleData.setRecurrenceType(StyleKey.DAILY.toString());
        this.scheduleData.setDailySchedule(new DailyScheduleDetails());
        this.scheduleData.getDailySchedule().setScheduleEndDate(this.getDate(2));
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                Date dt = CommitteeScheduleServiceImplTest.this.scheduleData.getScheduleStartDate();
                Date endDt = CommitteeScheduleServiceImplTest.this.scheduleData.getDailySchedule().getScheduleEndDate();
                LinkedList<java.util.Date> dates = new LinkedList<java.util.Date>();
                dates.add(new java.util.Date());
                dates.add(DateUtils.addDays((java.util.Date)new java.util.Date(), (int)2));
                Time24HrFmt time = new Time24HrFmt(CommitteeScheduleServiceImplTest.TIME24HR_0_1);
                int day = CommitteeScheduleServiceImplTest.this.scheduleData.getDailySchedule().getDay();
                ((ScheduleService)this.one(CommitteeScheduleServiceImplTest.this.scheduleService)).getIntervalInDaysScheduledDates((java.util.Date)dt, (java.util.Date)endDt, time, Integer.valueOf(day));
                this.will(10.returnValue(dates));
            }
        });
    }

    @Test
    public void testAddScheduleNeverRecurrence() throws Exception {
        this.prerequisite();
        this.scheduleData.setRecurrenceType(StyleKey.NEVER.toString());
        this.scheduleData.setTime(new Time12HrFmt(TIME12HR_11_59, Time12HrFmt.MERIDIEM.PM));
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                Date dt = CommitteeScheduleServiceImplTest.this.scheduleData.getScheduleStartDate();
                LinkedList<java.util.Date> dates = new LinkedList<java.util.Date>();
                dates.add(new java.util.Date());
                Time24HrFmt time = new Time24HrFmt(CommitteeScheduleServiceImplTest.TIME24HR_23_59);
                ((ScheduleService)this.one(CommitteeScheduleServiceImplTest.this.scheduleService)).getScheduledDates((java.util.Date)dt, (java.util.Date)dt, time, null);
                this.will(11.returnValue(dates));
            }
        });
        this.test(1);
    }

    private void test(int count) throws Exception {
        this.service.addSchedule(this.scheduleData, (CommitteeBase)this.committee);
        Assert.assertEquals((long)count, (long)this.committee.getCommitteeSchedules().size());
    }

    private void prerequisite() {
        this.mockBusinessService();
        this.committee = new Committee();
        this.committee.setAdvancedSubmissionDaysRequired(Integer.valueOf(10));
        this.scheduleData = new ScheduleData();
        this.scheduleData.setScheduleStartDate(this.getDate(0));
        this.scheduleData.setTime(new Time12HrFmt(TIME12HR_00_01, Time12HrFmt.MERIDIEM.AM));
    }

    @Test
    public void testIsCommitteeScheduleDeletableWithProtocol() throws Exception {
        boolean flag = false;
        Protocol protocol = (Protocol)this.context.mock(Protocol.class);
        this.committeeSchedule.setProtocols(new ArrayList());
        this.committeeSchedule.getProtocols().add(protocol);
        flag = this.service.isCommitteeScheduleDeletable((CommitteeScheduleBase)this.committeeSchedule);
        Assert.assertFalse((boolean)flag);
    }

    @Test
    public void testIsCommitteeScheduleDeletableWithPastDate() throws Exception {
        boolean flag = false;
        Date date = new Date(new java.util.Date().getTime());
        this.committeeSchedule.setScheduledDate(date);
        flag = this.service.isCommitteeScheduleDeletable((CommitteeScheduleBase)this.committeeSchedule);
        Assert.assertTrue((boolean)flag);
    }

    @Test
    public void testIsCommitteeScheduleDeletableWithCurrentDate() throws Exception {
        boolean flag = false;
        java.util.Date newdate = DateUtils.addDays((java.util.Date)new java.util.Date(), (int)-1);
        this.committeeSchedule.setScheduledDate(new Date(newdate.getTime()));
        flag = this.service.isCommitteeScheduleDeletable((CommitteeScheduleBase)this.committeeSchedule);
        Assert.assertTrue((boolean)flag);
    }

    private void mockBusinessService() {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                LinkedList<ScheduleStatus> scheduleStatuses = new LinkedList<ScheduleStatus>();
                scheduleStatuses.add(new ScheduleStatus());
                HashMap<String, String> fieldValues = new HashMap<String, String>();
                fieldValues.put("description", "Scheduled");
                ((BusinessObjectService)this.allowing(CommitteeScheduleServiceImplTest.this.boService)).findMatching(ScheduleStatus.class, fieldValues);
                this.will(12.returnValue(scheduleStatuses));
            }
        });
    }

    private Date getDate(int offset) {
        Date sqlDt = new Date(new java.util.Date().getTime());
        java.util.Date dt = DateUtils.addDays((java.util.Date)sqlDt, (int)offset);
        return new Date(dt.getTime());
    }
}

