/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.committee.service;

import java.sql.Date;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import org.jmock.Expectations;
import org.jmock.Mockery;
import org.jmock.integration.junit4.JMock;
import org.jmock.integration.junit4.JUnit4Mockery;
import org.jmock.internal.ExpectationBuilder;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kuali.kra.committee.bo.Committee;
import org.kuali.kra.committee.bo.CommitteeMembership;
import org.kuali.kra.committee.bo.CommitteeSchedule;
import org.kuali.kra.committee.service.impl.CommitteeServiceImpl;
import org.kuali.kra.common.committee.bo.CommitteeBase;
import org.kuali.kra.common.committee.bo.CommitteeMembershipRole;
import org.kuali.kra.common.committee.bo.CommitteeResearchAreaBase;
import org.kuali.kra.common.committee.bo.ScheduleStatus;
import org.kuali.kra.irb.ResearchArea;
import org.kuali.kra.meeting.CommitteeScheduleMinute;
import org.kuali.kra.meeting.ScheduleAgenda;
import org.kuali.rice.core.api.util.KeyValue;
import org.kuali.rice.krad.service.BusinessObjectService;

@RunWith(value=JMock.class)
public class CommitteeServiceTest {
    private static final String RESEARCH_AREA_CODE_1 = "01.0101";
    private static final String RESEARCH_AREA_CODE_2 = "01.0102";
    private static final String RESEARCH_AREA_CODE_3 = "01.0103";
    DateFormat dateFormat = new SimpleDateFormat("MM/dd/yyyy");
    private Mockery context = new JUnit4Mockery();

    @Test
    public void testGetCommitteeByIdFound() {
        CommitteeServiceImpl committeeService = new CommitteeServiceImpl();
        final HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put("committeeId", "999");
        final ArrayList<Committee> committees = new ArrayList<Committee>();
        Committee committee = new Committee();
        committees.add(committee);
        final BusinessObjectService businessObjectService = (BusinessObjectService)this.context.mock(BusinessObjectService.class);
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((BusinessObjectService)this.one(businessObjectService)).findMatching(Committee.class, fieldValues);
                this.will(1.returnValue((Object)committees));
            }
        });
        committeeService.setBusinessObjectService(businessObjectService);
        Assert.assertEquals((Object)committee, (Object)committeeService.getCommitteeById("999"));
    }

    @Test
    public void testGetCommitteeByIdNotFound() {
        CommitteeServiceImpl committeeService = new CommitteeServiceImpl();
        final HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put("committeeId", "999");
        final ArrayList committees = new ArrayList();
        final BusinessObjectService businessObjectService = (BusinessObjectService)this.context.mock(BusinessObjectService.class);
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((BusinessObjectService)this.one(businessObjectService)).findMatching(Committee.class, fieldValues);
                this.will(2.returnValue((Object)committees));
            }
        });
        committeeService.setBusinessObjectService(businessObjectService);
        Assert.assertEquals(null, (Object)committeeService.getCommitteeById("999"));
    }

    @Test
    public void testAddResearchAreas() {
        CommitteeServiceImpl committeeService = new CommitteeServiceImpl();
        Committee committee = new Committee();
        ArrayList<ResearchArea> researchAreas = new ArrayList<ResearchArea>();
        ResearchArea researchArea1 = new ResearchArea();
        researchArea1.setResearchAreaCode(RESEARCH_AREA_CODE_1);
        researchAreas.add(researchArea1);
        ResearchArea researchArea2 = new ResearchArea();
        researchArea2.setResearchAreaCode(RESEARCH_AREA_CODE_2);
        researchAreas.add(researchArea2);
        committeeService.addResearchAreas((CommitteeBase)committee, researchAreas);
        List committeeResearchAreas = committee.getCommitteeResearchAreas();
        Assert.assertEquals((long)2L, (long)committeeResearchAreas.size());
        Assert.assertEquals((Object)RESEARCH_AREA_CODE_1, (Object)((CommitteeResearchAreaBase)committeeResearchAreas.get(0)).getResearchAreaCode());
        Assert.assertEquals((Object)RESEARCH_AREA_CODE_2, (Object)((CommitteeResearchAreaBase)committeeResearchAreas.get(1)).getResearchAreaCode());
        ResearchArea researchArea3 = new ResearchArea();
        researchArea3.setResearchAreaCode(RESEARCH_AREA_CODE_3);
        researchAreas.add(researchArea3);
        committeeService.addResearchAreas((CommitteeBase)committee, researchAreas);
        committeeResearchAreas = committee.getCommitteeResearchAreas();
        Assert.assertEquals((long)3L, (long)committeeResearchAreas.size());
        Assert.assertEquals((Object)RESEARCH_AREA_CODE_1, (Object)((CommitteeResearchAreaBase)committeeResearchAreas.get(0)).getResearchAreaCode());
        Assert.assertEquals((Object)RESEARCH_AREA_CODE_2, (Object)((CommitteeResearchAreaBase)committeeResearchAreas.get(1)).getResearchAreaCode());
        Assert.assertEquals((Object)RESEARCH_AREA_CODE_3, (Object)((CommitteeResearchAreaBase)committeeResearchAreas.get(2)).getResearchAreaCode());
    }

    @Test
    public void testNoAvailDates() {
        CommitteeServiceImpl committeeService = new CommitteeServiceImpl();
        Committee committee = new Committee();
        this.initCommitteeService(committeeService, committee);
        List availDates = committeeService.getAvailableCommitteeDates("999");
        Assert.assertEquals((long)1L, (long)availDates.size());
        Assert.assertEquals((Object)"", (Object)((KeyValue)availDates.get(0)).getKey());
    }

    @Test
    public void testAvailDates() {
        CommitteeServiceImpl committeeService = new CommitteeServiceImpl();
        Committee committee = new Committee();
        this.initCommitteeService(committeeService, committee);
        ScheduleStatus cs = new ScheduleStatus();
        cs.setDescription("Scheduled");
        cs.setScheduleStatusCode(new Integer(1));
        committee.setAdvancedSubmissionDaysRequired(Integer.valueOf(10));
        CommitteeSchedule schedule1 = new CommitteeSchedule();
        schedule1.setScheduleId("1");
        schedule1.setScheduledDate(new Date(System.currentTimeMillis()));
        Calendar now = this.getCalendar(new java.util.Date());
        now.add(5, -10);
        schedule1.setProtocolSubDeadline(new Date(now.getTimeInMillis()));
        schedule1.setTime(new Timestamp(0L));
        schedule1.setScheduleStatus(cs);
        committee.getCommitteeSchedules().add(schedule1);
        CommitteeSchedule schedule2 = new CommitteeSchedule();
        schedule2.setScheduleId("2");
        schedule2.setScheduledDate(this.getDate(20));
        schedule2.setProtocolSubDeadline(this.getDate(10));
        schedule2.setTime(new Timestamp(0L));
        schedule2.setScheduleStatus(cs);
        committee.getCommitteeSchedules().add(schedule2);
        List availDates = committeeService.getAvailableCommitteeDates("999");
        Assert.assertEquals((long)2L, (long)availDates.size());
        Assert.assertEquals((Object)"", (Object)((KeyValue)availDates.get(0)).getKey());
        Assert.assertEquals((Object)schedule2.getScheduleId(), (Object)((KeyValue)availDates.get(1)).getKey());
    }

    @Test
    public void testAvailMembers() {
        CommitteeServiceImpl committeeService = new CommitteeServiceImpl();
        Committee committee = new Committee();
        this.initCommitteeService(committeeService, committee);
        CommitteeSchedule schedule = new CommitteeSchedule();
        schedule.setScheduleId("1");
        schedule.setScheduledDate(this.getDate(20));
        schedule.setTime(new Timestamp(0L));
        committee.getCommitteeSchedules().add(schedule);
        CommitteeMembership member1 = new CommitteeMembership();
        member1.setMembershipId("1");
        CommitteeMembershipRole role1 = new CommitteeMembershipRole();
        role1.setStartDate(this.getDate(0));
        role1.setEndDate(this.getDate(40));
        role1.setMembershipRoleCode("12");
        member1.getMembershipRoles().add(role1);
        committee.getCommitteeMemberships().add(member1);
        CommitteeMembership member2 = new CommitteeMembership();
        member2.setMembershipId("2");
        CommitteeMembershipRole role2 = new CommitteeMembershipRole();
        role2.setStartDate(this.getDate(0));
        role2.setEndDate(this.getDate(5));
        role2.setMembershipRoleCode("12");
        member2.getMembershipRoles().add(role2);
        committee.getCommitteeMemberships().add(member2);
        CommitteeMembership member3 = new CommitteeMembership();
        member3.setMembershipId("3");
        CommitteeMembershipRole role3 = new CommitteeMembershipRole();
        role3.setStartDate(this.getDate(40));
        role3.setEndDate(this.getDate(45));
        role3.setMembershipRoleCode("12");
        member3.getMembershipRoles().add(role3);
        committee.getCommitteeMemberships().add(member3);
        List members = committeeService.getAvailableMembers("999", "1");
        Assert.assertEquals((long)1L, (long)members.size());
        Assert.assertEquals((Object)member1, members.get(0));
    }

    @Test
    public void testGetCommitteeSchedule() {
        CommitteeServiceImpl committeeService = new CommitteeServiceImpl();
        Committee committee = new Committee();
        for (int i = 0; i < 3; ++i) {
            CommitteeSchedule schedule = new CommitteeSchedule();
            schedule.setScheduleId(Integer.toString(i + 1));
            schedule.setScheduledDate(this.getDate(i + 1));
            committee.getCommitteeSchedules().add(schedule);
        }
        CommitteeSchedule s = (CommitteeSchedule)committeeService.getCommitteeSchedule((CommitteeBase)committee, "4");
        Assert.assertNull((Object)s);
        s = (CommitteeSchedule)committeeService.getCommitteeSchedule((CommitteeBase)committee, "2");
        Assert.assertEquals(committee.getCommitteeSchedules().get(1), (Object)s);
    }

    private void initCommitteeService(CommitteeServiceImpl committeeService, Committee committee) {
        final HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put("committeeId", "999");
        final ArrayList<Committee> committees = new ArrayList<Committee>();
        committees.add(committee);
        final BusinessObjectService businessObjectService = (BusinessObjectService)this.context.mock(BusinessObjectService.class);
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((BusinessObjectService)this.one(businessObjectService)).findMatching(Committee.class, fieldValues);
                this.will(3.returnValue((Object)committees));
            }
        });
        committeeService.setBusinessObjectService(businessObjectService);
    }

    private Date getDate(int extraDays) {
        Calendar cal = this.getCalendar(new java.util.Date());
        cal.add(5, extraDays);
        return new Date(cal.getTimeInMillis());
    }

    private Calendar getCalendar(java.util.Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar;
    }

    @Test
    public void testMergeCommitteeSchedule() throws Exception {
        CommitteeServiceImpl committeeService = new CommitteeServiceImpl();
        final HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put("committeeId", "test");
        final ArrayList<Committee> committees = new ArrayList<Committee>();
        committees.add(this.getCommittee("test", 1));
        committees.add(this.getCommittee("test", 2));
        final BusinessObjectService businessObjectService = (BusinessObjectService)this.context.mock(BusinessObjectService.class);
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((BusinessObjectService)this.one(businessObjectService)).findMatching(Committee.class, fieldValues);
                this.will(4.returnValue((Object)committees));
            }
        });
        committeeService.setBusinessObjectService(businessObjectService);
        List schedules = committeeService.mergeCommitteeSchedule("test");
        junit.framework.Assert.assertTrue((schedules.size() == 2 ? 1 : 0) != 0);
        CommitteeSchedule schedule = (CommitteeSchedule)schedules.get(0);
        ScheduleAgenda agenda = (ScheduleAgenda)schedule.getScheduleAgendas().get(0);
        Assert.assertEquals((Object)schedule.getPlace(), (Object)"place 2");
        Assert.assertEquals((Object)schedule.getScheduleStatusCode().toString(), (Object)"2");
        Assert.assertEquals((Object)((CommitteeSchedule)schedules.get(1)).getScheduleId(), (Object)"4");
        Assert.assertEquals((Object)agenda.getAgendaName(), (Object)"name 1");
        CommitteeScheduleMinute minute = (CommitteeScheduleMinute)schedule.getCommitteeScheduleMinutes().get(0);
        Assert.assertEquals((Object)minute.getMinuteEntry(), (Object)"comment 1");
        Assert.assertEquals((Object)minute.getMinuteEntryTypeCode(), (Object)"1");
    }

    private Committee getCommittee(String committeeId, Integer sequenceNumber) throws Exception {
        Committee committee = new Committee();
        committee.setCommitteeId(committeeId);
        committee.setSequenceNumber(sequenceNumber);
        committee.setCommitteeSchedules(this.getCommitteeSchedule("1", sequenceNumber.toString(), sequenceNumber));
        if (sequenceNumber == 1) {
            CommitteeSchedule committeeSchedule = new CommitteeSchedule();
            committeeSchedule.setCommitteeIdFk(Long.valueOf(1L));
            committeeSchedule.setScheduledDate(new Date(this.dateFormat.parse("12/24/2012").getTime()));
            committeeSchedule.setScheduleId("3");
            committee.getCommitteeSchedules().add(committeeSchedule);
            committeeSchedule = new CommitteeSchedule();
            committeeSchedule.setCommitteeIdFk(Long.valueOf(1L));
            committeeSchedule.setScheduledDate(new Date(this.dateFormat.parse("12/17/2012").getTime()));
            committeeSchedule.setScheduleId("4");
            committeeSchedule.setCommitteeScheduleMinutes(this.getCommitteeScheduleMinute("3"));
            committee.getCommitteeSchedules().add(committeeSchedule);
        }
        return committee;
    }

    private List<CommitteeSchedule> getCommitteeSchedule(String scheduleId, String text, Integer scheduleStatus) throws Exception {
        ArrayList<CommitteeSchedule> schedules = new ArrayList<CommitteeSchedule>();
        CommitteeSchedule committeeSchedule = new CommitteeSchedule();
        committeeSchedule.setCommitteeIdFk(Long.valueOf(1L));
        committeeSchedule.setScheduledDate(new Date(this.dateFormat.parse("12/31/2012").getTime()));
        committeeSchedule.setScheduleId(scheduleId);
        committeeSchedule.setScheduleAgendas(this.getScheduleAgenda("name " + text));
        committeeSchedule.setCommitteeScheduleMinutes(this.getCommitteeScheduleMinute(text));
        committeeSchedule.setTime(new Timestamp(new java.util.Date().getTime()));
        committeeSchedule.setPlace("place " + text);
        committeeSchedule.setScheduleStatusCode(scheduleStatus);
        schedules.add(committeeSchedule);
        return schedules;
    }

    private List<ScheduleAgenda> getScheduleAgenda(String text) throws Exception {
        ArrayList<ScheduleAgenda> agendas = new ArrayList<ScheduleAgenda>();
        ScheduleAgenda agenda = new ScheduleAgenda();
        agenda.setAgendaName(text);
        agendas.add(agenda);
        return agendas;
    }

    private List<CommitteeScheduleMinute> getCommitteeScheduleMinute(String text) throws Exception {
        ArrayList<CommitteeScheduleMinute> minutes = new ArrayList<CommitteeScheduleMinute>();
        CommitteeScheduleMinute minute = new CommitteeScheduleMinute();
        minute.setMinuteEntryTypeCode(text);
        minute.setMinuteEntry("comment " + text);
        minutes.add(minute);
        return minutes;
    }
}

