/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.committee.test;

import java.util.ArrayList;
import org.kuali.kra.committee.bo.Committee;
import org.kuali.kra.committee.document.CommitteeDocument;
import org.kuali.kra.common.committee.document.CommitteeDocumentBase;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.service.DocumentService;

public class CommitteeFactory {
    protected static final String DEFAULT_DOCUMENT_DESCRIPTION = "Committee Web Test";
    protected static final String DEFAULT_TYPE_CODE = "1";
    protected static final Integer DEFAULT_MAX_PROTOCOLS = 10;
    protected static final String DEFAULT_HOME_UNIT_NUMBER = "000001";
    protected static final Integer DEFAULT_MIN_MEMBERS_REQUIRED = 3;
    protected static final String DEFAULT_NAME = "Committee Test ";
    protected static final Integer DEFAULT_ADV_SUBMISSION_DAYS_REQUIRED = 1;
    protected static final String DEFAULT_REVIEW_TYPE_CODE = "1";

    public static CommitteeDocument createCommitteeDocument(String committeeId) throws WorkflowException {
        DocumentService documentService = (DocumentService)KraServiceLocator.getService((String)"kraDocumentService");
        CommitteeDocument committeeDocument = (CommitteeDocument)documentService.getNewDocument("CommitteeDocument");
        CommitteeFactory.setRequiredFields(committeeDocument, committeeId);
        documentService.saveDocument((Document)committeeDocument);
        return committeeDocument;
    }

    private static void setRequiredFields(CommitteeDocument document, String committeeId) {
        Committee committee = (Committee)document.getCommittee();
        document.getDocumentHeader().setDocumentDescription(DEFAULT_DOCUMENT_DESCRIPTION);
        document.setDocumentNextvalues(new ArrayList());
        document.setCommitteeId(committeeId);
        committee.setCommitteeDocument((CommitteeDocumentBase)document);
        committee.setCommitteeId(committeeId);
        committee.setCommitteeTypeCode("1");
        committee.setMaxProtocols(DEFAULT_MAX_PROTOCOLS);
        committee.setHomeUnitNumber(DEFAULT_HOME_UNIT_NUMBER);
        committee.setMinimumMembersRequired(DEFAULT_MIN_MEMBERS_REQUIRED);
        committee.setCommitteeName(DEFAULT_NAME + committeeId);
        committee.setAdvancedSubmissionDaysRequired(DEFAULT_ADV_SUBMISSION_DAYS_REQUIRED);
        committee.setReviewTypeCode("1");
    }
}

