/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.committee.web;

import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kra.committee.web.CommitteeSeleniumHelper;
import org.kuali.kra.test.infrastructure.KcSeleniumTestBase;

public class CommitteeActionsSeleniumTest
extends KcSeleniumTestBase {
    private static final String BATCH_CORRESPONDENCE_TAB_ID = "Batch Correspondence";
    private static final String ERROR_TAB_ID = "tab-BatchCorrespondence-div";
    private static final String SUB_TAB_ID = "div[class='innerTab-head']";
    private static final String HELPER_PREFIX = "committeeHelper.";
    private static final String GENERATE_BATCH_CORRESPONDENCE_TYPE_CODE_ID = "generateBatchCorrespondenceTypeCode";
    private static final String HISTORY_BATCH_CORRESPONDENCE_TYPE_CODE_ID = "historyBatchCorrespondenceTypeCode";
    private static final String GENERATE_START_DATE_ID = "generateStartDate";
    private static final String GENERATE_END_DATE_ID = "generateEndDate";
    private static final String HELPER_GENERATE_BATCH_CORRESPONDENCE_TYPE_CODE_ID = "committeeHelper.generateBatchCorrespondenceTypeCode";
    private static final String HELPER_HISTORY_BATCH_CORRESPONDENCE_TYPE_CODE_ID = "committeeHelper.historyBatchCorrespondenceTypeCode";
    private static final String HELPER_GENERATE_START_DATE_ID = "committeeHelper.generateStartDate";
    private static final String HELPER_GENERATE_END_DATE_ID = "committeeHelper.generateEndDate";
    private static final String BATCH_CORRESPONDENCE_TYPE_CODE_NAME = "Protocol Renewal Reminders";
    private static final String START_DATE = "01/01/2010";
    private static final String END_DATE = "12/31/2010";
    private static final String GENERATED_BATCH_CORRESPONDENCE = "Generated Batch Correspondence";
    private static final String HISTORY_BATCH_CORRESPONDENCE = "Batch Type: Protocol Renewal Reminders";
    private static final String START_DATE_THROUGH_END_DATE = "01/01/2010 through 12/31/2010";
    private static final String ERROR_BATCH_TYPE_MISSING = "Batch type missing.";
    private static final String ERROR_START_DATE_MISSING = "Start date missing.";
    private static final String ERROR_END_DATE_MISSING = "End date missing.";
    private static final String ERROR_NO_REPORT_SELECTED = "No report selected for printing.";
    private static final String GENERATE_BATCH_CORRESPONDENCE_BUTTON = "methodToCall.generateBatchCorrespondence";
    private static final String FILTER_BATCH_CORRESPONDENCE_HISTORY_BUTTON = "methodToCall.filterBatchCorrespondenceHistory";
    private static final String PRINT_COMMITTEE_DOCUMENT_BUTTON = "methodToCall.printCommitteeDocument";
    private CommitteeSeleniumHelper helper;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.helper = CommitteeSeleniumHelper.instance(driver);
    }

    @Override
    @After
    public void tearDown() throws Exception {
        this.helper = null;
        super.tearDown();
    }

    @Test
    public void testGenerateRenewalReminders() throws Exception {
        this.helper.createCommittee();
        this.helper.blanketApproveDocument();
        this.helper.clickCommitteeActionsPage();
        this.helper.openTab(BATCH_CORRESPONDENCE_TAB_ID);
        this.helper.click(GENERATE_BATCH_CORRESPONDENCE_BUTTON);
        this.helper.assertPageErrors();
        this.helper.assertError(ERROR_TAB_ID, ERROR_BATCH_TYPE_MISSING);
        this.helper.assertError(ERROR_TAB_ID, ERROR_START_DATE_MISSING);
        this.helper.assertError(ERROR_TAB_ID, ERROR_END_DATE_MISSING);
        this.helper.set(HELPER_GENERATE_BATCH_CORRESPONDENCE_TYPE_CODE_ID, BATCH_CORRESPONDENCE_TYPE_CODE_NAME);
        this.helper.set(HELPER_GENERATE_START_DATE_ID, START_DATE);
        this.helper.set(HELPER_GENERATE_END_DATE_ID, END_DATE);
        this.helper.click(GENERATE_BATCH_CORRESPONDENCE_BUTTON);
        this.helper.assertNoPageErrors();
        this.helper.assertPageContains(GENERATED_BATCH_CORRESPONDENCE);
        this.helper.assertSelectorContains(SUB_TAB_ID, START_DATE_THROUGH_END_DATE);
    }

    @Test
    public void testFilterBatchCorrespondenceHistory() throws Exception {
        this.helper.createCommittee();
        this.helper.blanketApproveDocument();
        this.helper.clickCommitteeActionsPage();
        this.helper.openTab(BATCH_CORRESPONDENCE_TAB_ID);
        this.helper.click(FILTER_BATCH_CORRESPONDENCE_HISTORY_BUTTON);
        this.helper.assertPageErrors();
        this.helper.assertError(ERROR_TAB_ID, ERROR_BATCH_TYPE_MISSING);
        this.helper.set(HELPER_HISTORY_BATCH_CORRESPONDENCE_TYPE_CODE_ID, BATCH_CORRESPONDENCE_TYPE_CODE_NAME);
        this.helper.click(FILTER_BATCH_CORRESPONDENCE_HISTORY_BUTTON);
        this.helper.assertNoPageErrors();
        this.helper.assertPageContains(HISTORY_BATCH_CORRESPONDENCE);
        this.helper.assertSelectorContains(SUB_TAB_ID, START_DATE_THROUGH_END_DATE);
    }

    @Test
    public void testPrintErrors() throws Exception {
        this.helper.createCommittee();
        this.helper.blanketApproveDocument();
        this.helper.clickCommitteeActionsPage();
        this.helper.openTab(1);
        this.helper.click(PRINT_COMMITTEE_DOCUMENT_BUTTON);
        this.helper.assertPageErrors();
        this.helper.assertPageContains(ERROR_NO_REPORT_SELECTED);
    }
}

