/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.committee.web;

import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kra.committee.web.CommitteeSeleniumHelper;
import org.kuali.kra.test.infrastructure.KcSeleniumTestBase;

public class CommitteeAreasOfResearchPanelSeleniumTest
extends KcSeleniumTestBase {
    private static final String TABLE_ID = "researchAreaTableId";
    private static final String RESEARCH_AREA = "000001 All Research Areas";
    private static final String DELETE_RESEARCH_AREA_BUTTON = "methodToCall.deleteResearchArea";
    private CommitteeSeleniumHelper helper;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.helper = CommitteeSeleniumHelper.instance(driver);
    }

    @Override
    @After
    public void tearDown() throws Exception {
        this.helper = null;
        super.tearDown();
    }

    @Test
    public void testAddResearchArea() throws Exception {
        this.helper.createCommittee();
        this.helper.assertTableRowCount(TABLE_ID, 3);
        this.helper.assertTableCellValueContains(TABLE_ID, RESEARCH_AREA);
        this.helper.saveDocument();
        this.helper.assertNoPageErrors();
        this.helper.closeAndSearchDocument();
        this.helper.assertTableRowCount(TABLE_ID, 3);
        this.helper.assertTableCellValueContains(TABLE_ID, RESEARCH_AREA);
    }

    @Test
    public void testDeleteResearchArea() throws Exception {
        this.helper.createCommittee();
        this.helper.saveDocument();
        this.helper.assertNoPageErrors();
        this.helper.click(DELETE_RESEARCH_AREA_BUTTON);
        this.helper.assertTableRowCount(TABLE_ID, 2);
        this.helper.saveDocument();
        this.helper.assertNoPageErrors();
        this.helper.closeAndSearchDocument();
        this.helper.assertTableRowCount(TABLE_ID, 2);
    }
}

