/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.committee.web;

import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kra.committee.web.CommitteeSeleniumHelper;
import org.kuali.kra.test.infrastructure.KcSeleniumTestBase;

public class CommitteeAuthorizationSeleniumTest
extends KcSeleniumTestBase {
    private static final String CREATE_COMMITTEE_LINK_NAME = "Create Committee";
    private static final String ERROR_ID = "font[color = 'red']";
    private static final String NO_PERMISSION_USERNAME = "majors";
    private static final String VIEWER_PERMISSION_USERNAME = "jtester";
    private static final String ERROR_NOT_AUTHORIZED_OPEN = "not authorized to open document";
    private static final String ERROR_NOT_AUTHORIZED_VIEW = "not authorized to view document";
    private static final String ERROR_NOT_AUTHORIZED_INITIATE = "not authorized to initiate document";
    private static final String SAVE_BUTTON = "methodToCall.save";
    private CommitteeSeleniumHelper helper;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.helper = CommitteeSeleniumHelper.instance(driver);
        this.helper.loginBackdoor();
    }

    @Override
    @After
    public void tearDown() throws Exception {
        this.helper.loginBackdoor();
        this.helper = null;
        super.tearDown();
    }

    @Test
    public void testBlankAuthorization() throws Exception {
        this.helper.createCommittee();
        String documentNumber = this.helper.getDocumentNumber();
        this.helper.closeDocument();
        this.helper.loginBackdoor(NO_PERMISSION_USERNAME);
        this.helper.docSearch(documentNumber);
        this.helper.assertSelectorContains(ERROR_ID, ERROR_NOT_AUTHORIZED_OPEN);
    }

    @Test
    public void testViewAuthorization() throws Exception {
        this.helper.createCommittee();
        String documentNumber = this.helper.getDocumentNumber();
        this.helper.closeDocument();
        this.helper.loginBackdoor(VIEWER_PERMISSION_USERNAME);
        this.helper.docSearch(documentNumber);
        this.helper.assertSelectorDoesNotContain(ERROR_ID, ERROR_NOT_AUTHORIZED_VIEW);
        this.helper.assertElementDoesNotExist(SAVE_BUTTON);
    }

    @Test
    public void testCreateAuthorizationNoError() throws Exception {
        this.helper.createCommittee();
    }

    @Test
    public void testCreateAuthorizationError() throws Exception {
        this.helper.loginBackdoor(NO_PERMISSION_USERNAME);
        this.helper.clickCentralAdminTab();
        this.helper.click(CREATE_COMMITTEE_LINK_NAME);
        this.helper.assertSelectorContains(ERROR_ID, ERROR_NOT_AUTHORIZED_INITIATE);
    }

    @Test
    public void testModifyAuthorization() throws Exception {
        this.helper.createCommittee();
        this.helper.assertNoPageErrors();
        this.helper.saveDocument();
        this.helper.assertNoPageErrors();
    }
}

