/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.committee.web;

import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kra.committee.web.CommitteeSeleniumHelper;
import org.kuali.kra.test.infrastructure.KcSeleniumTestBase;

public class CommitteeCommitteeSeleniumTest
extends KcSeleniumTestBase {
    private static final String ERROR_PANEL_ID = "tab-Committee-div";
    private static final String LIST_PREFIX = "document.committeeList[0].";
    private static final String DOCUMENT_DESCRIPTION_ID = "document.documentHeader.documentDescription";
    private static final String COMMITTEE_ID_ID = "committeeId";
    private static final String COMMITTEE_NAME_ID = "committeeName";
    private static final String HOME_UNIT_NUMBER_ID = "homeUnitNumber";
    private static final String COMMITTEE_TYPE_CODE_ID = "committeeTypeCode";
    private static final String COMMITTEE_DESCRIPTION_ID = "committeeDescription";
    private static final String SCHEDULE_DESCRIPTION_ID = "scheduleDescription";
    private static final String MINIMUM_MEMBERS_REQUIRED_ID = "minimumMembersRequired";
    private static final String REVIEW_TYPE_CODE_ID = "reviewTypeCode";
    private static final String MAX_PROTOCOLS_ID = "maxProtocols";
    private static final String ADVANCED_SUBMISSION_REQUIRED_ID = "advancedSubmissionDaysRequired";
    private static final String LIST_COMMITEE_ID_ID = "document.committeeList[0].committeeId";
    private static final String LIST_COMMITTEE_NAME_ID = "document.committeeList[0].committeeName";
    private static final String LIST_HOME_UNIT_NUMBER_ID = "document.committeeList[0].homeUnitNumber";
    private static final String LIST_COMMITTEE_TYPE_CODE_ID = "document.committeeList[0].committeeTypeCode";
    private static final String LIST_COMMITTEE_DESCRIPTION_ID = "document.committeeList[0].committeeDescription";
    private static final String LIST_SCHEDULE_DESCRIPTION_ID = "document.committeeList[0].scheduleDescription";
    private static final String LIST_MINIMUM_MEMBERS_REQUIRED_ID = "document.committeeList[0].minimumMembersRequired";
    private static final String LIST_REVIEW_TYPE_CODE_ID = "document.committeeList[0].reviewTypeCode";
    private static final String LIST_MAX_PROTOCOLS_ID = "document.committeeList[0].maxProtocols";
    private static final String LIST_ADVANCED_SUBMISSION_DAYS_REQUIRED_ID = "document.committeeList[0].advancedSubmissionDaysRequired";
    private static final String DEFAULT_DOCUMENT_DESCRIPTION = "Committee Web Test";
    private static final String DEFAULT_COMMITTEE_NAME = " Committee";
    private static final String DEFAULT_HOME_UNIT_NUMBER = "000001";
    private static final String DEFAULT_COMMITTEE_TYPE_CODE_NAME = "IRB";
    private static final String DEFAULT_COMMITTEE_DESCRIPTION = "xxx";
    private static final String DEFAULT_SCHEDULE_DESCRIPTION = "foo";
    private static final String DEFAULT_MINIMUM_MEMBERS_REQUIRED = "3";
    private static final String DEFAULT_REVIEW_TYPE_CODE_NAME = "Full";
    private static final String DEFAULT_MAX_PROTOCOLS = "10";
    private static final String DEFAULT_ADVANCED_SUBMISSION_DAYS_REQUIRED = "1";
    private static final String HOME_UNIT_NUMBER = "xxx";
    private static final String DESCRIPTION_VALUE_1 = "Description text";
    private static final String DESCRIPTION_VALUE_2 = "Another description text";
    private static final String ERROR_INVALID_UNIT = "xxx is not a valid Unit";
    private CommitteeSeleniumHelper helper;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.helper = CommitteeSeleniumHelper.instance(driver);
    }

    @Override
    @After
    public void tearDown() throws Exception {
        this.helper = null;
        super.tearDown();
    }

    @Test
    public void testDefaultFields() throws Exception {
        this.helper.createCommittee();
        this.helper.assertNoPageErrors();
        this.helper.closeAndSearchDocument();
        this.helper.assertElementContains(DOCUMENT_DESCRIPTION_ID, DEFAULT_DOCUMENT_DESCRIPTION);
        this.helper.assertElementContains(LIST_COMMITEE_ID_ID, this.helper.getCurrentCommitteeID());
        this.helper.assertElementContains(LIST_COMMITTEE_NAME_ID, this.helper.getCurrentCommitteeID() + DEFAULT_COMMITTEE_NAME);
        this.helper.assertElementContains(LIST_HOME_UNIT_NUMBER_ID, DEFAULT_HOME_UNIT_NUMBER);
        this.helper.assertElementContains(LIST_COMMITTEE_TYPE_CODE_ID, DEFAULT_COMMITTEE_TYPE_CODE_NAME);
        this.helper.assertElementContains(LIST_COMMITTEE_DESCRIPTION_ID, "xxx");
        this.helper.assertElementContains(LIST_SCHEDULE_DESCRIPTION_ID, DEFAULT_SCHEDULE_DESCRIPTION);
        this.helper.assertElementContains(LIST_MINIMUM_MEMBERS_REQUIRED_ID, DEFAULT_MINIMUM_MEMBERS_REQUIRED);
        this.helper.assertElementContains(LIST_REVIEW_TYPE_CODE_ID, DEFAULT_REVIEW_TYPE_CODE_NAME);
        this.helper.assertElementContains(LIST_MAX_PROTOCOLS_ID, DEFAULT_MAX_PROTOCOLS);
        this.helper.assertElementContains(LIST_ADVANCED_SUBMISSION_DAYS_REQUIRED_ID, DEFAULT_ADVANCED_SUBMISSION_DAYS_REQUIRED);
    }

    @Test
    public void testInvalidHomeUnit() throws Exception {
        this.helper.createCommittee();
        this.helper.assertNoPageErrors();
        this.helper.set(LIST_HOME_UNIT_NUMBER_ID, "xxx");
        this.helper.saveDocument();
        this.helper.assertError(ERROR_PANEL_ID, ERROR_INVALID_UNIT);
    }

    @Test
    public void testCommitteeDescriptionExpandedTextArea() throws Exception {
        this.helper.createCommittee();
        this.helper.assertExpandedTextArea(LIST_COMMITTEE_DESCRIPTION_ID, DESCRIPTION_VALUE_1, DESCRIPTION_VALUE_2);
    }

    @Test
    public void testScheduleDescriptionExpandedTextArea() throws Exception {
        this.helper.createCommittee();
        this.helper.assertExpandedTextArea(SCHEDULE_DESCRIPTION_ID, DESCRIPTION_VALUE_1, DESCRIPTION_VALUE_2);
    }
}

