/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.committee.web;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import org.apache.commons.lang.time.DateUtils;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kra.committee.web.CommitteeSeleniumHelper;
import org.kuali.kra.test.infrastructure.KcSeleniumTestBase;

public class CommitteeCompleteSeleniumTest
extends KcSeleniumTestBase {
    private static final String PERSON_ID_TAG = "committeeHelper.newCommitteeMembership.personId";
    private static final String ROLODEX_ID_TAG = "committeeHelper.newCommitteeMembership.rolodexId";
    private static final String RESEARCH_AREAS_TAG = "committeeResearchAreas";
    private static final String PERSON_ID_ID = "personId";
    private static final String ROLODEX_ID_ID = "rolodexId";
    private static final String MEMBERSHIP_TYPE_CODE_ID = "document.committeeList[0].committeeMemberships[%d].membershipTypeCode";
    private static final String TERM_START_DATE_ID = "document.committeeList[0].committeeMemberships[%d].termStartDate";
    private static final String TERM_END_DATE_ID = "document.committeeList[0].committeeMemberships[%d].termEndDate";
    private static final String MEMBERSHIP_ROLE_CODE_ID = "committeeHelper.newCommitteeMembershipRoles[%d].membershipRoleCode";
    private static final String START_DATE_ID = "committeeHelper.newCommitteeMembershipRoles[%d].startDate";
    private static final String END_DATE_ID = "committeeHelper.newCommitteeMembershipRoles[%d].endDate";
    private static final String RESEARCH_AREA_CODE_ID = "researchAreaCode";
    private static final String SCHEDULE_START_DATE_ID = "committeeHelper.scheduleData.scheduleStartDate";
    private static final String RECURRENCE_TYPE_ID = "committeeHelper.scheduleData.recurrenceType";
    private static final String SCHEDULE_END_DATE_ID = "committeeHelper.scheduleData.monthlySchedule.scheduleEndDate";
    private static final String VOTING_CHAIR_MEMBERSHIP_TYPE = "Voting member";
    private static final String NICHOLAS_MAJORS_PERSON_ID = "10000000004";
    private static final String NICHOLAS_MAJORS_NAME = "Nicholas Majors";
    private static final String CHAIR_MEMBERSHIP_ROLE = "Chair";
    private static final String PERSONAL_CULINARY_SERVICES_OTHER_RESEARCH_AREA_CODE = "12.99";
    private static final String PERSONAL_CULINARY_SERVICES_OTHER_NAME = "12.99 Personal and Culinary Services, Other";
    private static final String ALLYSON_CATE_PERSON_ID = "10000000008";
    private static final String ALLYSON_CATE_NAME = "Allyson Cate";
    private static final String IRB_ADMINISTRATOR_MEMBERSHIP_ROLE = "IRB Administrator";
    private static final String AGRICULTURAL_PRODUCTION_OPERATIONS_RESEARCH_AREA_CODE = "01.03";
    private static final String AGRICULTURAL_PRODUCTION_OPERATIONS_NAME = "01.03 Agricultural Production Operations";
    private static final String LEE_VAN_LENTEN_PERSON_ID = "328";
    private static final String LEE_VAN_LENTEN_NAME = "Van Lenten, Lee";
    private static final String ALTERNATE_MEMBERSHIP_ROLE = "Alternate";
    private static final String GENERAL_EDUCATION_RESEARCH_AREA_CODE = "13.01";
    private static final String GENERAL_EDUCATION_NAME = "13.01 Education, General";
    private static final String RECURRENCE_TYPE = "MONTHLY";
    private static final String ADD_MEMBERSHIP_BUTTON = "methodToCall.addCommitteeMembership";
    private static final String ADD_MEMBERSHIP_ROLE_BUTTON = "methodToCall.addCommitteeMembershipRole.document.committeeList[0].committeeMemberships[%d].line%d";
    private static final String ADD_EVENT_BUTTON = "methodToCall.addEvent";
    private static final String SHOW_ALL_MEMBERS_BUTTON = "methodToCall.showAllMembers";
    private String startDate;
    private String endDate;
    private String firstScheduleDate;
    private DateFormat dateFormat = new SimpleDateFormat("MM/dd/yyyy");
    private CommitteeSeleniumHelper helper;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.helper = CommitteeSeleniumHelper.instance(driver);
        this.setupDates();
    }

    @Override
    @After
    public void tearDown() throws Exception {
        this.helper = null;
        super.tearDown();
    }

    @Test
    public void testCommitteeComplete() throws Exception {
        this.helper.createCommittee();
        this.addMembers();
        this.addSchedules();
        this.helper.routeDocument();
        this.assertMembers();
        this.assertSchedule();
    }

    private void addMembers() {
        this.helper.clickCommitteeMembersPage();
        this.addMember(0, true, NICHOLAS_MAJORS_PERSON_ID, CHAIR_MEMBERSHIP_ROLE, PERSONAL_CULINARY_SERVICES_OTHER_RESEARCH_AREA_CODE);
        this.helper.clickCollapseAll();
        this.helper.toggle(SHOW_ALL_MEMBERS_BUTTON);
        this.addMember(1, true, ALLYSON_CATE_PERSON_ID, IRB_ADMINISTRATOR_MEMBERSHIP_ROLE, AGRICULTURAL_PRODUCTION_OPERATIONS_RESEARCH_AREA_CODE);
        this.helper.clickCollapseAll();
        this.helper.toggle(SHOW_ALL_MEMBERS_BUTTON);
        this.addMember(2, false, LEE_VAN_LENTEN_PERSON_ID, ALTERNATE_MEMBERSHIP_ROLE, GENERAL_EDUCATION_RESEARCH_AREA_CODE);
    }

    private void addMember(int index, boolean isEmployee, String personId, String role, String researchAreaCode) {
        if (isEmployee) {
            this.helper.lookup(PERSON_ID_TAG, PERSON_ID_ID, personId);
        } else {
            this.helper.lookup(ROLODEX_ID_TAG, ROLODEX_ID_ID, personId);
        }
        this.helper.click(ADD_MEMBERSHIP_BUTTON);
        this.helper.openTab(index);
        this.helper.openTab(index + 1);
        this.helper.set(String.format(MEMBERSHIP_TYPE_CODE_ID, index), VOTING_CHAIR_MEMBERSHIP_TYPE);
        this.helper.set(String.format(TERM_START_DATE_ID, index), this.startDate);
        this.helper.set(String.format(TERM_END_DATE_ID, index), this.endDate);
        this.helper.openTab(index + 3);
        this.helper.set(String.format(MEMBERSHIP_ROLE_CODE_ID, index), role);
        this.helper.set(String.format(START_DATE_ID, index), this.startDate);
        this.helper.set(String.format(END_DATE_ID, index), this.endDate);
        this.helper.click(String.format(ADD_MEMBERSHIP_ROLE_BUTTON, index, index));
        this.helper.openTab(index + 4);
        this.helper.multiLookup(RESEARCH_AREAS_TAG, RESEARCH_AREA_CODE_ID, researchAreaCode);
        this.helper.saveDocument();
        this.helper.assertSave();
    }

    private void addSchedules() {
        this.helper.clickCommitteeSchedulePage();
        this.helper.set(SCHEDULE_START_DATE_ID, this.startDate);
        this.helper.set(RECURRENCE_TYPE_ID, RECURRENCE_TYPE);
        this.helper.set(SCHEDULE_END_DATE_ID, this.endDate);
        this.helper.click(ADD_EVENT_BUTTON);
        this.helper.saveDocument();
        this.helper.assertSave();
    }

    private void assertMembers() {
        this.helper.clickCommitteeMembersPage();
        this.helper.toggle(SHOW_ALL_MEMBERS_BUTTON);
        this.helper.clickExpandAll();
        this.assertMember(NICHOLAS_MAJORS_NAME, CHAIR_MEMBERSHIP_ROLE, PERSONAL_CULINARY_SERVICES_OTHER_NAME);
        this.assertMember(ALLYSON_CATE_NAME, IRB_ADMINISTRATOR_MEMBERSHIP_ROLE, AGRICULTURAL_PRODUCTION_OPERATIONS_NAME);
        this.assertMember(LEE_VAN_LENTEN_NAME, ALTERNATE_MEMBERSHIP_ROLE, GENERAL_EDUCATION_NAME);
    }

    private void assertMember(String name, String role, String researchArea) {
        this.helper.assertPageContains(name);
        this.helper.assertPageContains(role);
        this.helper.assertPageContains(researchArea);
    }

    private void assertSchedule() {
        this.helper.clickCommitteeSchedulePage();
        this.helper.assertPageContains(this.firstScheduleDate);
    }

    private void setupDates() {
        GregorianCalendar cl = new GregorianCalendar();
        cl.setTime(new Date());
        cl.get(5);
        int month = cl.get(2);
        int year = cl.get(1);
        if (cl.get(5) <= 6) {
            this.startDate = this.dateFormat.format(DateUtils.addDays((Date)new Date(), (int)6));
            this.endDate = this.dateFormat.format(DateUtils.addDays((Date)new Date(), (int)371));
        } else {
            this.startDate = this.dateFormat.format(new Date());
            this.endDate = this.dateFormat.format(DateUtils.addDays((Date)new Date(), (int)365));
        }
        if (month == 11) {
            ++year;
            month = 1;
        } else {
            month += 2;
        }
        this.firstScheduleDate = month < 10 ? "0" + month + "/06/" + year : month + "/06/" + year;
    }
}

