/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.committee.web;

import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kra.committee.web.CommitteeSeleniumHelper;
import org.kuali.kra.test.infrastructure.KcSeleniumTestBase;

public class CommitteeMembershipSeleniumTest
extends KcSeleniumTestBase {
    private static final String MEMBERSHIP_ROLE_TABLE_ID = "membership-role-table-0";
    private static final String MEMBERSHIP_EXPERTISE_TABLE_ID = "membership-expertise-table-0";
    private static final String PERSON_ID_TAG = "committeeHelper.newCommitteeMembership.personId";
    private static final String ROLODEX_ID_TAG = "committeeHelper.newCommitteeMembership.rolodexId";
    private static final String RESEARCH_AREAS_TAG = "committeeResearchAreas";
    private static final String LIST_PREFIX = "document.committeeList[0].";
    private static final String COMMITTEE_MEMBERSHIPS_PREFIX = "committeeMemberships[%d].";
    private static final String HELPER_PREFIX = "committeeHelper.";
    private static final String COMMITTEE_MEMBERSHIP_ROLES_PREFIX = "newCommitteeMembershipRoles[%d].";
    private static final String PERSON_ID_ID = "personId";
    private static final String ROLODEX_ID_ID = "rolodexId";
    private static final String MEMBERSHIP_TYPE_CODE_ID = "membershipTypeCode";
    private static final String TERM_START_DATE_ID = "termStartDate";
    private static final String TERM_END_DATE_ID = "termEndDate";
    private static final String MEMBERSHIP_ROLE_CODE_ID = "membershipRoleCode";
    private static final String START_DATE_ID = "startDate";
    private static final String END_DATE_ID = "endDate";
    private static final String RESEARCH_AREA_CODE_ID = "researchAreaCode";
    private static final String LIST_MEMBERSHIP_TYPE_CODE_ID = "document.committeeList[0].committeeMemberships[%d].membershipTypeCode";
    private static final String LIST_TERM_START_DATE_ID = "document.committeeList[0].committeeMemberships[%d].termStartDate";
    private static final String LIST_TERM_END_DATE_ID = "document.committeeList[0].committeeMemberships[%d].termEndDate";
    private static final String HELPER_MEMBERSHIP_ROLE_CODE_ID = "committeeHelper.newCommitteeMembershipRoles[%d].membershipRoleCode";
    private static final String HELPER_START_DATE_ID = "committeeHelper.newCommitteeMembershipRoles[%d].startDate";
    private static final String HELPER_END_DATE_ID = "committeeHelper.newCommitteeMembershipRoles[%d].endDate";
    private static final String EMPLOYEE_ID = "10000000002";
    private static final String EMPLOYEE_NAME = "Joe Tester";
    private static final String NON_EMPLOYEE_ID = "1727";
    private static final String NON_EMPLOYEE_NAME = "Ho, Pauline";
    private static final String VOTING_CHAIR_MEMBERSHIP_TYPE = "Voting member";
    private static final String MEMBERSHIP_ROLE_CODE_CHAIR = "Chair";
    private static final String MEMBERSHIP_ROLE_CODE_MEMBER_SCIENTIST = "Member - Scientist";
    private static final String RESEARCH_AREA_CODE = "01.0101";
    private static final String RESEARCH_AREA_CODE_NAME = "01.0101 Agricultural Business and Management, General";
    private static final String DATE_2009_01_01 = "01/01/2009";
    private static final String DATE_2009_01_05 = "01/05/2009";
    private static final String DATE_2009_01_10 = "01/10/2009";
    private static final String DATE_2009_01_15 = "01/15/2009";
    private static final String DATE_2009_02_01 = "02/01/2009";
    private static final String DATE_2009_02_10 = "02/10/2009";
    private static final String DATE_2009_12_31 = "12/31/2009";
    private static final String DATE_9999_12_31 = "12/31/9999";
    private static final String ERROR_MEMBERSHIP_TYPE_REQUIRED = "Membership Type (Membership Type) is a required field.";
    private static final String ERROR_TERM_START_DATE_REQUIRED = "Term Start Date (Term Start Date) is a required field.";
    private static final String ERROR_TERM_END_DATE_REQUIRED = "Term End Date (Term End Date) is a required field.";
    private static final String ERROR_MEMBER_ROLE = "Each member must have at least one role.";
    private static final String ERROR_MEMBER_AREA_OF_RESEARCH = "Each member must have at least one area of research.";
    private static final String ERROR_ROLE_END_DATE_RANGE = "Role end date must be greater than or equal to role start date.";
    private static final String ERROR_ROLE_OVERLAPPING = "A member may not have the same role for overlapping time periods.";
    private static final String ADD_COMMITTEE_MEMBERSHIP_BUTTON = "methodToCall.addCommitteeMembership";
    private static final String CLEAR_COMMITTEE_MEMBERSHIP_BUTTON = "methodToCall.clearCommitteeMembership";
    private static final String ADD_COMMITTEE_MEMBERSHIP_ROLE_BUTTON = "methodToCall.addCommitteeMembershipRole.document.committeeList[0].committeeMemberships[0].line0";
    private CommitteeSeleniumHelper helper;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.helper = CommitteeSeleniumHelper.instance(driver);
    }

    @Override
    @After
    public void tearDown() throws Exception {
        this.helper = null;
        super.tearDown();
    }

    @Test
    public void testAddEmployee() throws Exception {
        this.helper.createCommittee();
        this.helper.clickCommitteeMembersPage();
        this.helper.lookup(PERSON_ID_TAG, PERSON_ID_ID, EMPLOYEE_ID);
        this.helper.assertPageContains(EMPLOYEE_NAME);
        this.helper.click(ADD_COMMITTEE_MEMBERSHIP_BUTTON);
        this.helper.assertNoPageErrors();
    }

    @Test
    public void testAddNonEmployee() throws Exception {
        this.helper.createCommittee();
        this.helper.clickCommitteeMembersPage();
        this.helper.lookup(ROLODEX_ID_TAG, ROLODEX_ID_ID, NON_EMPLOYEE_ID);
        this.helper.assertPageContains(NON_EMPLOYEE_NAME);
        this.helper.click(ADD_COMMITTEE_MEMBERSHIP_BUTTON);
        this.helper.assertNoPageErrors();
    }

    @Test
    public void testClearEmployee() throws Exception {
        this.helper.createCommittee();
        this.helper.clickCommitteeMembersPage();
        this.helper.lookup(PERSON_ID_TAG, PERSON_ID_ID, EMPLOYEE_ID);
        this.helper.assertPageContains(EMPLOYEE_NAME);
        this.helper.click(CLEAR_COMMITTEE_MEMBERSHIP_BUTTON);
        this.helper.assertPageDoesNotContain(EMPLOYEE_NAME);
    }

    @Test
    public void testSaveEmployee() throws Exception {
        this.helper.createCommittee();
        this.helper.clickCommitteeMembersPage();
        this.helper.lookup(PERSON_ID_TAG, PERSON_ID_ID, EMPLOYEE_ID);
        this.helper.click(ADD_COMMITTEE_MEMBERSHIP_BUTTON);
        this.helper.openTab(0);
        this.helper.openTab(1);
        this.helper.set(String.format(LIST_MEMBERSHIP_TYPE_CODE_ID, 0), VOTING_CHAIR_MEMBERSHIP_TYPE);
        this.helper.set(String.format(LIST_TERM_START_DATE_ID, 0), DATE_2009_01_01);
        this.helper.set(String.format(LIST_TERM_END_DATE_ID, 0), DATE_9999_12_31);
        this.helper.openTab(3);
        this.addMemberRole(0, MEMBERSHIP_ROLE_CODE_MEMBER_SCIENTIST, DATE_2009_01_01, DATE_9999_12_31);
        this.addMemberRole(0, MEMBERSHIP_ROLE_CODE_CHAIR, DATE_2009_01_01, DATE_2009_01_10);
        this.addMemberRole(0, MEMBERSHIP_ROLE_CODE_CHAIR, DATE_2009_02_01, DATE_2009_02_10);
        this.helper.openTab(4);
        this.helper.multiLookup(RESEARCH_AREAS_TAG, RESEARCH_AREA_CODE_ID, RESEARCH_AREA_CODE);
        this.helper.saveDocument();
        this.helper.assertNoPageErrors();
        this.helper.assertTableRowCount(MEMBERSHIP_ROLE_TABLE_ID, 5);
        this.helper.assertTableCellValueContains(MEMBERSHIP_ROLE_TABLE_ID, MEMBERSHIP_ROLE_CODE_MEMBER_SCIENTIST);
        this.helper.assertTableCellValueContains(MEMBERSHIP_ROLE_TABLE_ID, MEMBERSHIP_ROLE_CODE_CHAIR);
        this.helper.assertTableRowCount(MEMBERSHIP_EXPERTISE_TABLE_ID, 3);
        this.helper.assertTableCellValueContains(MEMBERSHIP_EXPERTISE_TABLE_ID, RESEARCH_AREA_CODE_NAME);
    }

    @Test
    public void testInvalidSaveEmployeeMissingData() throws Exception {
        this.helper.createCommittee();
        this.helper.clickCommitteeMembersPage();
        this.helper.lookup(PERSON_ID_TAG, PERSON_ID_ID, EMPLOYEE_ID);
        this.helper.click(ADD_COMMITTEE_MEMBERSHIP_BUTTON);
        this.helper.saveDocument();
        this.helper.assertPageErrors();
        this.helper.assertPageContains(ERROR_MEMBERSHIP_TYPE_REQUIRED);
        this.helper.assertPageContains(ERROR_TERM_START_DATE_REQUIRED);
        this.helper.assertPageContains(ERROR_TERM_END_DATE_REQUIRED);
        this.helper.assertPageContains(ERROR_MEMBER_ROLE);
        this.helper.assertPageContains(ERROR_MEMBER_AREA_OF_RESEARCH);
    }

    @Test
    public void testInvalidAddRoleStartDateAfterEndDate() throws Exception {
        this.helper.createCommittee();
        this.helper.clickCommitteeMembersPage();
        this.helper.lookup(PERSON_ID_TAG, PERSON_ID_ID, EMPLOYEE_ID);
        this.helper.click(ADD_COMMITTEE_MEMBERSHIP_BUTTON);
        this.helper.openTab(0);
        this.helper.openTab(3);
        this.addMemberRole(0, MEMBERSHIP_ROLE_CODE_MEMBER_SCIENTIST, DATE_2009_12_31, DATE_2009_01_01);
        this.helper.assertPageErrors();
        this.helper.assertPageContains(ERROR_ROLE_END_DATE_RANGE);
    }

    @Test
    public void testInvalidAddRoleOverlappingDates() throws Exception {
        this.helper.createCommittee();
        this.helper.clickCommitteeMembersPage();
        this.helper.lookup(PERSON_ID_TAG, PERSON_ID_ID, EMPLOYEE_ID);
        this.helper.click(ADD_COMMITTEE_MEMBERSHIP_BUTTON);
        this.helper.openTab(0);
        this.helper.openTab(3);
        this.addMemberRole(0, MEMBERSHIP_ROLE_CODE_MEMBER_SCIENTIST, DATE_2009_01_01, DATE_2009_01_10);
        this.helper.assertNoPageErrors();
        this.addMemberRole(0, MEMBERSHIP_ROLE_CODE_MEMBER_SCIENTIST, DATE_2009_01_05, DATE_2009_01_15);
        this.helper.assertPageErrors();
        this.helper.assertPageContains(ERROR_ROLE_OVERLAPPING);
    }

    private void addMemberRole(int index, String membershipRoleCode, String startDate, String endDate) throws Exception {
        this.helper.set(String.format(HELPER_MEMBERSHIP_ROLE_CODE_ID, index), membershipRoleCode);
        this.helper.set(String.format(HELPER_START_DATE_ID, index), startDate);
        this.helper.set(String.format(HELPER_END_DATE_ID, index), endDate);
        this.helper.click(ADD_COMMITTEE_MEMBERSHIP_ROLE_BUTTON);
    }
}

