/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.committee.web;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import org.apache.commons.lang.time.DateUtils;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kra.committee.web.CommitteeSeleniumHelper;
import org.kuali.kra.test.infrastructure.KcSeleniumTestBase;

public class CommitteeScheduleAddSeleniumTest
extends KcSeleniumTestBase {
    private static final String TABLE_ID = "schedule-table";
    private static final String HELPER_PREFIX = "committeeHelper.scheduleData.";
    private static final String LIST_PREFIX = "document.committeeList[0].committeeSchedules[%d].";
    private static final String SCHEDULE_START_DATE_ID = "scheduleStartDate";
    private static final String TIME_ID = "time.time";
    private static final String PLACE_ID = "place";
    private static final String RECURRENCE_TYPE_ID = "recurrenceType";
    private static final String DAILY_SCHEDULE_SCHEDULE_END_DATE_ID = "dailySchedule.scheduleEndDate";
    private static final String DAILY_SCHEDULE_DAY_OPTION_ID = "dailySchedule.dayOption";
    private static final String WEEKLY_SCHEDULE_SCHEDULE_END_DATE_ID = "weeklySchedule.scheduleEndDate";
    private static final String MONTHLY_SCHEDULE_MONTH_OPTION_ID = "monthlySchedule.monthOption";
    private static final String MONTHLY_SCHEDULE_DAY_ID = "monthlySchedule.day";
    private static final String MONTHLY_SCHEDULE_SCHEDULE_END_DATE_ID = "monthlySchedule.scheduleEndDate";
    private static final String YEARLY_SCHEDULE_YEAR_OPTION_ID = "yearlySchedule.yearOption";
    private static final String YEARLY_SCHEDULE_SELECTED_OPTION_1_MONTH_ID = "yearlySchedule.selectedOption1Month";
    private static final String YEARLY_SCHEDULE_SELECTED_OPTION_2_MONTH_ID = "yearlySchedule.selectedOption2Month";
    private static final String YEARLY_SCHEDULE_DAY_ID = "yearlySchedule.day";
    private static final String YEARLY_SCHEDULE_SCHEDULE_END_DATE_ID = "yearlySchedule.scheduleEndDate";
    private static final String SCHEDULE_DATE_ID = "scheduledDate";
    private static final String PROTOCOL_SUB_DEADLINE_ID = "protocolSubDeadline";
    private static final String HELPER_SCHEDULE_START_DATE_ID = "committeeHelper.scheduleData.scheduleStartDate";
    private static final String HELPER_TIME_ID = "committeeHelper.scheduleData.time.time";
    private static final String HELPER_PLACE_ID = "committeeHelper.scheduleData.place";
    private static final String HELPER_RECURRENCE_TYPE_ID = "committeeHelper.scheduleData.recurrenceType";
    private static final String HELPER_DAILY_SCHEDULE_DAY_OPTION_ID = "committeeHelper.scheduleData.dailySchedule.dayOption";
    private static final String HELPER_DAILY_SCHEDULE_SCHEDULE_END_DATE_ID = "committeeHelper.scheduleData.dailySchedule.scheduleEndDate";
    private static final String HELPER_WEEKLY_SCHEDULE_SCHEDULE_END_DATE_ID = "committeeHelper.scheduleData.weeklySchedule.scheduleEndDate";
    private static final String HELPER_MONTHLY_SCHEDULE_MONTH_OPTION_ID = "committeeHelper.scheduleData.monthlySchedule.monthOption";
    private static final String HELPER_MONTHLY_SCHEDULE_DAY_ID = "committeeHelper.scheduleData.monthlySchedule.day";
    private static final String HELPER_MONTHLY_SCHEDULE_SCHEDULE_END_DATE_ID = "committeeHelper.scheduleData.monthlySchedule.scheduleEndDate";
    private static final String HELPER_YEARLY_SCHEDULE_YEAR_OPTION_ID = "committeeHelper.scheduleData.yearlySchedule.yearOption";
    private static final String HELPER_YEARLY_SCHEDULE_SELECTED_OPTION_1_MONTH_ID = "committeeHelper.scheduleData.yearlySchedule.selectedOption1Month";
    private static final String HELPER_YEARLY_SCHEDULE_SELECTED_OPTION_2_MONTH_ID = "committeeHelper.scheduleData.yearlySchedule.selectedOption2Month";
    private static final String HELPER_YEARLY_SCHEDULE_DAY_ID = "committeeHelper.scheduleData.yearlySchedule.day";
    private static final String HELPER_YEARLY_SCHEDULE_SCHEDULE_END_DATE_ID = "committeeHelper.scheduleData.yearlySchedule.scheduleEndDate";
    private static final String LIST_SCHEDULE_DATE_ID = "document.committeeList[0].committeeSchedules[%d].scheduledDate";
    private static final String LIST_PROTOCOL_SUB_DEADLINE_ID = "document.committeeList[0].committeeSchedules[%d].protocolSubDeadline";
    private static final String TIME = "10:10";
    private static final String PLACE = "Davis 103";
    private static final String RECURRENCE_TYPE_DAILY = "DAILY";
    private static final String RECURRENCE_TYPE_WEEKLY = "WEEKLY";
    private static final String RECURRENCE_TYPE_MONTHLY = "MONTHLY";
    private static final String RECURRENCE_TYPE_YEARLY = "YEARLY";
    private static final String SCHEDULE_OPTION_XDAY = "XDAY";
    private static final String SCHEDULE_OPTION_WEEKDAY = "WEEKDAY";
    private static final String SCHEDULE_OPTION_XDAYANDXMONTH = "XDAYANDXMONTH";
    private static final String SCHEDULE_OPTION_XDAYOFWEEKANDXMONTH = "XDAYOFWEEKANDXMONTH";
    private static final String SCHEDULE_OPTION_CMPLX = "CMPLX";
    private static final String ADD_EVENT_BUTTON = "methodToCall.addEvent";
    private static final DateFormat fullFormatter = new SimpleDateFormat("MM/dd/yyyy");
    private static final DateFormat monthFormatter = new SimpleDateFormat("MMMM");
    private static final DateFormat dayOfMonthFormatter = new SimpleDateFormat("d");
    private static final DateFormat dayFormatter = new SimpleDateFormat("EEEE");
    private CommitteeSeleniumHelper helper;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.helper = CommitteeSeleniumHelper.instance(driver);
    }

    @Override
    @After
    public void tearDown() throws Exception {
        this.helper = null;
        super.tearDown();
    }

    @Test
    public void testCommitteScheduleEmptyStartDate() throws Exception {
        this.helper.createCommittee();
        this.helper.clickCommitteeSchedulePage();
        this.helper.set(HELPER_SCHEDULE_START_DATE_ID, "");
        this.helper.set(HELPER_TIME_ID, TIME);
        this.helper.set(HELPER_PLACE_ID, PLACE);
        this.helper.click(ADD_EVENT_BUTTON);
        this.helper.assertPageErrors();
    }

    @Test
    public void testCommitteeScheduleNeverRecurrance() throws Exception {
        this.helper.createCommittee();
        this.helper.clickCommitteeSchedulePage();
        Date scheduleStartDate = new Date();
        Date deadlineDate = DateUtils.addDays((Date)scheduleStartDate, (int)-1);
        this.helper.set(HELPER_SCHEDULE_START_DATE_ID, fullFormatter.format(scheduleStartDate));
        this.helper.set(HELPER_TIME_ID, TIME);
        this.helper.set(HELPER_PLACE_ID, PLACE);
        this.helper.click(ADD_EVENT_BUTTON);
        this.helper.assertNoPageErrors();
        this.helper.assertTableRowCount(TABLE_ID, 4);
        this.helper.assertElementContains(String.format(LIST_SCHEDULE_DATE_ID, 0), fullFormatter.format(scheduleStartDate));
        this.helper.assertTableCellValueContains(TABLE_ID, 2, 1, dayFormatter.format(scheduleStartDate).toUpperCase());
        this.helper.assertElementContains(String.format(LIST_PROTOCOL_SUB_DEADLINE_ID, 0), fullFormatter.format(deadlineDate));
    }

    @Test
    public void testCommitteeScheduleDailyRecurranceOptionEveryXDay() throws Exception {
        this.helper.createCommittee();
        this.helper.clickCommitteeSchedulePage();
        Date scheduleStartDate = new Date();
        Date scheduleEndDate = DateUtils.addDays((Date)scheduleStartDate, (int)3);
        this.helper.set(HELPER_SCHEDULE_START_DATE_ID, fullFormatter.format(scheduleStartDate));
        this.helper.set(HELPER_TIME_ID, TIME);
        this.helper.set(HELPER_PLACE_ID, PLACE);
        this.helper.set(HELPER_RECURRENCE_TYPE_ID, RECURRENCE_TYPE_DAILY);
        this.helper.set(HELPER_DAILY_SCHEDULE_DAY_OPTION_ID, SCHEDULE_OPTION_XDAY);
        this.helper.set(HELPER_DAILY_SCHEDULE_SCHEDULE_END_DATE_ID, fullFormatter.format(scheduleEndDate));
        this.helper.click(ADD_EVENT_BUTTON);
        this.helper.assertNoPageErrors();
        Date firstScheduleDate = DateUtils.addDays((Date)scheduleStartDate, (int)0);
        Date firstDeadlineDate = DateUtils.addDays((Date)firstScheduleDate, (int)-1);
        Date secondScheduleDate = DateUtils.addDays((Date)scheduleStartDate, (int)1);
        Date secondDeadlineDate = DateUtils.addDays((Date)secondScheduleDate, (int)-1);
        Date thirdScheduleDate = DateUtils.addDays((Date)scheduleStartDate, (int)2);
        Date thirdDeadlineDate = DateUtils.addDays((Date)thirdScheduleDate, (int)-1);
        Date fourthScheduleDate = DateUtils.addDays((Date)scheduleStartDate, (int)3);
        Date fourthDeadlineDate = DateUtils.addDays((Date)fourthScheduleDate, (int)-1);
        this.helper.assertTableRowCount(TABLE_ID, 7);
        this.helper.assertElementContains(String.format(LIST_SCHEDULE_DATE_ID, 0), fullFormatter.format(firstScheduleDate));
        this.helper.assertTableCellValueContains(TABLE_ID, 2, 1, dayFormatter.format(firstScheduleDate).toUpperCase());
        this.helper.assertElementContains(String.format(LIST_PROTOCOL_SUB_DEADLINE_ID, 0), fullFormatter.format(firstDeadlineDate));
        this.helper.assertElementContains(String.format(LIST_SCHEDULE_DATE_ID, 1), fullFormatter.format(secondScheduleDate));
        this.helper.assertTableCellValueContains(TABLE_ID, 3, 1, dayFormatter.format(secondScheduleDate).toUpperCase());
        this.helper.assertElementContains(String.format(LIST_PROTOCOL_SUB_DEADLINE_ID, 1), fullFormatter.format(secondDeadlineDate));
        this.helper.assertElementContains(String.format(LIST_SCHEDULE_DATE_ID, 2), fullFormatter.format(thirdScheduleDate));
        this.helper.assertTableCellValueContains(TABLE_ID, 4, 1, dayFormatter.format(thirdScheduleDate).toUpperCase());
        this.helper.assertElementContains(String.format(LIST_PROTOCOL_SUB_DEADLINE_ID, 2), fullFormatter.format(thirdDeadlineDate));
        this.helper.assertElementContains(String.format(LIST_SCHEDULE_DATE_ID, 3), fullFormatter.format(fourthScheduleDate));
        this.helper.assertTableCellValueContains(TABLE_ID, 5, 1, dayFormatter.format(fourthScheduleDate).toUpperCase());
        this.helper.assertElementContains(String.format(LIST_PROTOCOL_SUB_DEADLINE_ID, 3), fullFormatter.format(fourthDeadlineDate));
    }

    @Test
    public void testCommitteeScheduleDailyRecurranceOptionEveryWeekday() throws Exception {
        this.helper.createCommittee();
        this.helper.clickCommitteeSchedulePage();
        Date scheduleStartDate = new Date();
        Date scheduleEndDate = DateUtils.addDays((Date)scheduleStartDate, (int)3);
        this.helper.set(HELPER_SCHEDULE_START_DATE_ID, fullFormatter.format(scheduleStartDate));
        this.helper.set(HELPER_TIME_ID, TIME);
        this.helper.set(HELPER_PLACE_ID, PLACE);
        this.helper.set(HELPER_RECURRENCE_TYPE_ID, RECURRENCE_TYPE_DAILY);
        this.helper.set(HELPER_DAILY_SCHEDULE_DAY_OPTION_ID, SCHEDULE_OPTION_WEEKDAY);
        this.helper.set(HELPER_DAILY_SCHEDULE_SCHEDULE_END_DATE_ID, fullFormatter.format(scheduleEndDate));
        this.helper.click(ADD_EVENT_BUTTON);
        this.helper.assertNoPageErrors();
        Date firstScheduleDate = DateUtils.addDays((Date)scheduleStartDate, (int)0);
        Date firstDeadlineDate = DateUtils.addDays((Date)firstScheduleDate, (int)-1);
        Date secondScheduleDate = DateUtils.addDays((Date)scheduleStartDate, (int)1);
        Date secondDeadlineDate = DateUtils.addDays((Date)secondScheduleDate, (int)-1);
        Date thirdScheduleDate = DateUtils.addDays((Date)scheduleStartDate, (int)2);
        Date thirdDeadlineDate = DateUtils.addDays((Date)thirdScheduleDate, (int)-1);
        Date fourthScheduleDate = DateUtils.addDays((Date)scheduleStartDate, (int)3);
        Date fourthDeadlineDate = DateUtils.addDays((Date)fourthScheduleDate, (int)-1);
        int tableRowCount = 3;
        if (this.isWeekday(firstScheduleDate)) {
            ++tableRowCount;
        }
        if (this.isWeekday(secondScheduleDate)) {
            ++tableRowCount;
        }
        if (this.isWeekday(thirdScheduleDate)) {
            ++tableRowCount;
        }
        if (this.isWeekday(fourthScheduleDate)) {
            ++tableRowCount;
        }
        this.helper.assertTableRowCount(TABLE_ID, tableRowCount);
        int index = 0;
        if (this.isWeekday(firstScheduleDate)) {
            this.helper.assertElementContains(String.format(LIST_SCHEDULE_DATE_ID, index), fullFormatter.format(firstScheduleDate));
            this.helper.assertTableCellValueContains(TABLE_ID, index + 2, 1, dayFormatter.format(firstScheduleDate).toUpperCase());
            this.helper.assertElementContains(String.format(LIST_PROTOCOL_SUB_DEADLINE_ID, index), fullFormatter.format(firstDeadlineDate));
            ++index;
        }
        if (this.isWeekday(secondScheduleDate)) {
            this.helper.assertElementContains(String.format(LIST_SCHEDULE_DATE_ID, index), fullFormatter.format(secondScheduleDate));
            this.helper.assertTableCellValueContains(TABLE_ID, index + 2, 1, dayFormatter.format(secondScheduleDate).toUpperCase());
            this.helper.assertElementContains(String.format(LIST_PROTOCOL_SUB_DEADLINE_ID, index), fullFormatter.format(secondDeadlineDate));
            ++index;
        }
        if (this.isWeekday(thirdScheduleDate)) {
            this.helper.assertElementContains(String.format(LIST_SCHEDULE_DATE_ID, index), fullFormatter.format(thirdScheduleDate));
            this.helper.assertTableCellValueContains(TABLE_ID, index + 2, 1, dayFormatter.format(thirdScheduleDate).toUpperCase());
            this.helper.assertElementContains(String.format(LIST_PROTOCOL_SUB_DEADLINE_ID, index), fullFormatter.format(thirdDeadlineDate));
            ++index;
        }
        if (this.isWeekday(fourthScheduleDate)) {
            this.helper.assertElementContains(String.format(LIST_SCHEDULE_DATE_ID, index), fullFormatter.format(fourthScheduleDate));
            this.helper.assertTableCellValueContains(TABLE_ID, index + 2, 1, dayFormatter.format(fourthScheduleDate).toUpperCase());
            this.helper.assertElementContains(String.format(LIST_PROTOCOL_SUB_DEADLINE_ID, index), fullFormatter.format(fourthDeadlineDate));
        }
    }

    @Test
    public void testCommitteeScheduleWeeklyRecurranceMonday() throws Exception {
        this.helper.createCommittee();
        this.helper.clickCommitteeSchedulePage();
        Date scheduleStartDate = new Date();
        Date scheduleEndDate = DateUtils.addDays((Date)scheduleStartDate, (int)7);
        this.helper.set(HELPER_SCHEDULE_START_DATE_ID, fullFormatter.format(scheduleStartDate));
        this.helper.set(HELPER_TIME_ID, TIME);
        this.helper.set(HELPER_PLACE_ID, PLACE);
        this.helper.set(HELPER_RECURRENCE_TYPE_ID, RECURRENCE_TYPE_WEEKLY);
        this.helper.set(HELPER_WEEKLY_SCHEDULE_SCHEDULE_END_DATE_ID, fullFormatter.format(scheduleEndDate));
        this.helper.click(ADD_EVENT_BUTTON);
        this.helper.assertNoPageErrors();
        Date scheduleMonday = this.getMonday(scheduleStartDate);
        Date deadlineDateMonday = DateUtils.addDays((Date)scheduleMonday, (int)-1);
        if (DateUtils.isSameDay((Date)scheduleStartDate, (Date)scheduleMonday)) {
            Date scheduleNextMonday = DateUtils.addDays((Date)scheduleMonday, (int)7);
            Date deadlineDateNextMonday = DateUtils.addDays((Date)scheduleNextMonday, (int)-1);
            this.helper.assertTableRowCount(TABLE_ID, 5);
            this.helper.assertElementContains(String.format(LIST_SCHEDULE_DATE_ID, 0), fullFormatter.format(scheduleMonday));
            this.helper.assertTableCellValueContains(TABLE_ID, 2, 1, dayFormatter.format(scheduleMonday).toUpperCase());
            this.helper.assertElementContains(String.format(LIST_PROTOCOL_SUB_DEADLINE_ID, 0), fullFormatter.format(deadlineDateMonday));
            this.helper.assertElementContains(String.format(LIST_SCHEDULE_DATE_ID, 1), fullFormatter.format(scheduleNextMonday));
            this.helper.assertTableCellValueContains(TABLE_ID, 3, 1, dayFormatter.format(scheduleNextMonday).toUpperCase());
            this.helper.assertElementContains(String.format(LIST_PROTOCOL_SUB_DEADLINE_ID, 1), fullFormatter.format(deadlineDateNextMonday));
        } else {
            this.helper.assertTableRowCount(TABLE_ID, 4);
            this.helper.assertElementContains(String.format(LIST_SCHEDULE_DATE_ID, 0), fullFormatter.format(scheduleMonday));
            this.helper.assertTableCellValueContains(TABLE_ID, 2, 1, dayFormatter.format(scheduleMonday).toUpperCase());
            this.helper.assertElementContains(String.format(LIST_PROTOCOL_SUB_DEADLINE_ID, 0), fullFormatter.format(deadlineDateMonday));
        }
    }

    @Test
    public void testCommitteeScheduleMonthlyRecurranceOptionXDayAndXMonth() throws Exception {
        this.helper.createCommittee();
        this.helper.clickCommitteeSchedulePage();
        Date scheduleStartDate = new Date();
        Date scheduleEndDate = DateUtils.addDays((Date)scheduleStartDate, (int)7);
        Date scheduleDeadlineDate = DateUtils.addDays((Date)scheduleStartDate, (int)-1);
        this.helper.set(HELPER_SCHEDULE_START_DATE_ID, fullFormatter.format(scheduleStartDate));
        this.helper.set(HELPER_TIME_ID, TIME);
        this.helper.set(HELPER_PLACE_ID, PLACE);
        this.helper.set(HELPER_RECURRENCE_TYPE_ID, RECURRENCE_TYPE_MONTHLY);
        this.helper.set(HELPER_MONTHLY_SCHEDULE_MONTH_OPTION_ID, SCHEDULE_OPTION_XDAYANDXMONTH);
        this.helper.set(HELPER_MONTHLY_SCHEDULE_DAY_ID, dayOfMonthFormatter.format(scheduleStartDate));
        this.helper.set(HELPER_MONTHLY_SCHEDULE_SCHEDULE_END_DATE_ID, fullFormatter.format(scheduleEndDate));
        this.helper.click(ADD_EVENT_BUTTON);
        this.helper.assertNoPageErrors();
        this.helper.assertTableRowCount(TABLE_ID, 4);
        this.helper.assertElementContains(String.format(LIST_SCHEDULE_DATE_ID, 0), fullFormatter.format(scheduleStartDate));
        this.helper.assertTableCellValueContains(TABLE_ID, 2, 1, dayFormatter.format(scheduleStartDate).toUpperCase());
        this.helper.assertElementContains(String.format(LIST_PROTOCOL_SUB_DEADLINE_ID, 0), fullFormatter.format(scheduleDeadlineDate));
    }

    @Test
    public void testCommitteeScheduleMonthlyRecurranceOptionXDayOfWeekAndXMonth() throws Exception {
        this.helper.createCommittee();
        this.helper.clickCommitteeSchedulePage();
        Date scheduleStartDate = DateUtils.truncate((Date)new Date(), (int)2);
        Date scheduleEndDate = DateUtils.addDays((Date)scheduleStartDate, (int)10);
        this.helper.set(HELPER_SCHEDULE_START_DATE_ID, fullFormatter.format(scheduleStartDate));
        this.helper.set(HELPER_TIME_ID, TIME);
        this.helper.set(HELPER_PLACE_ID, PLACE);
        this.helper.set(HELPER_RECURRENCE_TYPE_ID, RECURRENCE_TYPE_MONTHLY);
        this.helper.set(HELPER_MONTHLY_SCHEDULE_MONTH_OPTION_ID, SCHEDULE_OPTION_XDAYOFWEEKANDXMONTH);
        this.helper.set(HELPER_MONTHLY_SCHEDULE_SCHEDULE_END_DATE_ID, fullFormatter.format(scheduleEndDate));
        this.helper.click(ADD_EVENT_BUTTON);
        this.helper.assertNoPageErrors();
        Date scheduleMonday = this.getMonday(scheduleStartDate);
        Date deadlineDateMonday = DateUtils.addDays((Date)scheduleMonday, (int)-1);
        this.helper.assertTableRowCount(TABLE_ID, 4);
        this.helper.assertElementContains(String.format(LIST_SCHEDULE_DATE_ID, 0), fullFormatter.format(scheduleMonday));
        this.helper.assertTableCellValueContains(TABLE_ID, 2, 1, dayFormatter.format(scheduleMonday).toUpperCase());
        this.helper.assertElementContains(String.format(LIST_PROTOCOL_SUB_DEADLINE_ID, 0), fullFormatter.format(deadlineDateMonday));
    }

    @Test
    public void testCommitteeScheduleYearlyRecurranceOptionEveryXDay() throws Exception {
        this.helper.createCommittee();
        this.helper.clickCommitteeSchedulePage();
        Date scheduleStartDate = new Date();
        Date scheduleEndDate = DateUtils.addDays((Date)scheduleStartDate, (int)10);
        Date scheduleDeadlineDate = DateUtils.addDays((Date)scheduleStartDate, (int)-1);
        this.helper.set(HELPER_SCHEDULE_START_DATE_ID, fullFormatter.format(scheduleStartDate));
        this.helper.set(HELPER_TIME_ID, TIME);
        this.helper.set(HELPER_PLACE_ID, PLACE);
        this.helper.set(HELPER_RECURRENCE_TYPE_ID, RECURRENCE_TYPE_YEARLY);
        this.helper.set(HELPER_YEARLY_SCHEDULE_YEAR_OPTION_ID, SCHEDULE_OPTION_XDAY);
        this.helper.set(HELPER_YEARLY_SCHEDULE_SELECTED_OPTION_1_MONTH_ID, monthFormatter.format(scheduleStartDate).toUpperCase());
        this.helper.set(HELPER_YEARLY_SCHEDULE_DAY_ID, dayOfMonthFormatter.format(scheduleStartDate));
        this.helper.set(HELPER_YEARLY_SCHEDULE_SCHEDULE_END_DATE_ID, fullFormatter.format(scheduleEndDate));
        this.helper.click(ADD_EVENT_BUTTON);
        this.helper.assertNoPageErrors();
        this.helper.assertTableRowCount(TABLE_ID, 4);
        this.helper.assertElementContains(String.format(LIST_SCHEDULE_DATE_ID, 0), fullFormatter.format(scheduleStartDate));
        this.helper.assertTableCellValueContains(TABLE_ID, 2, 1, dayFormatter.format(scheduleStartDate).toUpperCase());
        this.helper.assertElementContains(String.format(LIST_PROTOCOL_SUB_DEADLINE_ID, 0), fullFormatter.format(scheduleDeadlineDate));
    }

    @Test
    public void testCommitteeScheduleYearlyRecurranceOptionCmplx() throws Exception {
        this.helper.createCommittee();
        this.helper.clickCommitteeSchedulePage();
        Date scheduleStartDate = DateUtils.truncate((Date)new Date(), (int)2);
        Date scheduleEndDate = DateUtils.addDays((Date)scheduleStartDate, (int)10);
        this.helper.set(HELPER_SCHEDULE_START_DATE_ID, fullFormatter.format(scheduleStartDate));
        this.helper.set(HELPER_TIME_ID, TIME);
        this.helper.set(HELPER_PLACE_ID, PLACE);
        this.helper.set(HELPER_RECURRENCE_TYPE_ID, RECURRENCE_TYPE_YEARLY);
        this.helper.set(HELPER_YEARLY_SCHEDULE_YEAR_OPTION_ID, SCHEDULE_OPTION_CMPLX);
        this.helper.set(HELPER_YEARLY_SCHEDULE_SELECTED_OPTION_2_MONTH_ID, monthFormatter.format(scheduleStartDate).toUpperCase());
        this.helper.set(HELPER_YEARLY_SCHEDULE_SCHEDULE_END_DATE_ID, fullFormatter.format(scheduleEndDate));
        this.helper.click(ADD_EVENT_BUTTON);
        this.helper.assertNoPageErrors();
        Date scheduleMonday = this.getMonday(scheduleStartDate);
        Date deadlineDateMonday = DateUtils.addDays((Date)scheduleMonday, (int)-1);
        this.helper.assertTableRowCount(TABLE_ID, 4);
        this.helper.assertElementContains(String.format(LIST_SCHEDULE_DATE_ID, 0), fullFormatter.format(scheduleMonday));
        this.helper.assertTableCellValueContains(TABLE_ID, 2, 1, dayFormatter.format(scheduleMonday).toUpperCase());
        this.helper.assertElementContains(String.format(LIST_PROTOCOL_SUB_DEADLINE_ID, 0), fullFormatter.format(deadlineDateMonday));
    }

    private boolean isWeekday(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        boolean isSaturday = calendar.get(7) == 7;
        boolean isSunday = calendar.get(7) == 1;
        return !isSaturday && !isSunday;
    }

    private Date getMonday(Date startDate) {
        Date monday = startDate;
        Iterator iter = DateUtils.iterator((Date)startDate, (int)3);
        while (iter.hasNext()) {
            Calendar calendar = (Calendar)iter.next();
            if (calendar.get(7) != 2) continue;
            monday = calendar.getTime();
            break;
        }
        return monday;
    }
}

