/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.committee.web;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.commons.lang.time.DateUtils;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kra.committee.web.CommitteeSeleniumHelper;
import org.kuali.kra.test.infrastructure.KcSeleniumTestBase;

public class CommitteeScheduleFilterSeleniumTest
extends KcSeleniumTestBase {
    private static final String TABLE_ID = "schedule-table";
    private static final String HELPER_PREFIX = "committeeHelper.scheduleData.";
    private static final String LIST_PREFIX = "document.committeeList[0].committeeSchedules[%d].";
    private static final String SCHEDULE_START_DATE_ID = "scheduleStartDate";
    private static final String TIME_ID = "time.time";
    private static final String PLACE_ID = "place";
    private static final String RECURRENCE_TYPE_ID = "recurrenceType";
    private static final String DAILY_SCHEDULE_SCHEDULE_END_DATE_ID = "dailySchedule.scheduleEndDate";
    private static final String FILTER_START_DATE_ID = "filterStartDate";
    private static final String FILTER_END_DATE_ID = "filerEndDate";
    private static final String SCHEDULE_DATE_ID = "scheduledDate";
    private static final String PROTOCOL_SUB_DEADLINE_ID = "protocolSubDeadline";
    private static final String HELPER_SCHEDULE_START_DATE_ID = "committeeHelper.scheduleData.scheduleStartDate";
    private static final String HELPER_TIME_ID = "committeeHelper.scheduleData.time.time";
    private static final String HELPER_PLACE_ID = "committeeHelper.scheduleData.place";
    private static final String HELPER_RECURRENCE_TYPE_ID = "committeeHelper.scheduleData.recurrenceType";
    private static final String HELPER_DAILY_SCHEDULE_SCHEDULE_END_DATE_ID = "committeeHelper.scheduleData.dailySchedule.scheduleEndDate";
    private static final String HELPER_FILTER_START_DATE_ID = "committeeHelper.scheduleData.filterStartDate";
    private static final String HELPER_FILTER_END_DATE_ID = "committeeHelper.scheduleData.filerEndDate";
    private static final String LIST_SCHEDULE_DATE_ID = "document.committeeList[0].committeeSchedules[%d].scheduledDate";
    private static final String LIST_PROTOCOL_SUB_DEADLINE_ID = "document.committeeList[0].committeeSchedules[%d].protocolSubDeadline";
    private static final String TIME = "10:10";
    private static final String PLACE = "Davis 103";
    private static final String RECURRENCE_TYPE = "DAILY";
    private static final String ADD_EVENT_BUTTON = "methodToCall.addEvent";
    private static final String FILTER_COMMITTEE_SCHEDULE_DATES_BUTTON = "methodToCall.filterCommitteeScheduleDates";
    private static final String RESET_COMMITTEE_SCHEDULE_DATES_BUTTON = "methodToCall.resetCommitteeScheduleDates";
    private static final DateFormat fullFormatter = new SimpleDateFormat("MM/dd/yyyy");
    private static final DateFormat dayFormatter = new SimpleDateFormat("EEEE");
    private CommitteeSeleniumHelper helper;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.helper = CommitteeSeleniumHelper.instance(driver);
    }

    @Override
    @After
    public void tearDown() throws Exception {
        this.helper = null;
        super.tearDown();
    }

    @Test
    public void testFilter() throws Exception {
        this.helper.createCommittee();
        this.helper.clickCommitteeSchedulePage();
        Date scheduleStartDate = DateUtils.addDays((Date)new Date(), (int)-1);
        Date filterEndDate = DateUtils.addDays((Date)scheduleStartDate, (int)1);
        Date scheduleEndDate = DateUtils.addDays((Date)scheduleStartDate, (int)2);
        this.helper.set(HELPER_SCHEDULE_START_DATE_ID, fullFormatter.format(scheduleStartDate));
        this.helper.set(HELPER_TIME_ID, TIME);
        this.helper.set(HELPER_PLACE_ID, PLACE);
        this.helper.set(HELPER_RECURRENCE_TYPE_ID, RECURRENCE_TYPE);
        this.helper.set(HELPER_DAILY_SCHEDULE_SCHEDULE_END_DATE_ID, fullFormatter.format(scheduleEndDate));
        this.helper.click(ADD_EVENT_BUTTON);
        this.helper.assertNoPageErrors();
        Date firstScheduleDate = DateUtils.addDays((Date)scheduleStartDate, (int)0);
        Date firstDeadlineDate = DateUtils.addDays((Date)firstScheduleDate, (int)-1);
        Date secondScheduleDate = DateUtils.addDays((Date)scheduleStartDate, (int)1);
        Date secondDeadlineDate = DateUtils.addDays((Date)secondScheduleDate, (int)-1);
        Date thirdScheduleDate = DateUtils.addDays((Date)scheduleStartDate, (int)2);
        Date thirdDeadlineDate = DateUtils.addDays((Date)thirdScheduleDate, (int)-1);
        this.helper.assertTableRowCount(TABLE_ID, 6);
        this.helper.assertElementContains(String.format(LIST_SCHEDULE_DATE_ID, 0), fullFormatter.format(firstScheduleDate));
        this.helper.assertTableCellValueContains(TABLE_ID, 2, 1, dayFormatter.format(firstScheduleDate).toUpperCase());
        this.helper.assertElementContains(String.format(LIST_PROTOCOL_SUB_DEADLINE_ID, 0), fullFormatter.format(firstDeadlineDate));
        this.helper.assertElementContains(String.format(LIST_SCHEDULE_DATE_ID, 1), fullFormatter.format(secondScheduleDate));
        this.helper.assertTableCellValueContains(TABLE_ID, 3, 1, dayFormatter.format(secondScheduleDate).toUpperCase());
        this.helper.assertElementContains(String.format(LIST_PROTOCOL_SUB_DEADLINE_ID, 1), fullFormatter.format(secondDeadlineDate));
        this.helper.assertElementContains(String.format(LIST_SCHEDULE_DATE_ID, 2), fullFormatter.format(thirdScheduleDate));
        this.helper.assertTableCellValueContains(TABLE_ID, 4, 1, dayFormatter.format(thirdScheduleDate).toUpperCase());
        this.helper.assertElementContains(String.format(LIST_PROTOCOL_SUB_DEADLINE_ID, 2), fullFormatter.format(thirdDeadlineDate));
        this.helper.set(HELPER_FILTER_START_DATE_ID, fullFormatter.format(scheduleStartDate));
        this.helper.set(HELPER_FILTER_END_DATE_ID, fullFormatter.format(filterEndDate));
        this.helper.click(FILTER_COMMITTEE_SCHEDULE_DATES_BUTTON);
        this.helper.assertTableRowCount(TABLE_ID, 5);
        this.helper.assertElementContains(String.format(LIST_SCHEDULE_DATE_ID, 0), fullFormatter.format(firstScheduleDate));
        this.helper.assertTableCellValueContains(TABLE_ID, 2, 1, dayFormatter.format(firstScheduleDate).toUpperCase());
        this.helper.assertElementContains(String.format(LIST_PROTOCOL_SUB_DEADLINE_ID, 0), fullFormatter.format(firstDeadlineDate));
        this.helper.assertElementContains(String.format(LIST_SCHEDULE_DATE_ID, 1), fullFormatter.format(secondScheduleDate));
        this.helper.assertTableCellValueContains(TABLE_ID, 3, 1, dayFormatter.format(secondScheduleDate).toUpperCase());
        this.helper.assertElementContains(String.format(LIST_PROTOCOL_SUB_DEADLINE_ID, 1), fullFormatter.format(secondDeadlineDate));
        this.helper.click(RESET_COMMITTEE_SCHEDULE_DATES_BUTTON);
        this.helper.assertTableRowCount(TABLE_ID, 6);
        this.helper.assertElementContains(String.format(LIST_SCHEDULE_DATE_ID, 0), fullFormatter.format(firstScheduleDate));
        this.helper.assertTableCellValueContains(TABLE_ID, 2, 1, dayFormatter.format(firstScheduleDate).toUpperCase());
        this.helper.assertElementContains(String.format(LIST_PROTOCOL_SUB_DEADLINE_ID, 0), fullFormatter.format(firstDeadlineDate));
        this.helper.assertElementContains(String.format(LIST_SCHEDULE_DATE_ID, 1), fullFormatter.format(secondScheduleDate));
        this.helper.assertTableCellValueContains(TABLE_ID, 3, 1, dayFormatter.format(secondScheduleDate).toUpperCase());
        this.helper.assertElementContains(String.format(LIST_PROTOCOL_SUB_DEADLINE_ID, 1), fullFormatter.format(secondDeadlineDate));
        this.helper.assertElementContains(String.format(LIST_SCHEDULE_DATE_ID, 2), fullFormatter.format(thirdScheduleDate));
        this.helper.assertTableCellValueContains(TABLE_ID, 4, 1, dayFormatter.format(thirdScheduleDate).toUpperCase());
        this.helper.assertElementContains(String.format(LIST_PROTOCOL_SUB_DEADLINE_ID, 2), fullFormatter.format(thirdDeadlineDate));
    }
}

