/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.committee.web;

import org.kuali.kra.test.infrastructure.KcSeleniumHelper;
import org.openqa.selenium.WebDriver;

public class CommitteeSeleniumHelper
extends KcSeleniumHelper {
    private static final String PAGE_TITLE = "Kuali :: Committee Document";
    private static final String CREATE_COMMITTEE_LINK_NAME = "Create Committee";
    private static final String COMMITTEE_LINK_NAME = "committee";
    private static final String SCHEDULE_LINK_NAME = "committeeSchedule";
    private static final String MEMBERS_LINK_NAME = "committeeMembership";
    private static final String ACTIONS_LINK_NAME = "committeeActions";
    private static final String RESEARCH_AREAS_TAG = "committeeResearchAreas";
    private static final String DOCUMENT_DESCRIPTION_ID = "document.documentHeader.documentDescription";
    private static final String LIST_PREFIX = "document.committeeList[0].";
    private static final String ID_ID = "document.committeeList[0].committeeId";
    private static final String NAME_ID = "document.committeeList[0].committeeName";
    private static final String HOME_UNIT_NUMBER_ID = "document.committeeList[0].homeUnitNumber";
    private static final String TYPE_CODE_ID = "document.committeeList[0].committeeTypeCode";
    private static final String DESCRIPTION_ID = "document.committeeList[0].committeeDescription";
    private static final String SCHEDULE_DESCRIPTION_ID = "document.committeeList[0].scheduleDescription";
    private static final String MINIMUM_MEMBERS_REQUIRED_ID = "document.committeeList[0].minimumMembersRequired";
    private static final String MAX_PROTOCOLS_ID = "document.committeeList[0].maxProtocols";
    private static final String ADVANCED_SUBMISSION_DAYS_REQUIRED_ID = "document.committeeList[0].advancedSubmissionDaysRequired";
    private static final String RESEARCH_AREA_CODE_ID = "researchAreaCode";
    private static final String DEFAULT_DOCUMENT_DESCRIPTION = "Committee Web Test";
    private static final String DEFAULT_NAME = " Committee";
    private static final String DEFAULT_HOME_UNIT_NUMBER = "000001";
    private static final String DEFAULT_TYPE = "IRB";
    private static final String DEFAULT_DESCRIPTION = "xxx";
    private static final String DEFAULT_SCHEDULE_DESCRIPTION = "foo";
    private static final String DEFAULT_MINIMUM_MEMBERS_REQUIRED = "3";
    private static final String DEFAULT_MAX_PROTOCOLS = "10";
    private static final String DEFAULT_ADVANCED_SUBMISSION_DAYS_REQUIRED = "1";
    private static final String DEFAULT_RESEARCH_AREA_CODE = "000001";
    private static CommitteeSeleniumHelper helper;
    private String currentCommitteeId = "";

    public static CommitteeSeleniumHelper instance(WebDriver driver) {
        if (helper == null) {
            helper = new CommitteeSeleniumHelper(driver);
        }
        return helper;
    }

    private CommitteeSeleniumHelper(WebDriver driver) {
        super(driver);
    }

    public final String getCurrentCommitteeID() {
        return this.currentCommitteeId;
    }

    private String getNextCommitteeID() {
        return String.valueOf(System.currentTimeMillis());
    }

    public void clickCommitteeCommitteePage() {
        this.click(COMMITTEE_LINK_NAME);
    }

    public void clickCommitteeMembersPage() {
        this.click(MEMBERS_LINK_NAME);
    }

    public void clickCommitteeSchedulePage() {
        this.click(SCHEDULE_LINK_NAME);
    }

    public void clickCommitteeActionsPage() {
        this.click(ACTIONS_LINK_NAME);
    }

    public final void createCommittee() {
        this.clickCentralAdminTab();
        this.click(CREATE_COMMITTEE_LINK_NAME);
        this.assertTitleContains(PAGE_TITLE);
        this.setDefaultRequiredFields();
        this.saveDocument();
        this.assertSave();
        this.multiLookup(RESEARCH_AREAS_TAG, RESEARCH_AREA_CODE_ID, "000001");
        this.saveDocument();
        this.assertSave();
    }

    private void setDefaultRequiredFields() {
        this.currentCommitteeId = this.getNextCommitteeID();
        this.set(DOCUMENT_DESCRIPTION_ID, DEFAULT_DOCUMENT_DESCRIPTION);
        this.set(ID_ID, this.currentCommitteeId);
        this.set(NAME_ID, this.currentCommitteeId + DEFAULT_NAME);
        this.set(HOME_UNIT_NUMBER_ID, "000001");
        this.set(TYPE_CODE_ID, DEFAULT_TYPE);
        this.set(DESCRIPTION_ID, DEFAULT_DESCRIPTION);
        this.set(SCHEDULE_DESCRIPTION_ID, DEFAULT_SCHEDULE_DESCRIPTION);
        this.set(MINIMUM_MEMBERS_REQUIRED_ID, DEFAULT_MINIMUM_MEMBERS_REQUIRED);
        this.set(MAX_PROTOCOLS_ID, DEFAULT_MAX_PROTOCOLS);
        this.set(ADVANCED_SUBMISSION_DAYS_REQUIRED_ID, DEFAULT_ADVANCED_SUBMISSION_DAYS_REQUIRED);
    }
}

