/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.common.notification;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.core.IsEqual;
import org.jmock.Expectations;
import org.jmock.Mockery;
import org.jmock.integration.junit4.JUnit4Mockery;
import org.jmock.internal.ExpectationBuilder;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kra.common.notification.NotificationContext;
import org.kuali.kra.common.notification.bo.KcNotification;
import org.kuali.kra.common.notification.bo.NotificationType;
import org.kuali.kra.common.notification.bo.NotificationTypeRecipient;
import org.kuali.kra.common.notification.exception.UnknownRoleException;
import org.kuali.kra.common.notification.service.impl.KcNotificationServiceImpl;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.service.KcEmailService;
import org.kuali.kra.service.KcPersonService;
import org.kuali.kra.service.RolodexService;
import org.kuali.kra.test.infrastructure.KcUnitTestBase;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.ken.api.notification.Notification;
import org.kuali.rice.ken.api.service.SendNotificationService;
import org.kuali.rice.kim.api.identity.IdentityService;
import org.kuali.rice.kim.api.role.RoleService;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.service.BusinessObjectService;

public class KcNotificationServiceTest
extends KcUnitTestBase {
    private static final String MODULE_CODE_FIELD = "moduleCode";
    private static final String ACTION_CODE_FIELD = "actionCode";
    private static final String DOCUMENT_NUMBER_FIELD = "documentNumber";
    private static final String NOTIFICATION_TYPE_ID_FIELD = "notificationTypeId";
    private static final String MODULE_CODE_VALUE = "1";
    private static final String ACTION_TYPE_CODE_VALUE_101 = "101";
    private static final String ACTION_TYPE_CODE_VALUE_102 = "102";
    private static final String DOCUMENT_NUMBER_VALUE = "1";
    private static final String CONTEXT_NAME_VALUE = "Notification Context";
    private static final Long NOTIFICATION_TYPE_ID_VALUE = 1L;
    private static final String SUBJECT_VALUE = "Message Subject";
    private static final String MESSAGE_VALUE = "Message Text";
    private static final String PRINCIPAL_ID_VALUE_CHEW = "10000000005";
    private static final String PRINCIPAL_NAME_VALUE_JTESTER = "jtester";
    private static final String PRINCIPAL_NAME_VALUE_MAJORS = "majors";
    private static final String ROLODEX_ID_VALUE_UNIVERSITY = "1";
    private static final String EMAIL_ADDRESS_VALUE_CHEW = "kcnotification@gmail.com";
    private static final String EMAIL_ADDRESS_VALUE_JTESTER = "kcnotification@gmail.com";
    private static final String EMAIL_ADDRESS_VALUE_MAJORS = "kcnotification@gmail.com";
    private static final String EMAIL_ADDRESS_VALUE_APP_ADMIN = "kcnotification@gmail.com";
    private static final String EMAIL_ADDRESS_UNIVERSITY = "firstname@kuali.org";
    private static final String DEFAULT_FROM_ADDRESS_VALUE = "bogus@kuali.org";
    private Mockery context = new JUnit4Mockery();
    private KcNotificationServiceImpl service;

    @Override
    @Before
    public void setUp() throws Exception {
        this.service = new KcNotificationServiceImpl();
    }

    @Override
    @After
    public void tearDown() throws Exception {
        this.service = null;
    }

    @Test
    public void testGetNotificationTypeFromContext() throws Exception {
        this.service.setBusinessObjectService(this.getMockSearchBusinessObjectService("1", ACTION_TYPE_CODE_VALUE_101));
        NotificationContext notificationContext = this.getMockNotificationContext();
        NotificationType notificationType = this.service.getNotificationType(notificationContext);
        KcNotificationServiceTest.assertEquals((Object)"1", (Object)notificationType.getModuleCode());
        KcNotificationServiceTest.assertEquals((Object)ACTION_TYPE_CODE_VALUE_101, (Object)notificationType.getActionCode());
        this.context.assertIsSatisfied();
    }

    @Test
    public void testGetNotificationTypeFromCodes() throws Exception {
        this.service.setBusinessObjectService(this.getMockSearchBusinessObjectService("1", ACTION_TYPE_CODE_VALUE_101));
        NotificationType notificationType = this.service.getNotificationType("1", ACTION_TYPE_CODE_VALUE_101);
        KcNotificationServiceTest.assertEquals((Object)"1", (Object)notificationType.getModuleCode());
        KcNotificationServiceTest.assertEquals((Object)ACTION_TYPE_CODE_VALUE_101, (Object)notificationType.getActionCode());
        this.context.assertIsSatisfied();
    }

    @Test
    public void testCreateNotification() throws Exception {
        this.service.setBusinessObjectService(this.getMockSearchBusinessObjectService("1", ACTION_TYPE_CODE_VALUE_101));
        NotificationContext notificationContext = this.getMockNotificationContext();
        KcNotification notification = this.service.createNotificationObject(notificationContext);
        KcNotificationServiceTest.assertEquals((Object)"1", (Object)notification.getDocumentNumber());
        KcNotificationServiceTest.assertEquals((Object)SUBJECT_VALUE, (Object)notification.getSubject());
        KcNotificationServiceTest.assertEquals((Object)MESSAGE_VALUE, (Object)notification.getMessage());
        this.context.assertIsSatisfied();
    }

    @Test
    public void testSaveNotification() throws Exception {
        this.service.setBusinessObjectService(this.getMockSaveBusinessObjectService());
        KcNotification notification = new KcNotification();
        notification.setDocumentNumber("1");
        notification.setSubject(SUBJECT_VALUE);
        notification.setMessage(MESSAGE_VALUE);
        this.service.saveNotification(notification);
        this.context.assertIsSatisfied();
    }

    @Test
    public void testGetNotifications() throws Exception {
        this.service.setBusinessObjectService(this.getMockSearchBusinessObjectService("1", ACTION_TYPE_CODE_VALUE_101, ACTION_TYPE_CODE_VALUE_102));
        HashSet<String> actionTypeCodes = new HashSet<String>();
        actionTypeCodes.add(ACTION_TYPE_CODE_VALUE_101);
        actionTypeCodes.add(ACTION_TYPE_CODE_VALUE_102);
        List notifications = this.service.getNotifications("1", "1", actionTypeCodes);
        for (KcNotification notification : notifications) {
            NotificationType notificationType = notification.getNotificationType();
            KcNotificationServiceTest.assertEquals((Object)"1", (Object)notificationType.getModuleCode());
            KcNotificationServiceTest.assertThat((Object)notificationType.getActionCode(), (Matcher)Matchers.anyOf((Matcher[])new Matcher[]{new IsEqual((Object)ACTION_TYPE_CODE_VALUE_101), new IsEqual((Object)ACTION_TYPE_CODE_VALUE_102)}));
            KcNotificationServiceTest.assertEquals((Object)SUBJECT_VALUE, (Object)notification.getSubject());
            KcNotificationServiceTest.assertEquals((Object)MESSAGE_VALUE, (Object)notification.getMessage());
        }
        this.context.assertIsSatisfied();
    }

    @Test
    public void testSendNotificationFromContext() throws Exception {
        HashSet<String> personEmailAddresses = new HashSet<String>();
        personEmailAddresses.add("kcnotification@gmail.com");
        personEmailAddresses.add("kcnotification@gmail.com");
        this.service.setBusinessObjectService(this.getMockSearchBusinessObjectService("1", ACTION_TYPE_CODE_VALUE_101));
        this.service.setParameterService(this.getParameterService());
        this.service.setSendNotificationService(this.getMockNotificationService());
        this.service.setKcEmailService(this.getMockKcEmailService(personEmailAddresses));
        this.service.setRoleManagementService((RoleService)KraServiceLocator.getService(RoleService.class));
        this.service.setKcPersonService((KcPersonService)KraServiceLocator.getService(KcPersonService.class));
        this.service.setIdentityService((IdentityService)KraServiceLocator.getService(IdentityService.class));
        NotificationContext notificationContext = this.getMockNotificationContext();
        this.service.sendNotification(notificationContext);
        this.context.assertIsSatisfied();
    }

    @Test
    public void testSendNotificationFromContextWithRecipients() throws Exception {
        HashSet<String> personEmailAddresses = new HashSet<String>();
        personEmailAddresses.add("kcnotification@gmail.com");
        personEmailAddresses.add("kcnotification@gmail.com");
        HashSet<String> rolodexEmailAddresses = new HashSet<String>();
        rolodexEmailAddresses.add(EMAIL_ADDRESS_UNIVERSITY);
        this.service.setBusinessObjectService(this.getMockSearchBusinessObjectService("1", ACTION_TYPE_CODE_VALUE_101));
        this.service.setParameterService(this.getParameterService());
        this.service.setSendNotificationService(this.getMockNotificationService());
        this.service.setKcEmailService(this.getMockKcEmailService(personEmailAddresses, rolodexEmailAddresses));
        this.service.setKcPersonService((KcPersonService)KraServiceLocator.getService(KcPersonService.class));
        this.service.setRolodexService((RolodexService)KraServiceLocator.getService(RolodexService.class));
        this.service.setIdentityService((IdentityService)KraServiceLocator.getService(IdentityService.class));
        NotificationContext notificationContext = this.getMockNotificationContext();
        KcNotification notification = new KcNotification();
        notification.setDocumentNumber("1");
        notification.setSubject(SUBJECT_VALUE);
        notification.setMessage(MESSAGE_VALUE);
        ArrayList<NotificationTypeRecipient> notificationTypeRecipients = new ArrayList<NotificationTypeRecipient>();
        NotificationTypeRecipient person = new NotificationTypeRecipient();
        person.setPersonId(PRINCIPAL_ID_VALUE_CHEW);
        notificationTypeRecipients.add(person);
        NotificationTypeRecipient rolodex = new NotificationTypeRecipient();
        rolodex.setRolodexId("1");
        notificationTypeRecipients.add(rolodex);
        this.service.sendNotification(notificationContext, notification, notificationTypeRecipients);
        this.context.assertIsSatisfied();
    }

    @Test
    public void testSendNotificationWithPrincipalNames() throws Exception {
        HashSet<String> personEmailAddresses = new HashSet<String>();
        personEmailAddresses.add("kcnotification@gmail.com");
        personEmailAddresses.add("kcnotification@gmail.com");
        this.service.setParameterService(this.getParameterService());
        this.service.setSendNotificationService(this.getMockNotificationService());
        this.service.setKcEmailService(this.getMockKcEmailService(personEmailAddresses));
        this.service.setIdentityService((IdentityService)KraServiceLocator.getService(IdentityService.class));
        ArrayList<String> principalIds = new ArrayList<String>();
        principalIds.add(PRINCIPAL_NAME_VALUE_JTESTER);
        principalIds.add(PRINCIPAL_NAME_VALUE_MAJORS);
        this.service.sendNotification(CONTEXT_NAME_VALUE, SUBJECT_VALUE, MESSAGE_VALUE, principalIds);
        this.context.assertIsSatisfied();
    }

    @Test
    public void testSendEmailNotification() throws Exception {
        HashSet<String> personEmailAddresses = new HashSet<String>();
        personEmailAddresses.add("kcnotification@gmail.com");
        personEmailAddresses.add("kcnotification@gmail.com");
        this.service.setBusinessObjectService(this.getMockSearchBusinessObjectService("1", ACTION_TYPE_CODE_VALUE_101));
        this.service.setParameterService(this.getParameterService());
        this.service.setKcEmailService(this.getMockKcEmailService(personEmailAddresses));
        this.service.setRoleManagementService((RoleService)KraServiceLocator.getService(RoleService.class));
        this.service.setKcPersonService((KcPersonService)KraServiceLocator.getService(KcPersonService.class));
        this.service.setIdentityService((IdentityService)KraServiceLocator.getService(IdentityService.class));
        NotificationContext notificationContext = this.getMockNotificationContext();
        this.service.sendEmailNotification(notificationContext);
        this.context.assertIsSatisfied();
    }

    private NotificationContext getMockNotificationContext() throws UnknownRoleException {
        final NotificationContext notificationContext = (NotificationContext)this.context.mock(NotificationContext.class);
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((NotificationContext)this.allowing(notificationContext)).getModuleCode();
                this.will(1.returnValue((Object)"1"));
                ((NotificationContext)this.allowing(notificationContext)).getActionTypeCode();
                this.will(1.returnValue((Object)KcNotificationServiceTest.ACTION_TYPE_CODE_VALUE_101));
                ((NotificationContext)this.allowing(notificationContext)).getDocumentNumber();
                this.will(1.returnValue((Object)"1"));
                ((NotificationContext)this.allowing(notificationContext)).getContextName();
                this.will(1.returnValue((Object)KcNotificationServiceTest.CONTEXT_NAME_VALUE));
                ((NotificationContext)this.allowing(notificationContext)).replaceContextVariables(KcNotificationServiceTest.SUBJECT_VALUE);
                this.will(1.returnValue((Object)KcNotificationServiceTest.SUBJECT_VALUE));
                ((NotificationContext)this.allowing(notificationContext)).replaceContextVariables(KcNotificationServiceTest.MESSAGE_VALUE);
                this.will(1.returnValue((Object)KcNotificationServiceTest.MESSAGE_VALUE));
                ((NotificationContext)this.allowing(notificationContext)).populateRoleQualifiers((NotificationTypeRecipient)this.with(1.any(NotificationTypeRecipient.class)));
                ((NotificationContext)this.allowing(notificationContext)).getEmailAttachments();
                this.will(1.returnValue(Collections.emptyList()));
            }
        });
        return notificationContext;
    }

    private BusinessObjectService getMockSearchBusinessObjectService(final String moduleCode, final String ... actionTypeCodes) {
        final BusinessObjectService service = (BusinessObjectService)this.context.mock(BusinessObjectService.class);
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ArrayList<Matcher> matchers = new ArrayList<Matcher>();
                for (String actionTypeCode : actionTypeCodes) {
                    HashMap<String, String> fieldValues = new HashMap<String, String>();
                    fieldValues.put(KcNotificationServiceTest.MODULE_CODE_FIELD, moduleCode);
                    fieldValues.put(KcNotificationServiceTest.ACTION_CODE_FIELD, actionTypeCode);
                    matchers.add(2.equal(fieldValues));
                }
                Matcher[] matcherArray = matchers.toArray(new Matcher[matchers.size()]);
                ArrayList<NotificationType> notificationTypes = new ArrayList<NotificationType>();
                for (String actionTypeCode : actionTypeCodes) {
                    NotificationType notificationType = new NotificationType();
                    notificationType.setNotificationTypeId(NOTIFICATION_TYPE_ID_VALUE);
                    notificationType.setModuleCode(moduleCode);
                    notificationType.setActionCode(actionTypeCode);
                    notificationType.setSubject(KcNotificationServiceTest.SUBJECT_VALUE);
                    notificationType.setMessage(KcNotificationServiceTest.MESSAGE_VALUE);
                    notificationType.setActive(true);
                    ArrayList<NotificationTypeRecipient> notificationTypeRecipients = new ArrayList<NotificationTypeRecipient>();
                    NotificationTypeRecipient notificationTypeRecipient = new NotificationTypeRecipient();
                    notificationTypeRecipient.setRoleName("KC-SYS:KC Superuser");
                    notificationTypeRecipient.setRoleQualifiers(new HashMap());
                    notificationTypeRecipients.add(notificationTypeRecipient);
                    notificationType.setNotificationTypeRecipients(notificationTypeRecipients);
                    notificationTypes.add(notificationType);
                }
                ((BusinessObjectService)this.allowing(service)).findMatching((Class)this.with(2.any(Class.class)), (Map)this.with(Matchers.anyOf((Matcher[])matcherArray)));
                this.will(2.returnValue(notificationTypes));
                HashMap<String, String> fieldValues = new HashMap<String, String>();
                fieldValues.put(KcNotificationServiceTest.NOTIFICATION_TYPE_ID_FIELD, NOTIFICATION_TYPE_ID_VALUE.toString());
                fieldValues.put(KcNotificationServiceTest.DOCUMENT_NUMBER_FIELD, "1");
                ArrayList<KcNotification> notifications = new ArrayList<KcNotification>();
                for (NotificationType notificationType : notificationTypes) {
                    KcNotification notification = new KcNotification();
                    notification.setDocumentNumber("1");
                    notification.setSubject(KcNotificationServiceTest.SUBJECT_VALUE);
                    notification.setMessage(KcNotificationServiceTest.MESSAGE_VALUE);
                    notification.setNotificationType(notificationType);
                    notifications.add(notification);
                }
                ((BusinessObjectService)this.allowing(service)).findMatching(KcNotification.class, fieldValues);
                this.will(2.returnValue(notifications));
            }
        });
        return service;
    }

    private BusinessObjectService getMockSaveBusinessObjectService() {
        final BusinessObjectService service = (BusinessObjectService)this.context.mock(BusinessObjectService.class);
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((BusinessObjectService)this.oneOf(service)).save((PersistableBusinessObject)this.with(3.any(KcNotification.class)));
            }
        });
        return service;
    }

    @Override
    protected ParameterService getParameterService() {
        final ParameterService parameterService = (ParameterService)this.context.mock(ParameterService.class);
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((ParameterService)this.allowing(parameterService)).getParameterValueAsString("KC-GEN", "All", "NORMAL_NOTIFICATION_PRIORITY_ID");
                this.will(4.returnValue((Object)"1"));
                ((ParameterService)this.allowing(parameterService)).getParameterValueAsString("KC-GEN", "All", "SIMPLE_NOTIFICATION_CONTENT_TYPE_ID");
                this.will(4.returnValue((Object)"1"));
                ((ParameterService)this.allowing(parameterService)).getParameterValueAsString("KC-GEN", "All", "SYSTEM_NOTIFICATION_PRODUCER_ID");
                this.will(4.returnValue((Object)"1"));
                ((ParameterService)this.allowing(parameterService)).getParameterValueAsString("KC-GEN", "All", "KC_NOTIFICATION_CHANNEL_ID");
                this.will(4.returnValue((Object)"1"));
                ((ParameterService)this.allowing(parameterService)).getParameterValueAsString("KC-GEN", "All", "ACTION_LIST_DEFAULT_FROM_USER");
                this.will(4.returnValue((Object)"admin"));
                ((ParameterService)this.allowing(parameterService)).getParameterValueAsBoolean("KC-GEN", "All", "EMAIL_NOTIFICATIONS_ENABLED");
                this.will(4.returnValue((Object)true));
            }
        });
        return parameterService;
    }

    private SendNotificationService getMockNotificationService() {
        final SendNotificationService service = (SendNotificationService)this.context.mock(SendNotificationService.class);
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((SendNotificationService)this.oneOf(service)).sendNotification((Notification)this.with(5.any(Notification.class)));
            }
        });
        return service;
    }

    private KcEmailService getMockKcEmailService(final Set<String> personEmailAddresses) {
        final KcEmailService service = (KcEmailService)this.context.mock(KcEmailService.class);
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((KcEmailService)this.allowing(service)).getDefaultFromAddress();
                this.will(6.returnValue((Object)KcNotificationServiceTest.DEFAULT_FROM_ADDRESS_VALUE));
                ((KcEmailService)this.oneOf(service)).sendEmailWithAttachments(KcNotificationServiceTest.DEFAULT_FROM_ADDRESS_VALUE, personEmailAddresses, KcNotificationServiceTest.SUBJECT_VALUE, null, null, KcNotificationServiceTest.MESSAGE_VALUE, true, Collections.emptyList());
            }
        });
        return service;
    }

    private KcEmailService getMockKcEmailService(final Set<String> personEmailAddresses, final Set<String> rolodexEmailAddresses) {
        final KcEmailService service = (KcEmailService)this.context.mock(KcEmailService.class);
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((KcEmailService)this.allowing(service)).getDefaultFromAddress();
                this.will(7.returnValue((Object)KcNotificationServiceTest.DEFAULT_FROM_ADDRESS_VALUE));
                ((KcEmailService)this.oneOf(service)).sendEmailWithAttachments(KcNotificationServiceTest.DEFAULT_FROM_ADDRESS_VALUE, personEmailAddresses, KcNotificationServiceTest.SUBJECT_VALUE, null, null, KcNotificationServiceTest.MESSAGE_VALUE, true, Collections.emptyList());
                ((KcEmailService)this.oneOf(service)).sendEmailWithAttachments(KcNotificationServiceTest.DEFAULT_FROM_ADDRESS_VALUE, rolodexEmailAddresses, KcNotificationServiceTest.SUBJECT_VALUE, null, null, KcNotificationServiceTest.MESSAGE_VALUE, true, Collections.emptyList());
            }
        });
        return service;
    }
}

