/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.common.notification;

import java.util.HashMap;
import java.util.Map;
import org.junit.Test;
import org.kuali.kra.common.notification.NotificationRendererBase;
import org.kuali.kra.test.infrastructure.KcUnitTestBase;

public class NotificationRendererBaseTest
extends KcUnitTestBase {
    private static final String USER_FULLNAME_VAL = "Geoff  McGregor";

    @Test
    public void testRender() {
        String inputText = "The {Q} brown {F} {J} over the lazy {D}.";
        NotificationRendererBase renderer = new NotificationRendererBase(){

            public Map<String, String> getDefaultReplacementParameters() {
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("{J}", "jumps");
                params.put("{Q}", "quick");
                params.put("{D}", "dog");
                params.put("{F}", "fox");
                return params;
            }
        };
        String outputText = renderer.render(inputText);
        NotificationRendererBaseTest.assertEquals((Object)"The quick brown fox jumps over the lazy dog.", (Object)outputText);
        renderer = new NotificationRendererBase(){

            public Map<String, String> getDefaultReplacementParameters() {
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("{J}", null);
                params.put("{Q}", null);
                params.put("{D}", "dog");
                params.put("{F}", "fox");
                return params;
            }
        };
        outputText = renderer.render(inputText);
        NotificationRendererBaseTest.assertEquals((Object)"The {Q} brown fox {J} over the lazy dog.", (Object)outputText);
    }

    @Test
    public void testGetDefaultReplacementParameters() {
        NotificationRendererBase renderer = new NotificationRendererBase(){};
        Map nameValueMap = renderer.getDefaultReplacementParameters();
        NotificationRendererBaseTest.assertEquals((long)3L, (long)nameValueMap.size());
        NotificationRendererBaseTest.assertEquals((Object)USER_FULLNAME_VAL, nameValueMap.get("{USER_FULLNAME}"));
        NotificationRendererBaseTest.assertTrue((boolean)nameValueMap.containsKey("{DOCUMENT_PREFIX}"));
        NotificationRendererBaseTest.assertTrue((boolean)nameValueMap.containsKey("{APP_LINK_PREFIX}"));
    }
}

