/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.common.notification.rules;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.junit.Test;
import org.kuali.kra.common.notification.bo.NotificationTypeRecipient;
import org.kuali.kra.common.notification.rule.AddNotificationRecipientRule;
import org.kuali.kra.common.notification.rule.event.AddNotificationRecipientEvent;
import org.kuali.kra.rules.TemplateRuleTest;
import org.kuali.kra.test.infrastructure.KcUnitTestBase;

public class AddNotificationTypeRecipientRuleTest
extends KcUnitTestBase {
    private static final String ROLE_NAME = "KC-UNT:IRB Administrator";
    private static final String PERSON_ID = "10000000004";
    private static final String ROLODEX_ID = "253";
    private static final String NEW_ROLE_NAME = "KC-PROTOCOL:Protocol Aggregator";
    private static final String NEW_PERSON_ID = "10000000002";
    private static final String NEW_ROLODEX_ID = "254";

    @Test
    public void testNewRoleNameOK() {
        new TemplateRuleTest<AddNotificationRecipientEvent, AddNotificationRecipientRule>(){

            @Override
            protected void prerequisite() {
                NotificationTypeRecipient notificationTypeRecipient = new NotificationTypeRecipient();
                notificationTypeRecipient.setRoleName(AddNotificationTypeRecipientRuleTest.NEW_ROLE_NAME);
                List notificationTypeRecipients = AddNotificationTypeRecipientRuleTest.this.getDefaultNotificationTypeRecipients(AddNotificationTypeRecipientRuleTest.ROLE_NAME, null, null);
                this.event = new AddNotificationRecipientEvent(null, notificationTypeRecipient, notificationTypeRecipients);
                this.rule = new AddNotificationRecipientRule();
                this.expectedReturnValue = true;
            }
        };
    }

    @Test
    public void testNewPersonIdOK() {
        new TemplateRuleTest<AddNotificationRecipientEvent, AddNotificationRecipientRule>(){

            @Override
            protected void prerequisite() {
                NotificationTypeRecipient notificationTypeRecipient = new NotificationTypeRecipient();
                notificationTypeRecipient.setPersonId(AddNotificationTypeRecipientRuleTest.NEW_PERSON_ID);
                List notificationTypeRecipients = AddNotificationTypeRecipientRuleTest.this.getDefaultNotificationTypeRecipients(null, AddNotificationTypeRecipientRuleTest.PERSON_ID, null);
                this.event = new AddNotificationRecipientEvent(null, notificationTypeRecipient, notificationTypeRecipients);
                this.rule = new AddNotificationRecipientRule();
                this.expectedReturnValue = true;
            }
        };
    }

    @Test
    public void testNewRolodexIdOK() {
        new TemplateRuleTest<AddNotificationRecipientEvent, AddNotificationRecipientRule>(){

            @Override
            protected void prerequisite() {
                NotificationTypeRecipient notificationTypeRecipient = new NotificationTypeRecipient();
                notificationTypeRecipient.setRoleName(AddNotificationTypeRecipientRuleTest.NEW_ROLODEX_ID);
                List notificationTypeRecipients = AddNotificationTypeRecipientRuleTest.this.getDefaultNotificationTypeRecipients(null, null, AddNotificationTypeRecipientRuleTest.ROLODEX_ID);
                this.event = new AddNotificationRecipientEvent(null, notificationTypeRecipient, notificationTypeRecipients);
                this.rule = new AddNotificationRecipientRule();
                this.expectedReturnValue = true;
            }
        };
    }

    @Test
    public void testInvalidRecipient() {
        new TemplateRuleTest<AddNotificationRecipientEvent, AddNotificationRecipientRule>(){

            @Override
            protected void prerequisite() {
                NotificationTypeRecipient notificationTypeRecipient = new NotificationTypeRecipient();
                List notificationTypeRecipients = AddNotificationTypeRecipientRuleTest.this.getDefaultNotificationTypeRecipients(AddNotificationTypeRecipientRuleTest.ROLE_NAME, null, null);
                this.event = new AddNotificationRecipientEvent(null, notificationTypeRecipient, notificationTypeRecipients);
                this.rule = new AddNotificationRecipientRule();
                this.expectedReturnValue = false;
            }
        };
    }

    @Test
    public void testDuplicateRoles() {
        new TemplateRuleTest<AddNotificationRecipientEvent, AddNotificationRecipientRule>(){

            @Override
            protected void prerequisite() {
                NotificationTypeRecipient notificationTypeRecipient = new NotificationTypeRecipient();
                notificationTypeRecipient.setRoleName(AddNotificationTypeRecipientRuleTest.ROLE_NAME);
                List notificationTypeRecipients = AddNotificationTypeRecipientRuleTest.this.getDefaultNotificationTypeRecipients(AddNotificationTypeRecipientRuleTest.ROLE_NAME, null, null);
                this.event = new AddNotificationRecipientEvent(null, notificationTypeRecipient, notificationTypeRecipients);
                this.rule = new AddNotificationRecipientRule();
                this.expectedReturnValue = false;
            }
        };
    }

    @Test
    public void testDuplicatePersonIds() {
        new TemplateRuleTest<AddNotificationRecipientEvent, AddNotificationRecipientRule>(){

            @Override
            protected void prerequisite() {
                NotificationTypeRecipient notificationTypeRecipient = new NotificationTypeRecipient();
                notificationTypeRecipient.setPersonId(AddNotificationTypeRecipientRuleTest.PERSON_ID);
                List notificationTypeRecipients = AddNotificationTypeRecipientRuleTest.this.getDefaultNotificationTypeRecipients(null, AddNotificationTypeRecipientRuleTest.PERSON_ID, null);
                this.event = new AddNotificationRecipientEvent(null, notificationTypeRecipient, notificationTypeRecipients);
                this.rule = new AddNotificationRecipientRule();
                this.expectedReturnValue = false;
            }
        };
    }

    @Test
    public void testDuplicateRolodexIds() {
        new TemplateRuleTest<AddNotificationRecipientEvent, AddNotificationRecipientRule>(){

            @Override
            protected void prerequisite() {
                NotificationTypeRecipient notificationTypeRecipient = new NotificationTypeRecipient();
                notificationTypeRecipient.setRolodexId(AddNotificationTypeRecipientRuleTest.ROLODEX_ID);
                List notificationTypeRecipients = AddNotificationTypeRecipientRuleTest.this.getDefaultNotificationTypeRecipients(null, null, AddNotificationTypeRecipientRuleTest.ROLODEX_ID);
                this.event = new AddNotificationRecipientEvent(null, notificationTypeRecipient, notificationTypeRecipients);
                this.rule = new AddNotificationRecipientRule();
                this.expectedReturnValue = false;
            }
        };
    }

    private List<NotificationTypeRecipient> getDefaultNotificationTypeRecipients(String roleName, String personId, String rolodexId) {
        ArrayList<NotificationTypeRecipient> notificationTypeRecipients = new ArrayList<NotificationTypeRecipient>();
        if (StringUtils.isNotBlank((String)roleName)) {
            NotificationTypeRecipient notificationTypeRecipientRoleName = new NotificationTypeRecipient();
            notificationTypeRecipientRoleName.setRoleName(roleName);
            notificationTypeRecipients.add(notificationTypeRecipientRoleName);
        }
        if (StringUtils.isNotBlank((String)personId)) {
            NotificationTypeRecipient notificationTypeRecipientPersonId = new NotificationTypeRecipient();
            notificationTypeRecipientPersonId.setPersonId(personId);
            notificationTypeRecipients.add(notificationTypeRecipientPersonId);
        }
        if (StringUtils.isNotBlank((String)rolodexId)) {
            NotificationTypeRecipient notificationTypeRecipientRolodexId = new NotificationTypeRecipient();
            notificationTypeRecipientRolodexId.setRolodexId(rolodexId);
            notificationTypeRecipients.add(notificationTypeRecipientRolodexId);
        }
        return notificationTypeRecipients;
    }
}

