/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.common.notification.rules;

import java.util.Collections;
import java.util.HashMap;
import org.jmock.Expectations;
import org.jmock.Mockery;
import org.jmock.integration.junit4.JUnit4Mockery;
import org.jmock.internal.ExpectationBuilder;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kra.common.notification.bo.NotificationType;
import org.kuali.kra.common.notification.bo.NotificationTypeRecipient;
import org.kuali.kra.common.notification.rules.NotificationTypeMaintenanceDocumentRule;
import org.kuali.kra.maintenance.MaintenanceRuleTestBase;
import org.kuali.rice.kns.document.MaintenanceDocument;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.service.BusinessObjectService;

public class NotificationTypeMaintenanceDocumentRuleTest
extends MaintenanceRuleTestBase {
    private static final String MODULE_CODE_FIELD_NAME = "moduleCode";
    private static final String ACTION_CODE_FIELD_NAME = "actionCode";
    private static final String ROLE_FIELD_NAME = "notificationTypeRecipients[%d].roleName";
    private static final Long NOTIFICATION_TYPE_ID_10000 = 10000L;
    private static final Long NOTIFICATION_TYPE_ID_10001 = 10001L;
    private static final String MODULE_CODE_1 = "1";
    private static final String MODULE_CODE_2 = "2";
    private static final String ACTION_CODE_101 = "101";
    private static final String ACTION_CODE_102 = "102";
    private static final String ROLE_NAME_1 = "NMSPC-1:Role 1";
    private static final String ROLE_NAME_2 = "NMSPC-1:Role 2";
    private NotificationTypeMaintenanceDocumentRule rule;
    private Mockery context = new JUnit4Mockery();

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.rule = new NotificationTypeMaintenanceDocumentRule();
        this.rule.setBusinessObjectService(this.getMockBusinessObjectService());
    }

    @Override
    @After
    public void tearDown() throws Exception {
        this.rule = null;
        super.tearDown();
    }

    @Test
    public void testModuleCodeActionCodeUnique() throws Exception {
        MaintenanceDocument notificationTypeMaintenanceDocument = this.getNotificationTypeMaintenanceDocument(NOTIFICATION_TYPE_ID_10001, MODULE_CODE_2, ACTION_CODE_102);
        NotificationTypeMaintenanceDocumentRuleTest.assertTrue((boolean)this.rule.processCustomRouteDocumentBusinessRules(notificationTypeMaintenanceDocument));
        NotificationTypeMaintenanceDocumentRuleTest.assertTrue((boolean)this.rule.processCustomApproveDocumentBusinessRules(notificationTypeMaintenanceDocument));
    }

    @Test
    public void testModuleCodeActionCodeNotUnique() throws Exception {
        MaintenanceDocument notificationTypeMaintenanceDocument = this.getNotificationTypeMaintenanceDocument(NOTIFICATION_TYPE_ID_10000, MODULE_CODE_1, ACTION_CODE_101);
        NotificationTypeMaintenanceDocumentRuleTest.assertFalse((boolean)this.rule.processCustomRouteDocumentBusinessRules(notificationTypeMaintenanceDocument));
        NotificationTypeMaintenanceDocumentRuleTest.assertFalse((boolean)this.rule.processCustomApproveDocumentBusinessRules(notificationTypeMaintenanceDocument));
        this.assertFieldErrorExists(ACTION_CODE_FIELD_NAME, "error.notification.moduleCode.actionCode.combination.exists");
    }

    @Test
    public void testNotificationTypeIdRoleIdRoleNameUnique() throws Exception {
        MaintenanceDocument notificationTypeMaintenanceDocument = this.getNotificationTypeMaintenanceDocument(NOTIFICATION_TYPE_ID_10001, MODULE_CODE_2, ACTION_CODE_102, ROLE_NAME_2);
        NotificationTypeMaintenanceDocumentRuleTest.assertTrue((boolean)this.rule.processCustomRouteDocumentBusinessRules(notificationTypeMaintenanceDocument));
        NotificationTypeMaintenanceDocumentRuleTest.assertTrue((boolean)this.rule.processCustomApproveDocumentBusinessRules(notificationTypeMaintenanceDocument));
    }

    @Test
    public void testNotificationTypeIdRoleIdRoleNameNotUnique() throws Exception {
        MaintenanceDocument notificationTypeMaintenanceDocument = this.getNotificationTypeMaintenanceDocument(NOTIFICATION_TYPE_ID_10001, MODULE_CODE_2, ACTION_CODE_102, ROLE_NAME_1);
        NotificationTypeMaintenanceDocumentRuleTest.assertFalse((boolean)this.rule.processCustomRouteDocumentBusinessRules(notificationTypeMaintenanceDocument));
        NotificationTypeMaintenanceDocumentRuleTest.assertFalse((boolean)this.rule.processCustomApproveDocumentBusinessRules(notificationTypeMaintenanceDocument));
        this.assertFieldErrorExists(String.format(ROLE_FIELD_NAME, 1), "error.notification.roleNamespace.roleName.exists");
    }

    private MaintenanceDocument getNotificationTypeMaintenanceDocument(Long notificationTypeId, String moduleCode, String actionCode) throws Exception {
        NotificationType notificationType = new NotificationType();
        notificationType.setNotificationTypeId(notificationTypeId);
        notificationType.setModuleCode(moduleCode);
        notificationType.setActionCode(actionCode);
        return this.newMaintDoc((PersistableBusinessObject)notificationType);
    }

    private MaintenanceDocument getNotificationTypeMaintenanceDocument(Long notificationTypeId, String moduleCode, String actionCode, String roleId) throws Exception {
        NotificationType notificationType = new NotificationType();
        notificationType.setNotificationTypeId(notificationTypeId);
        notificationType.setModuleCode(moduleCode);
        notificationType.setActionCode(actionCode);
        NotificationTypeRecipient notificationTypeRecipient1 = new NotificationTypeRecipient();
        notificationTypeRecipient1.setRoleName(ROLE_NAME_1);
        notificationType.getNotificationTypeRecipients().add(notificationTypeRecipient1);
        NotificationTypeRecipient notificationTypeRecipient2 = new NotificationTypeRecipient();
        notificationTypeRecipient2.setRoleName(roleId);
        notificationType.getNotificationTypeRecipients().add(notificationTypeRecipient2);
        return this.newMaintDoc((PersistableBusinessObject)notificationType);
    }

    private BusinessObjectService getMockBusinessObjectService() {
        final BusinessObjectService service = (BusinessObjectService)this.context.mock(BusinessObjectService.class);
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                HashMap<String, String> fieldValues1 = new HashMap<String, String>();
                fieldValues1.put(NotificationTypeMaintenanceDocumentRuleTest.MODULE_CODE_FIELD_NAME, NotificationTypeMaintenanceDocumentRuleTest.MODULE_CODE_1);
                fieldValues1.put(NotificationTypeMaintenanceDocumentRuleTest.ACTION_CODE_FIELD_NAME, NotificationTypeMaintenanceDocumentRuleTest.ACTION_CODE_101);
                NotificationType notificationType = new NotificationType();
                notificationType.setModuleCode(NotificationTypeMaintenanceDocumentRuleTest.MODULE_CODE_1);
                notificationType.setActionCode(NotificationTypeMaintenanceDocumentRuleTest.ACTION_CODE_101);
                ((BusinessObjectService)this.allowing(service)).findMatching(NotificationType.class, fieldValues1);
                this.will(1.returnValue(Collections.singleton(notificationType)));
            }
        });
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                HashMap<String, String> fieldValues = new HashMap<String, String>();
                fieldValues.put(NotificationTypeMaintenanceDocumentRuleTest.MODULE_CODE_FIELD_NAME, NotificationTypeMaintenanceDocumentRuleTest.MODULE_CODE_2);
                fieldValues.put(NotificationTypeMaintenanceDocumentRuleTest.ACTION_CODE_FIELD_NAME, NotificationTypeMaintenanceDocumentRuleTest.ACTION_CODE_102);
                ((BusinessObjectService)this.allowing(service)).findMatching(NotificationType.class, fieldValues);
                this.will(2.returnValue((Object)Collections.EMPTY_LIST));
            }
        });
        return service;
    }
}

