/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.common.notification.rules;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.junit.Test;
import org.kuali.kra.common.notification.bo.KcNotification;
import org.kuali.kra.common.notification.bo.NotificationTypeRecipient;
import org.kuali.kra.common.notification.rule.SendNotificationRule;
import org.kuali.kra.common.notification.rule.event.SendNotificationEvent;
import org.kuali.kra.rules.TemplateRuleTest;
import org.kuali.kra.test.infrastructure.KcUnitTestBase;

public class SendNotificationRuleTest
extends KcUnitTestBase {
    private static final String SUBJECT = "Subject";
    private static final String MESSAGE = "Message";
    private static final String ROLE_NAME = "KC-UNT:IRB Administrator";
    private static final String PERSON_ID = "10000000004";
    private static final String ROLODEX_ID = "253";

    @Test
    public void testOK() {
        new TemplateRuleTest<SendNotificationEvent, SendNotificationRule>(){

            @Override
            protected void prerequisite() {
                KcNotification notification = new KcNotification();
                notification.setSubject(SendNotificationRuleTest.SUBJECT);
                notification.setMessage(SendNotificationRuleTest.MESSAGE);
                List notificationTypeRecipients = SendNotificationRuleTest.this.getDefaultNotificationTypeRecipients(SendNotificationRuleTest.ROLE_NAME, SendNotificationRuleTest.PERSON_ID, SendNotificationRuleTest.ROLODEX_ID);
                this.event = new SendNotificationEvent(null, notification, notificationTypeRecipients);
                this.rule = new SendNotificationRule();
                this.expectedReturnValue = true;
            }
        };
    }

    @Test
    public void testEmptyRecipient() {
        new TemplateRuleTest<SendNotificationEvent, SendNotificationRule>(){

            @Override
            protected void prerequisite() {
                KcNotification notification = new KcNotification();
                notification.setSubject(SendNotificationRuleTest.SUBJECT);
                notification.setMessage(SendNotificationRuleTest.MESSAGE);
                List notificationTypeRecipients = SendNotificationRuleTest.this.getDefaultNotificationTypeRecipients(null, null, null);
                this.event = new SendNotificationEvent(null, notification, notificationTypeRecipients);
                this.rule = new SendNotificationRule();
                this.expectedReturnValue = false;
            }
        };
    }

    private List<NotificationTypeRecipient> getDefaultNotificationTypeRecipients(String roleName, String personId, String rolodexId) {
        ArrayList<NotificationTypeRecipient> notificationTypeRecipients = new ArrayList<NotificationTypeRecipient>();
        if (StringUtils.isNotBlank((String)roleName)) {
            NotificationTypeRecipient notificationTypeRecipientRoleName = new NotificationTypeRecipient();
            notificationTypeRecipientRoleName.setRoleName(roleName);
            notificationTypeRecipients.add(notificationTypeRecipientRoleName);
        }
        if (StringUtils.isNotBlank((String)personId)) {
            NotificationTypeRecipient notificationTypeRecipientPersonId = new NotificationTypeRecipient();
            notificationTypeRecipientPersonId.setPersonId(personId);
            notificationTypeRecipients.add(notificationTypeRecipientPersonId);
        }
        if (StringUtils.isNotBlank((String)rolodexId)) {
            NotificationTypeRecipient notificationTypeRecipientRolodexId = new NotificationTypeRecipient();
            notificationTypeRecipientRolodexId.setRolodexId(rolodexId);
            notificationTypeRecipients.add(notificationTypeRecipientRolodexId);
        }
        return notificationTypeRecipients;
    }
}

