/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.common.specialreview.lookup.keyvalue;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.jmock.Expectations;
import org.jmock.Mockery;
import org.jmock.integration.junit4.JUnit4Mockery;
import org.jmock.internal.ExpectationBuilder;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kra.bo.SpecialReviewType;
import org.kuali.kra.bo.SpecialReviewUsage;
import org.kuali.kra.common.specialreview.lookup.keyvalue.SpecialReviewTypeValuesFinder;
import org.kuali.kra.test.infrastructure.KcUnitTestBase;
import org.kuali.rice.core.api.util.ConcreteKeyValue;
import org.kuali.rice.kim.api.permission.PermissionService;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.service.KeyValuesService;
import org.kuali.rice.krad.util.GlobalVariables;

public class SpecialReviewTypeValuesFinderTest
extends KcUnitTestBase {
    private static final String MODULE_CODE_NAME = "moduleCode";
    private static final String PERMISSION_NAME = "View Active Special Review Types";
    private static final String HUMAN_SUBJECTS_KEY = "1";
    private static final String ANIMAL_USAGE_KEY = "2";
    private static final String RECOMBINANT_DNA_KEY = "3";
    private static final String HUMAN_SUBJECTS_VALUE = "Human Subjects";
    private static final String ANIMAL_USAGE_VALUE = "Animal Usage";
    private static final String RECOMBINANT_DNA_VALUE = "Recombinant DNA";
    private Mockery context = new JUnit4Mockery();
    private SpecialReviewTypeValuesFinder valuesFinder;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.valuesFinder = new SpecialReviewTypeValuesFinder(){

            public String getModuleCode() {
                return "";
            }
        };
        this.valuesFinder.setKeyValuesService(this.getMockKeyValuesService());
        this.valuesFinder.setBusinessObjectService(this.getMockBusinessObjectService());
    }

    @Override
    @After
    public void tearDown() throws Exception {
        this.valuesFinder = null;
        super.tearDown();
    }

    @Test
    public void testActiveSpecialReviewType() {
        this.valuesFinder.setPermissionService(this.getMockPermissionService(true));
        List values = this.valuesFinder.getKeyValues();
        SpecialReviewTypeValuesFinderTest.assertTrue((boolean)values.contains(new ConcreteKeyValue(HUMAN_SUBJECTS_KEY, HUMAN_SUBJECTS_VALUE)));
        SpecialReviewTypeValuesFinderTest.assertTrue((boolean)values.contains(new ConcreteKeyValue(ANIMAL_USAGE_KEY, ANIMAL_USAGE_VALUE)));
        SpecialReviewTypeValuesFinderTest.assertFalse((boolean)values.contains(new ConcreteKeyValue(RECOMBINANT_DNA_KEY, RECOMBINANT_DNA_VALUE)));
    }

    @Test
    public void testGlobalSpecialReviewType() {
        this.valuesFinder.setPermissionService(this.getMockPermissionService(false));
        List values = this.valuesFinder.getKeyValues();
        SpecialReviewTypeValuesFinderTest.assertTrue((boolean)values.contains(new ConcreteKeyValue(HUMAN_SUBJECTS_KEY, HUMAN_SUBJECTS_VALUE)));
        SpecialReviewTypeValuesFinderTest.assertFalse((boolean)values.contains(new ConcreteKeyValue(ANIMAL_USAGE_KEY, ANIMAL_USAGE_VALUE)));
        SpecialReviewTypeValuesFinderTest.assertFalse((boolean)values.contains(new ConcreteKeyValue(RECOMBINANT_DNA_KEY, RECOMBINANT_DNA_VALUE)));
    }

    @Test
    public void testHasPermissionToViewSpecialReviewType() {
        this.valuesFinder.setPermissionService(this.getMockPermissionService(true));
        List values = this.valuesFinder.getKeyValues();
        SpecialReviewTypeValuesFinderTest.assertTrue((boolean)values.contains(new ConcreteKeyValue(HUMAN_SUBJECTS_KEY, HUMAN_SUBJECTS_VALUE)));
        SpecialReviewTypeValuesFinderTest.assertTrue((boolean)values.contains(new ConcreteKeyValue(ANIMAL_USAGE_KEY, ANIMAL_USAGE_VALUE)));
        SpecialReviewTypeValuesFinderTest.assertFalse((boolean)values.contains(new ConcreteKeyValue(RECOMBINANT_DNA_KEY, RECOMBINANT_DNA_VALUE)));
    }

    @Test
    public void testHasNoPermissionToViewSpecialReviewType() {
        this.valuesFinder.setPermissionService(this.getMockPermissionService(false));
        List values = this.valuesFinder.getKeyValues();
        SpecialReviewTypeValuesFinderTest.assertTrue((boolean)values.contains(new ConcreteKeyValue(HUMAN_SUBJECTS_KEY, HUMAN_SUBJECTS_VALUE)));
        SpecialReviewTypeValuesFinderTest.assertFalse((boolean)values.contains(new ConcreteKeyValue(ANIMAL_USAGE_KEY, ANIMAL_USAGE_VALUE)));
        SpecialReviewTypeValuesFinderTest.assertFalse((boolean)values.contains(new ConcreteKeyValue(RECOMBINANT_DNA_KEY, RECOMBINANT_DNA_VALUE)));
    }

    private KeyValuesService getMockKeyValuesService() {
        final KeyValuesService service = (KeyValuesService)this.context.mock(KeyValuesService.class);
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ArrayList<SpecialReviewType> specialReviewTypes = new ArrayList<SpecialReviewType>();
                SpecialReviewType humanSubjectsType = new SpecialReviewType();
                humanSubjectsType.setSpecialReviewTypeCode(SpecialReviewTypeValuesFinderTest.HUMAN_SUBJECTS_KEY);
                humanSubjectsType.setDescription(SpecialReviewTypeValuesFinderTest.HUMAN_SUBJECTS_VALUE);
                specialReviewTypes.add(humanSubjectsType);
                SpecialReviewType animalUsageType = new SpecialReviewType();
                animalUsageType.setSpecialReviewTypeCode(SpecialReviewTypeValuesFinderTest.ANIMAL_USAGE_KEY);
                animalUsageType.setDescription(SpecialReviewTypeValuesFinderTest.ANIMAL_USAGE_VALUE);
                specialReviewTypes.add(animalUsageType);
                SpecialReviewType recombinantDNAType = new SpecialReviewType();
                recombinantDNAType.setSpecialReviewTypeCode(SpecialReviewTypeValuesFinderTest.RECOMBINANT_DNA_KEY);
                recombinantDNAType.setDescription(SpecialReviewTypeValuesFinderTest.RECOMBINANT_DNA_VALUE);
                specialReviewTypes.add(recombinantDNAType);
                ((KeyValuesService)this.allowing(service)).findAllOrderBy(SpecialReviewType.class, "sortId", true);
                this.will(2.returnValue(specialReviewTypes));
            }
        });
        return service;
    }

    private BusinessObjectService getMockBusinessObjectService() {
        final BusinessObjectService service = (BusinessObjectService)this.context.mock(BusinessObjectService.class);
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                HashMap<String, String> fieldValues = new HashMap<String, String>();
                fieldValues.put(SpecialReviewTypeValuesFinderTest.MODULE_CODE_NAME, "");
                ArrayList<SpecialReviewUsage> specialReviewUsages = new ArrayList<SpecialReviewUsage>();
                SpecialReviewUsage humanSubjectsUsage = new SpecialReviewUsage();
                humanSubjectsUsage.setSpecialReviewTypeCode(SpecialReviewTypeValuesFinderTest.HUMAN_SUBJECTS_KEY);
                humanSubjectsUsage.setGlobal(true);
                humanSubjectsUsage.setActive(true);
                specialReviewUsages.add(humanSubjectsUsage);
                SpecialReviewUsage animalUsageUsage = new SpecialReviewUsage();
                animalUsageUsage.setSpecialReviewTypeCode(SpecialReviewTypeValuesFinderTest.ANIMAL_USAGE_KEY);
                animalUsageUsage.setGlobal(false);
                animalUsageUsage.setActive(true);
                specialReviewUsages.add(animalUsageUsage);
                SpecialReviewUsage recombinantDNAUsage = new SpecialReviewUsage();
                recombinantDNAUsage.setSpecialReviewTypeCode(SpecialReviewTypeValuesFinderTest.RECOMBINANT_DNA_KEY);
                recombinantDNAUsage.setGlobal(false);
                recombinantDNAUsage.setActive(false);
                specialReviewUsages.add(recombinantDNAUsage);
                ((BusinessObjectService)this.allowing(service)).findMatching(SpecialReviewUsage.class, fieldValues);
                this.will(3.returnValue(specialReviewUsages));
            }
        });
        return service;
    }

    private PermissionService getMockPermissionService(final boolean canViewNonGlobalSpecialReviewTypes) {
        final PermissionService service = (PermissionService)this.context.mock(PermissionService.class);
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((PermissionService)this.allowing(service)).hasPermission(GlobalVariables.getUserSession().getPrincipalId(), "KC-SYS", SpecialReviewTypeValuesFinderTest.PERMISSION_NAME);
                this.will(4.returnValue((Object)canViewNonGlobalSpecialReviewTypes));
            }
        });
        return service;
    }
}

