/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.common.specialreview.rules;

import java.sql.Date;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import org.jmock.Expectations;
import org.jmock.Mockery;
import org.jmock.integration.junit4.JUnit4Mockery;
import org.jmock.internal.ExpectationBuilder;
import org.jmock.lib.legacy.ClassImposteriser;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kra.bo.SpecialReviewApprovalType;
import org.kuali.kra.bo.SpecialReviewType;
import org.kuali.kra.bo.ValidSpecialReviewApproval;
import org.kuali.kra.common.specialreview.bo.SpecialReview;
import org.kuali.kra.common.specialreview.bo.SpecialReviewExemption;
import org.kuali.kra.common.specialreview.rule.AddSpecialReviewRule;
import org.kuali.kra.common.specialreview.rule.event.AddSpecialReviewEvent;
import org.kuali.kra.irb.Protocol;
import org.kuali.kra.irb.ProtocolFinderDao;
import org.kuali.kra.irb.test.ProtocolFactory;
import org.kuali.kra.test.infrastructure.KcUnitTestBase;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.util.ErrorMessage;
import org.kuali.rice.krad.util.GlobalVariables;
import org.springframework.util.AutoPopulatingList;

public abstract class AddSpecialReviewRuleTestBase<T extends SpecialReview<? extends SpecialReviewExemption>>
extends KcUnitTestBase {
    private static final String SPECIAL_REVIEW_TYPE_CODE_ANIMAL_USAGE = "2";
    private static final String APPROVAL_TYPE_CODE_APPROVED = "2";
    private static final String APPROVAL_TYPE_CODE_EXEMPT = "4";
    private static final String EXEMPTION_TYPE_CODE_E1 = "1";
    private static final String EXEMPTION_TYPE_CODE_E2 = "2";
    private static final String SPECIAL_REVIEW_TYPE_CODE_FIELD = "specialReviewTypeCode";
    private static final String APPROVAL_TYPE_CODE_FIELD = "approvalTypeCode";
    private static final String PROTOCOL_NUMBER_FIELD = "protocolNumber";
    private static final String APPLICATION_DATE_FIELD = "applicationDate";
    private static final String APPROVAL_DATE_FIELD = "approvalDate";
    private static final String EXPIRATION_DATE_FIELD = "expirationDate";
    private static final String EXEMPTION_TYPE_CODE_FIELD = "exemptionTypeCodes";
    private static final String SPECIAL_REVIEW_TYPE_DESCRIPTION_ANIMAL_USAGE = "Animal Usage";
    private static final String APPROVAL_TYPE_DESCRIPTION_APPROVED = "Approved";
    private static final String APPROVAL_TYPE_DESCRIPTION_EXEMPT = "Exempt";
    private Mockery context;
    private AddSpecialReviewRule<T> rule;
    private DateFormat dateFormat;
    private Protocol protocol;

    public abstract Document getDocument() throws WorkflowException;

    public abstract T getSpecialReview();

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.context = new JUnit4Mockery(){
            {
                this.setImposteriser(ClassImposteriser.INSTANCE);
            }
        };
        this.rule = new AddSpecialReviewRule();
        this.dateFormat = DateFormat.getDateInstance();
        this.protocol = ProtocolFactory.createProtocolDocument().getProtocol();
    }

    @Override
    @After
    public void tearDown() throws Exception {
        super.tearDown();
        this.context = null;
        this.rule = null;
        this.dateFormat = null;
        this.protocol = null;
    }

    @Test
    public void testOK() throws Exception {
        Document document = this.getDocument();
        T newSpecialReview = this.getSpecialReview();
        newSpecialReview.setSpecialReviewTypeCode("2");
        newSpecialReview.setApprovalTypeCode("2");
        newSpecialReview.setProtocolNumber(this.protocol.getProtocolNumber());
        newSpecialReview.setApplicationDate(new Date(this.dateFormat.parse("Aug 1, 2007").getTime()));
        newSpecialReview.setApprovalDate(new Date(this.dateFormat.parse("Aug 21, 2007").getTime()));
        AddSpecialReviewEvent addSpecialReviewEvent = new AddSpecialReviewEvent(document, newSpecialReview, new ArrayList(), false);
        this.rule.setBusinessObjectService(this.getBusinessObjectService("2", "2", true, false, false, false));
        this.rule.setProtocolFinderDao(this.getProtocolFinderDao());
        AddSpecialReviewRuleTestBase.assertTrue((boolean)this.rule.processRules(addSpecialReviewEvent));
    }

    @Test
    public void testBlankSpecialReviewCode() throws Exception {
        Document document = this.getDocument();
        T newSpecialReview = this.getSpecialReview();
        newSpecialReview.setSpecialReviewTypeCode(null);
        newSpecialReview.setApprovalTypeCode("2");
        newSpecialReview.setProtocolNumber(this.protocol.getProtocolNumber());
        newSpecialReview.setApplicationDate(new Date(this.dateFormat.parse("Aug 1, 2007").getTime()));
        newSpecialReview.setApprovalDate(new Date(this.dateFormat.parse("Aug 21, 2007").getTime()));
        AddSpecialReviewEvent addSpecialReviewEvent = new AddSpecialReviewEvent(document, newSpecialReview, new ArrayList(), false);
        this.rule.setBusinessObjectService(this.getBusinessObjectService(null, "2", false, false, false, false));
        this.rule.setProtocolFinderDao(this.getProtocolFinderDao());
        AddSpecialReviewRuleTestBase.assertFalse((boolean)this.rule.processRules(addSpecialReviewEvent));
        this.assertError(SPECIAL_REVIEW_TYPE_CODE_FIELD, "error.required");
    }

    @Test
    public void testBlankApprovalTypeCode() throws Exception {
        Document document = this.getDocument();
        T newSpecialReview = this.getSpecialReview();
        newSpecialReview.setSpecialReviewTypeCode("2");
        newSpecialReview.setApprovalTypeCode(null);
        newSpecialReview.setProtocolNumber(this.protocol.getProtocolNumber());
        newSpecialReview.setApplicationDate(new Date(this.dateFormat.parse("Aug 1, 2007").getTime()));
        newSpecialReview.setApprovalDate(new Date(this.dateFormat.parse("Aug 21, 2007").getTime()));
        AddSpecialReviewEvent addSpecialReviewEvent = new AddSpecialReviewEvent(document, newSpecialReview, new ArrayList(), false);
        this.rule.setBusinessObjectService(this.getBusinessObjectService("2", null, false, false, false, false));
        this.rule.setProtocolFinderDao(this.getProtocolFinderDao());
        AddSpecialReviewRuleTestBase.assertFalse((boolean)this.rule.processRules(addSpecialReviewEvent));
        this.assertError(APPROVAL_TYPE_CODE_FIELD, "error.required");
    }

    @Test
    public void testProtocolWithBlankProtocolNumber() throws Exception {
        Document document = this.getDocument();
        T newSpecialReview = this.getSpecialReview();
        newSpecialReview.setSpecialReviewTypeCode("2");
        newSpecialReview.setApprovalTypeCode("2");
        newSpecialReview.setProtocolNumber(null);
        newSpecialReview.setApplicationDate(new Date(this.dateFormat.parse("Aug 1, 2007").getTime()));
        newSpecialReview.setApprovalDate(new Date(this.dateFormat.parse("Aug 21, 2007").getTime()));
        AddSpecialReviewEvent addSpecialReviewEvent = new AddSpecialReviewEvent(document, newSpecialReview, new ArrayList(), false);
        this.rule.setBusinessObjectService(this.getBusinessObjectService("2", "2", true, false, false, false));
        this.rule.setProtocolFinderDao(this.getProtocolFinderDao());
        AddSpecialReviewRuleTestBase.assertFalse((boolean)this.rule.processRules(addSpecialReviewEvent));
        this.assertError(PROTOCOL_NUMBER_FIELD, "error.special.review.required.for.valid");
    }

    @Test
    public void testApprovalWithBlankApplicationDate() throws Exception {
        Document document = this.getDocument();
        T newSpecialReview = this.getSpecialReview();
        newSpecialReview.setSpecialReviewTypeCode("2");
        newSpecialReview.setApprovalTypeCode("2");
        newSpecialReview.setProtocolNumber(this.protocol.getProtocolNumber());
        newSpecialReview.setApplicationDate(null);
        newSpecialReview.setApprovalDate(new Date(this.dateFormat.parse("Aug 21, 2007").getTime()));
        AddSpecialReviewEvent addSpecialReviewEvent = new AddSpecialReviewEvent(document, newSpecialReview, new ArrayList(), false);
        this.rule.setBusinessObjectService(this.getBusinessObjectService("2", "2", true, true, false, false));
        this.rule.setProtocolFinderDao(this.getProtocolFinderDao());
        AddSpecialReviewRuleTestBase.assertFalse((boolean)this.rule.processRules(addSpecialReviewEvent));
        this.assertError(APPLICATION_DATE_FIELD, "error.special.review.required.for.valid");
    }

    @Test
    public void testApprovalWithBlankApprovalDate() throws Exception {
        Document document = this.getDocument();
        T newSpecialReview = this.getSpecialReview();
        newSpecialReview.setSpecialReviewTypeCode("2");
        newSpecialReview.setApprovalTypeCode("2");
        newSpecialReview.setProtocolNumber(this.protocol.getProtocolNumber());
        newSpecialReview.setApplicationDate(new Date(this.dateFormat.parse("Aug 1, 2007").getTime()));
        newSpecialReview.setApprovalDate(null);
        AddSpecialReviewEvent addSpecialReviewEvent = new AddSpecialReviewEvent(document, newSpecialReview, new ArrayList(), false);
        this.rule.setBusinessObjectService(this.getBusinessObjectService("2", "2", true, false, true, false));
        this.rule.setProtocolFinderDao(this.getProtocolFinderDao());
        AddSpecialReviewRuleTestBase.assertFalse((boolean)this.rule.processRules(addSpecialReviewEvent));
        this.assertError(APPROVAL_DATE_FIELD, "error.special.review.required.for.valid");
    }

    @Test
    public void testExemptWithBlankExemptionCodes() throws Exception {
        Document document = this.getDocument();
        T newSpecialReview = this.getSpecialReview();
        newSpecialReview.setSpecialReviewTypeCode("2");
        newSpecialReview.setApprovalTypeCode(APPROVAL_TYPE_CODE_EXEMPT);
        newSpecialReview.setApplicationDate(new Date(this.dateFormat.parse("Aug 1, 2007").getTime()));
        newSpecialReview.setApprovalDate(new Date(this.dateFormat.parse("Aug 21, 2007").getTime()));
        newSpecialReview.setExemptionTypeCodes(new ArrayList());
        AddSpecialReviewEvent addSpecialReviewEvent = new AddSpecialReviewEvent(document, newSpecialReview, new ArrayList(), false);
        this.rule.setBusinessObjectService(this.getBusinessObjectService("2", APPROVAL_TYPE_CODE_EXEMPT, false, false, false, true));
        this.rule.setProtocolFinderDao(this.getProtocolFinderDao());
        AddSpecialReviewRuleTestBase.assertFalse((boolean)this.rule.processRules(addSpecialReviewEvent));
        this.assertError(EXEMPTION_TYPE_CODE_FIELD, "error.special.review.required.for.valid");
    }

    @Test
    public void testNotExemptWithExemptionCodes() throws Exception {
        Document document = this.getDocument();
        T newSpecialReview = this.getSpecialReview();
        newSpecialReview.setSpecialReviewTypeCode("2");
        newSpecialReview.setApprovalTypeCode("2");
        newSpecialReview.setProtocolNumber(this.protocol.getProtocolNumber());
        newSpecialReview.setApplicationDate(new Date(this.dateFormat.parse("Aug 1, 2007").getTime()));
        newSpecialReview.setApprovalDate(new Date(this.dateFormat.parse("Aug 21, 2007").getTime()));
        newSpecialReview.setExemptionTypeCodes(Arrays.asList(EXEMPTION_TYPE_CODE_E1, "2"));
        AddSpecialReviewEvent addSpecialReviewEvent = new AddSpecialReviewEvent(document, newSpecialReview, new ArrayList(), false);
        this.rule.setBusinessObjectService(this.getBusinessObjectService("2", "2", true, false, true, false));
        this.rule.setProtocolFinderDao(this.getProtocolFinderDao());
        AddSpecialReviewRuleTestBase.assertFalse((boolean)this.rule.processRules(addSpecialReviewEvent));
        this.assertError(EXEMPTION_TYPE_CODE_FIELD, "error.special.review.cannot.select.exemption.for.valid");
    }

    @Test
    public void testApprovalDateBeforeApplicationDate() throws Exception {
        Document document = this.getDocument();
        T newSpecialReview = this.getSpecialReview();
        newSpecialReview.setSpecialReviewTypeCode("2");
        newSpecialReview.setApprovalTypeCode("2");
        newSpecialReview.setProtocolNumber(this.protocol.getProtocolNumber());
        newSpecialReview.setApplicationDate(new Date(this.dateFormat.parse("Aug 1, 2008").getTime()));
        newSpecialReview.setApprovalDate(new Date(this.dateFormat.parse("Aug 21, 2007").getTime()));
        AddSpecialReviewEvent addProposalSpecialReviewEvent = new AddSpecialReviewEvent(document, newSpecialReview, new ArrayList(), false);
        this.rule.setBusinessObjectService(this.getBusinessObjectService("2", "2", true, false, false, false));
        this.rule.setProtocolFinderDao(this.getProtocolFinderDao());
        AddSpecialReviewRuleTestBase.assertFalse((boolean)this.rule.processRules(addProposalSpecialReviewEvent));
        this.assertError(APPROVAL_DATE_FIELD, "error.special.review.date.same.or.later");
    }

    @Test
    public void testExpirationDateBeforeApprovalDate() throws Exception {
        Document document = this.getDocument();
        T newSpecialReview = this.getSpecialReview();
        newSpecialReview.setSpecialReviewTypeCode("2");
        newSpecialReview.setApprovalTypeCode("2");
        newSpecialReview.setProtocolNumber(this.protocol.getProtocolNumber());
        newSpecialReview.setApprovalDate(new Date(this.dateFormat.parse("Aug 1, 2008").getTime()));
        newSpecialReview.setExpirationDate(new Date(this.dateFormat.parse("Aug 21, 2007").getTime()));
        AddSpecialReviewEvent addProposalSpecialReviewEvent = new AddSpecialReviewEvent(document, newSpecialReview, new ArrayList(), false);
        this.rule.setBusinessObjectService(this.getBusinessObjectService("2", "2", true, false, false, false));
        this.rule.setProtocolFinderDao(this.getProtocolFinderDao());
        AddSpecialReviewRuleTestBase.assertFalse((boolean)this.rule.processRules(addProposalSpecialReviewEvent));
        this.assertError(EXPIRATION_DATE_FIELD, "error.special.review.date.same.or.later");
    }

    @Test
    public void testApplicationDateBeforeExpirationDate() throws Exception {
        Document document = this.getDocument();
        T newSpecialReview = this.getSpecialReview();
        newSpecialReview.setSpecialReviewTypeCode("2");
        newSpecialReview.setApprovalTypeCode("2");
        newSpecialReview.setProtocolNumber(this.protocol.getProtocolNumber());
        newSpecialReview.setApplicationDate(new Date(this.dateFormat.parse("Aug 1, 2008").getTime()));
        newSpecialReview.setExpirationDate(new Date(this.dateFormat.parse("Aug 21, 2007").getTime()));
        AddSpecialReviewEvent addProposalSpecialReviewEvent = new AddSpecialReviewEvent(document, newSpecialReview, new ArrayList(), false);
        this.rule.setBusinessObjectService(this.getBusinessObjectService("2", "2", true, false, false, false));
        this.rule.setProtocolFinderDao(this.getProtocolFinderDao());
        AddSpecialReviewRuleTestBase.assertFalse((boolean)this.rule.processRules(addProposalSpecialReviewEvent));
        this.assertError(EXPIRATION_DATE_FIELD, "error.special.review.date.same.or.later");
    }

    protected BusinessObjectService getBusinessObjectService(final String specialReviewTypeCode, final String approvalTypeCode, final boolean protocolNumberFlag, final boolean applicationDateFlag, final boolean approvalDateFlag, final boolean exemptNumberFlag) {
        final BusinessObjectService service = (BusinessObjectService)this.context.mock(BusinessObjectService.class);
        final SpecialReviewType specialReviewType = (SpecialReviewType)this.context.mock(SpecialReviewType.class);
        final SpecialReviewApprovalType specialReviewApprovalType = (SpecialReviewApprovalType)this.context.mock(SpecialReviewApprovalType.class);
        final ValidSpecialReviewApproval approval = (ValidSpecialReviewApproval)this.context.mock(ValidSpecialReviewApproval.class);
        final HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put(SPECIAL_REVIEW_TYPE_CODE_FIELD, specialReviewTypeCode);
        fieldValues.put(APPROVAL_TYPE_CODE_FIELD, approvalTypeCode);
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((BusinessObjectService)this.allowing(service)).findMatching(ValidSpecialReviewApproval.class, fieldValues);
                this.will(2.returnValue(Collections.singletonList(approval)));
                ((ValidSpecialReviewApproval)this.allowing(approval)).getSpecialReviewType();
                this.will(2.returnValue((Object)specialReviewType));
                ((ValidSpecialReviewApproval)this.allowing(approval)).getSpecialReviewApprovalType();
                this.will(2.returnValue((Object)specialReviewApprovalType));
                ((ValidSpecialReviewApproval)this.allowing(approval)).isProtocolNumberFlag();
                this.will(2.returnValue((Object)protocolNumberFlag));
                ((ValidSpecialReviewApproval)this.allowing(approval)).isApplicationDateFlag();
                this.will(2.returnValue((Object)applicationDateFlag));
                ((ValidSpecialReviewApproval)this.allowing(approval)).isApprovalDateFlag();
                this.will(2.returnValue((Object)approvalDateFlag));
                ((ValidSpecialReviewApproval)this.allowing(approval)).isExemptNumberFlag();
                this.will(2.returnValue((Object)exemptNumberFlag));
                ((SpecialReviewType)this.allowing(specialReviewType)).getSpecialReviewTypeCode();
                this.will(2.returnValue((Object)specialReviewTypeCode));
                ((SpecialReviewType)this.allowing(specialReviewType)).getDescription();
                this.will(2.returnValue((Object)AddSpecialReviewRuleTestBase.SPECIAL_REVIEW_TYPE_DESCRIPTION_ANIMAL_USAGE));
                ((SpecialReviewApprovalType)this.allowing(specialReviewApprovalType)).getApprovalTypeCode();
                this.will(2.returnValue((Object)approvalTypeCode));
                ((SpecialReviewApprovalType)this.allowing(specialReviewApprovalType)).getDescription();
                this.will(2.returnValue((Object)this.getApprovalDescription(approvalTypeCode)));
            }

            private String getApprovalDescription(String approvalTypeCode2) {
                if ("2".equals(approvalTypeCode2)) {
                    return AddSpecialReviewRuleTestBase.APPROVAL_TYPE_DESCRIPTION_APPROVED;
                }
                if (AddSpecialReviewRuleTestBase.APPROVAL_TYPE_CODE_EXEMPT.equals(approvalTypeCode2)) {
                    return AddSpecialReviewRuleTestBase.APPROVAL_TYPE_DESCRIPTION_EXEMPT;
                }
                return "";
            }
        });
        return service;
    }

    protected ProtocolFinderDao getProtocolFinderDao() throws WorkflowException {
        final ProtocolFinderDao service = (ProtocolFinderDao)this.context.mock(ProtocolFinderDao.class);
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((ProtocolFinderDao)this.allowing(service)).findCurrentProtocolByNumber(AddSpecialReviewRuleTestBase.this.protocol.getProtocolNumber());
                this.will(3.returnValue((Object)AddSpecialReviewRuleTestBase.this.protocol));
            }
        });
        return service;
    }

    private void assertError(String propertyKey, String errorKey) {
        AutoPopulatingList errors = GlobalVariables.getMessageMap().getMessages(propertyKey);
        AddSpecialReviewRuleTestBase.assertNotNull((Object)errors);
        AddSpecialReviewRuleTestBase.assertTrue((errors.size() == 1 ? 1 : 0) != 0);
        ErrorMessage message = (ErrorMessage)errors.get(0);
        AddSpecialReviewRuleTestBase.assertNotNull((Object)message);
        AddSpecialReviewRuleTestBase.assertEquals((Object)errorKey, (Object)message.getErrorKey());
    }
}

