/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.costshare;

import org.junit.After;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.kuali.kra.costshare.CostShareService;
import org.kuali.kra.costshare.CostShareServiceImpl;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.test.infrastructure.KcUnitTestBase;
import org.kuali.rice.coreservice.framework.parameter.ParameterConstants;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;

@ParameterConstants.NAMESPACE(namespace="KC-GEN")
@ParameterConstants.COMPONENT(component="All")
public class CostShareServiceTest
extends KcUnitTestBase {
    private CostShareService costShareService;
    private CostShareServiceImpl costShareServiceImpl;
    private ParameterService ps;

    @Override
    @Before
    public void setUp() throws Exception {
        this.ps = (ParameterService)KraServiceLocator.getService(ParameterService.class);
        this.costShareService = (CostShareService)KraServiceLocator.getService(CostShareService.class);
        this.costShareServiceImpl = (CostShareServiceImpl)KraServiceLocator.getService(CostShareService.class);
    }

    @Override
    @After
    public void tearDown() throws Exception {
        this.costShareService = null;
        this.costShareServiceImpl = null;
        this.ps = null;
    }

    @Test
    public void testGetCostShareLabel() {
        String parameterForBackup = this.getParameterService().getParameterValueAsString(this.getClass(), "CostShareProjectPeriodNameLabel");
        this.updateParameterForTesting(this.getClass(), "CostShareProjectPeriodNameLabel", "Project Period");
        String result = this.costShareService.getCostShareLabel();
        CostShareServiceTest.assertEquals((Object)"Project Period", (Object)result);
        this.updateParameterForTesting(this.getClass(), "CostShareProjectPeriodNameLabel", parameterForBackup);
    }

    @Test
    public void testValidateProjectPeriodAsFiscalYear() {
        boolean result = this.costShareService.validateProjectPeriodAsFiscalYear();
        CostShareServiceTest.assertFalse((boolean)result);
    }

    @Test
    public void tesValidateProjectPeriodAsProjectPeriod() {
        boolean result = this.costShareService.validateProjectPeriodAsProjectPeriod();
        CostShareServiceTest.assertTrue((boolean)result);
    }

    @Ignore
    @Test
    public void testSwitchParmAndReTestValidations() {
        String fiscalYearParm = "FisCal Year";
        String parameterForBackup = this.costShareService.getCostShareLabel();
        this.updateParameterForTesting(this.getClass(), "CostShareProjectPeriodNameLabel", fiscalYearParm);
        String newParm = this.costShareService.getCostShareLabel();
        CostShareServiceTest.assertEquals((Object)fiscalYearParm, (Object)newParm);
        CostShareServiceTest.assertTrue((boolean)this.costShareService.validateProjectPeriodAsFiscalYear());
        CostShareServiceTest.assertFalse((boolean)this.costShareService.validateProjectPeriodAsProjectPeriod());
        String fooBar = "foo";
        this.updateParameterForTesting(this.getClass(), "CostShareProjectPeriodNameLabel", fooBar);
        newParm = this.costShareService.getCostShareLabel();
        CostShareServiceTest.assertEquals((Object)fooBar, (Object)newParm);
        CostShareServiceTest.assertFalse((boolean)this.costShareService.validateProjectPeriodAsFiscalYear());
        CostShareServiceTest.assertFalse((boolean)this.costShareService.validateProjectPeriodAsProjectPeriod());
        this.updateParameterForTesting(this.getClass(), "CostShareProjectPeriodNameLabel", parameterForBackup);
    }

    @Test
    public void testGetParameterService() {
        CostShareServiceTest.assertNotNull((Object)this.costShareServiceImpl.getParameterService());
    }
}

