/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.dao;

import java.sql.Date;
import java.util.ArrayList;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kra.committee.bo.Committee;
import org.kuali.kra.committee.bo.CommitteeMembership;
import org.kuali.kra.committee.document.CommitteeDocument;
import org.kuali.kra.committee.service.CommitteeMembershipService;
import org.kuali.kra.committee.service.CommitteeService;
import org.kuali.kra.committee.test.CommitteeFactory;
import org.kuali.kra.common.committee.bo.CommitteeBase;
import org.kuali.kra.common.committee.bo.CommitteeMembershipBase;
import org.kuali.kra.common.committee.bo.CommitteeMembershipRole;
import org.kuali.kra.dao.ResearchAreaReferencesDao;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.irb.Protocol;
import org.kuali.kra.irb.ResearchArea;
import org.kuali.kra.irb.protocol.research.ProtocolResearchAreaService;
import org.kuali.kra.irb.test.ProtocolFactory;
import org.kuali.kra.protocol.ProtocolBase;
import org.kuali.kra.test.infrastructure.KcUnitTestBase;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.krad.UserSession;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.util.GlobalVariables;

public class ResearchAreaReferencesDaoOjbTest
extends KcUnitTestBase {
    private BusinessObjectService businessObjectService;
    private CommitteeMembershipService committeeMembershipService;
    private CommitteeService committeeService;
    private ResearchAreaReferencesDao raDao;
    private ProtocolResearchAreaService protocolResearchAreaService;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        GlobalVariables.setUserSession((UserSession)new UserSession("quickstart"));
        this.businessObjectService = (BusinessObjectService)KraServiceLocator.getService(BusinessObjectService.class);
        this.committeeService = (CommitteeService)KraServiceLocator.getService(CommitteeService.class);
        this.protocolResearchAreaService = (ProtocolResearchAreaService)KraServiceLocator.getService(ProtocolResearchAreaService.class);
        this.committeeMembershipService = (CommitteeMembershipService)KraServiceLocator.getService(CommitteeMembershipService.class);
        this.raDao = (ResearchAreaReferencesDao)KraServiceLocator.getService(ResearchAreaReferencesDao.class);
    }

    @Override
    @After
    public void tearDown() throws Exception {
        GlobalVariables.setUserSession(null);
        super.tearDown();
    }

    private void createandSaveCommittee(String researchAreaCode) throws WorkflowException {
        ResearchArea researchArea = new ResearchArea(researchAreaCode, "000001", "Sample research area", true);
        this.businessObjectService.save((PersistableBusinessObject)researchArea);
        ArrayList<ResearchArea> researchAreas = new ArrayList<ResearchArea>();
        researchAreas.add(researchArea);
        CommitteeDocument committeeDocument = CommitteeFactory.createCommitteeDocument("444");
        Committee committee = (Committee)committeeDocument.getCommittee();
        this.committeeService.addResearchAreas((CommitteeBase)committee, researchAreas);
        this.businessObjectService.save((PersistableBusinessObject)committeeDocument);
        this.businessObjectService.save((PersistableBusinessObject)committee);
    }

    private void createandSaveCommitteeWithMembershipExpertise(String researchAreaCode) throws WorkflowException {
        ResearchArea researchArea = new ResearchArea(researchAreaCode, "000001", "Sample research area", true);
        this.businessObjectService.save((PersistableBusinessObject)researchArea);
        ArrayList<ResearchArea> researchAreas = new ArrayList<ResearchArea>();
        researchAreas.add(researchArea);
        CommitteeDocument committeeDocument = CommitteeFactory.createCommitteeDocument("555");
        Committee committee = (Committee)committeeDocument.getCommittee();
        CommitteeMembership committeeMembership = this.createMembership("jtester", "joe tester", null, "1", "2009-01-11", "2009-01-20");
        this.addRole(committeeMembership, "1", "2009-01-11", "2009-01-20");
        this.committeeMembershipService.addCommitteeMembershipExpertise((CommitteeMembershipBase)committeeMembership, researchAreas);
        this.committeeMembershipService.addCommitteeMembership((CommitteeBase)committee, (CommitteeMembershipBase)committeeMembership);
        this.businessObjectService.save((PersistableBusinessObject)committeeDocument);
        this.businessObjectService.save((PersistableBusinessObject)committee);
    }

    private void createAndSaveProtocol(String researchAreaCode) throws WorkflowException {
        ResearchArea researchArea = new ResearchArea(researchAreaCode, "000001", "Sample research area", true);
        this.businessObjectService.save((PersistableBusinessObject)researchArea);
        ArrayList<ResearchArea> researchAreas = new ArrayList<ResearchArea>();
        researchAreas.add(researchArea);
        String newProtocolNumber = "123456132";
        Protocol protocol = ProtocolFactory.createProtocolDocument(newProtocolNumber).getProtocol();
        this.protocolResearchAreaService.addProtocolResearchArea((ProtocolBase)protocol, researchAreas);
        this.businessObjectService.save((PersistableBusinessObject)protocol);
    }

    private CommitteeMembership createMembership(String personID, String name, Integer rolodexID, String membershipTypeCode, String termStartDate, String termEndDate) {
        CommitteeMembership committeeMembership = new CommitteeMembership();
        committeeMembership.setPersonId(personID);
        committeeMembership.setPersonName(name);
        committeeMembership.setRolodexId(rolodexID);
        committeeMembership.setMembershipTypeCode(membershipTypeCode);
        if (termStartDate != null) {
            committeeMembership.setTermStartDate(Date.valueOf(termStartDate));
        }
        if (termEndDate != null) {
            committeeMembership.setTermEndDate(Date.valueOf(termEndDate));
        }
        return committeeMembership;
    }

    private void addRole(CommitteeMembership committeeMembership, String membershipRoleCode, String startDate, String endDate) {
        CommitteeMembershipRole committeeMembershipRole = new CommitteeMembershipRole();
        committeeMembershipRole.setMembershipRoleCode(membershipRoleCode);
        if (startDate != null) {
            committeeMembershipRole.setStartDate(Date.valueOf(startDate));
        }
        if (endDate != null) {
            committeeMembershipRole.setEndDate(Date.valueOf(endDate));
        }
        committeeMembership.getMembershipRoles().add(committeeMembershipRole);
    }

    @Test
    public void testIsResearchAreaReferencedByAnyCommittee() throws Exception {
        ResearchAreaReferencesDaoOjbTest.assertFalse((boolean)this.raDao.isResearchAreaReferencedByAnyCommittee("RATEST"));
        this.createandSaveCommittee("RATEST");
        ResearchAreaReferencesDaoOjbTest.assertTrue((boolean)this.raDao.isResearchAreaReferencedByAnyCommittee("RATEST"));
        ResearchAreaReferencesDaoOjbTest.assertFalse((boolean)this.raDao.isResearchAreaReferencedByAnyCommittee("RANDOM"));
    }

    @Test
    public void testIsResearchAreaReferencedByAnyProtocol() throws Exception {
        ResearchAreaReferencesDaoOjbTest.assertFalse((boolean)this.raDao.isResearchAreaReferencedByAnyProtocol("RATEST1"));
        this.createAndSaveProtocol("RATEST1");
        ResearchAreaReferencesDaoOjbTest.assertTrue((boolean)this.raDao.isResearchAreaReferencedByAnyProtocol("RATEST1"));
        ResearchAreaReferencesDaoOjbTest.assertFalse((boolean)this.raDao.isResearchAreaReferencedByAnyProtocol("RANDOM"));
    }

    @Test
    public void testIsResearchAreaReferencedByAnyCommitteeMember() throws Exception {
        ResearchAreaReferencesDaoOjbTest.assertFalse((boolean)this.raDao.isResearchAreaReferencedByAnyCommitteeMember("RATEST2"));
        this.createandSaveCommitteeWithMembershipExpertise("RATEST2");
        ResearchAreaReferencesDaoOjbTest.assertTrue((boolean)this.raDao.isResearchAreaReferencedByAnyCommitteeMember("RATEST2"));
        ResearchAreaReferencesDaoOjbTest.assertFalse((boolean)this.raDao.isResearchAreaReferencedByAnyCommitteeMember("RANDOM"));
    }
}

