/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.dao;

import java.util.HashMap;
import org.apache.ojb.broker.query.Criteria;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kra.bo.NonOrganizationalRolodex;
import org.kuali.kra.dao.RolodexDao;
import org.kuali.kra.test.infrastructure.KcUnitTestBase;

public class RolodexDaoOjbTest
extends KcUnitTestBase {
    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
    }

    @Override
    @After
    public void tearDown() throws Exception {
        super.tearDown();
    }

    @Test
    public void getNonOrganizationalRolodexCriteriaWithNoName() {
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put("organization", "National*");
        Criteria criteria = this.getRolodexDao().getNonOrganizationalRolodexCriteria(NonOrganizationalRolodex.class, fieldValues, false);
        RolodexDaoOjbTest.assertFalse((-1 == criteria.toString().indexOf("LIKE NATIONAL%") ? 1 : 0) != 0);
        RolodexDaoOjbTest.assertFalse((-1 == criteria.toString().indexOf("firstName IS NOT NULL") ? 1 : 0) != 0);
        RolodexDaoOjbTest.assertFalse((-1 == criteria.toString().indexOf("lastName IS NOT NULL") ? 1 : 0) != 0);
        RolodexDaoOjbTest.assertFalse((-1 == criteria.toString().indexOf("active <> false") ? 1 : 0) != 0);
        RolodexDaoOjbTest.assertEquals((Object)criteria.toString(), (Object)"[UPPER(organization) LIKE NATIONAL%, firstName IS NOT NULL , lastName IS NOT NULL , active <> false]");
    }

    @Test(expected=IllegalArgumentException.class)
    public void getNonOrganizationalRolodexCriteriaNullClass() {
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put("organization", "National*");
        Criteria criteria = this.getRolodexDao().getNonOrganizationalRolodexCriteria(null, fieldValues, false);
    }

    @Test(expected=RuntimeException.class)
    public void getNonOrganizationalRolodexCriteriaPrimaryKeys() {
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put("organization", "National*");
        Criteria criteria = this.getRolodexDao().getNonOrganizationalRolodexCriteria(NonOrganizationalRolodex.class, fieldValues, true);
    }

    @Test
    public void getNonOrganizationalRolodexCriteriaWithFirstName() {
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put("organization", "National*");
        fieldValues.put("firstName", "David");
        Criteria criteria = this.getRolodexDao().getNonOrganizationalRolodexCriteria(NonOrganizationalRolodex.class, fieldValues, false);
        RolodexDaoOjbTest.assertNotNull((Object)criteria);
        RolodexDaoOjbTest.assertFalse((-1 == criteria.toString().indexOf("LIKE NATIONAL%") ? 1 : 0) != 0);
        RolodexDaoOjbTest.assertFalse((-1 == criteria.toString().indexOf("LIKE DAVID") ? 1 : 0) != 0);
        RolodexDaoOjbTest.assertFalse((-1 == criteria.toString().indexOf("firstName IS NOT NULL") ? 1 : 0) != 0);
        RolodexDaoOjbTest.assertFalse((-1 == criteria.toString().indexOf("lastName IS NOT NULL") ? 1 : 0) != 0);
    }

    private RolodexDao getRolodexDao() {
        return this.getService(RolodexDao.class);
    }
}

