/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.infrastructure;

import java.math.BigDecimal;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kra.budget.BudgetDecimal;
import org.kuali.kra.infrastructure.BudgetDecimalFormatter;
import org.kuali.rice.core.web.format.FormatException;

public class BudgetDecimalFormatterTest {
    private static final String ALPHA_NUMERIC_VALUE = "1000.ef";
    private static final String ALPHA_VALUE = "abcd.ef";
    private static final String TEST_NUMBER_AS_STRING = "987654321.09";
    private static final double TEST_NUMBER = 9.8765432109E8;
    private BudgetDecimalFormatter formatter;

    @Before
    public void setUp() {
        this.formatter = new BudgetDecimalFormatter();
    }

    @After
    public void tearDown() {
        this.formatter = null;
    }

    @Test
    public void testConvertingFromStringToBudgetDecimal_GoodData() {
        BudgetDecimal budgetDecimal = new BudgetDecimal(new BigDecimal(9.8765432109E8));
        Assert.assertEquals((Object)budgetDecimal, (Object)this.formatter.convertToObject(TEST_NUMBER_AS_STRING));
    }

    @Test(expected=FormatException.class)
    public void testConvertingFromStringToBudgetDecimal_AllBadData() {
        this.formatter.convertToObject(ALPHA_VALUE);
    }

    @Test(expected=FormatException.class)
    public void testConvertingFromStringToBudgetDecimal_MixedBadData() {
        this.formatter.convertToObject(ALPHA_NUMERIC_VALUE);
    }
}

