/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.infrastructure;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.proposaldevelopment.bo.MailType;
import org.kuali.kra.proposaldevelopment.document.ProposalDevelopmentDocument;
import org.kuali.kra.test.infrastructure.KcUnitTestBase;
import org.kuali.rice.core.api.criteria.Predicate;
import org.kuali.rice.core.api.criteria.PredicateFactory;
import org.kuali.rice.core.api.criteria.QueryByCriteria;
import org.kuali.rice.core.api.datetime.DateTimeService;
import org.kuali.rice.coreservice.api.CoreServiceApiServiceLocator;
import org.kuali.rice.coreservice.api.parameter.ParameterQueryResults;
import org.kuali.rice.coreservice.api.parameter.ParameterRepositoryService;
import org.kuali.rice.kns.service.DataDictionaryService;
import org.kuali.rice.krad.dao.BusinessObjectDao;

public class KraServiceLocatorTest
extends KcUnitTestBase {
    private ParameterRepositoryService parameterRepositoryService;

    @Before
    public void setUpServices() {
        this.parameterRepositoryService = CoreServiceApiServiceLocator.getParameterRepositoryService();
    }

    @Test
    public void testGetDataDictionaryService() throws Exception {
        DataDictionaryService dataDictionaryService = (DataDictionaryService)KraServiceLocator.getService((String)"dataDictionaryService");
        KraServiceLocatorTest.assertNotNull((Object)dataDictionaryService);
        KraServiceLocatorTest.assertEquals((Object)"ProposalDevelopmentDocument", (Object)dataDictionaryService.getDataDictionary().getDocumentEntry(ProposalDevelopmentDocument.class.getName()).getDocumentTypeName());
    }

    @Test
    public void testGetDateTimeService() throws Exception {
        DateTimeService dateTimeService = (DateTimeService)KraServiceLocator.getService((String)"dateTimeService");
        KraServiceLocatorTest.assertNotNull((Object)dateTimeService);
        Date currentDate = dateTimeService.getCurrentDate();
        Date currentDate2 = new Date(System.currentTimeMillis());
        long diff = currentDate.getTime() - currentDate2.getTime();
        KraServiceLocatorTest.assertTrue((String)"Should be less than one second difference between dates", (diff < 1000L ? 1 : 0) != 0);
    }

    @Test
    public void testBusinessObjectDaoService() throws Exception {
        BusinessObjectDao businessObjectDao = (BusinessObjectDao)KraServiceLocator.getService((String)"businessObjectDao");
        KraServiceLocatorTest.assertNotNull((Object)businessObjectDao);
        Collection carrierTypes = businessObjectDao.findAll(MailType.class);
        KraServiceLocatorTest.assertEquals((long)3L, (long)carrierTypes.size());
    }

    @Test
    public void testProposalDevelopmentParameters() throws Exception {
        QueryByCriteria.Builder queryBuilder = QueryByCriteria.Builder.create();
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        ParameterQueryResults parameterQueryResults = null;
        predicates.add(PredicateFactory.equal((String)"namespaceCode", (Object)"KC-PD"));
        predicates.add(PredicateFactory.equal((String)"componentCode", (Object)"Document"));
        queryBuilder.setPredicates(new Predicate[]{PredicateFactory.and((Predicate[])predicates.toArray(new Predicate[0]))});
        parameterQueryResults = this.parameterRepositoryService.findParameters(queryBuilder.build());
        KraServiceLocatorTest.assertNotNull((Object)parameterQueryResults);
        KraServiceLocatorTest.assertNotNull((Object)parameterQueryResults.getResults());
        KraServiceLocatorTest.assertTrue((parameterQueryResults.getResults().size() > 0 ? 1 : 0) != 0);
    }
}

