/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.infrastructure;

import java.math.BigDecimal;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kra.budget.RateDecimal;
import org.kuali.kra.infrastructure.RateDecimalFormatter;
import org.kuali.rice.core.web.format.FormatException;

public class RateDecimalFormatterTest {
    private static final String ALPHANUMERIC_VALUE = "98.efg";
    private static final String ALPHA_VALUE = "ab.cde";
    private static final String TEST_NUMBER_AS_STRING = "98.765";
    private static final double TEST_NUMBER = 98.765;
    private RateDecimalFormatter formatter;

    @Before
    public void setUp() {
        this.formatter = new RateDecimalFormatter();
    }

    @After
    public void tearDown() {
        this.formatter = null;
    }

    @Test
    public void testConvertingFromStringToRateDecimal_GoodData() {
        RateDecimal rateDecimal = new RateDecimal(new BigDecimal(98.765));
        Assert.assertEquals((Object)rateDecimal, (Object)this.formatter.convertToObject(TEST_NUMBER_AS_STRING));
    }

    @Test(expected=FormatException.class)
    public void testConvertingFromStringToBudgetDecimal_AllBadData() {
        this.formatter.convertToObject(ALPHA_VALUE);
    }

    @Test(expected=FormatException.class)
    public void testConvertingFromStringToBudgetDecimal_MixedBadData() {
        this.formatter.convertToObject(ALPHANUMERIC_VALUE);
    }
}

