/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.infrastructure;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.sql.DataSource;
import junit.framework.Assert;
import junit.framework.AssertionFailedError;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.SystemUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.kuali.kra.bo.CustomAttribute;
import org.kuali.kra.bo.CustomAttributeDocument;
import org.kuali.rice.kew.actionrequest.ActionRequestValue;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.kuali.rice.kew.api.WorkflowDocumentFactory;
import org.kuali.rice.kew.api.action.ActionItem;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.kew.engine.node.RouteNodeInstance;
import org.kuali.rice.kew.service.KEWServiceLocator;
import org.kuali.rice.kim.api.identity.Person;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.jdbc.core.ConnectionCallback;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.StatementCallback;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionTemplate;

public class TestUtilities {
    private static final Log LOG = LogFactory.getLog(TestUtilities.class);
    private static final String TEST_TABLE_NAME = "EN_UNITTEST_T";
    private static Thread exceptionThreader;
    private static List<String> BUS_TABLES;
    public static final String GROUP_NAME_1 = "asdf asdf asdf asdf asdf asdf asdf asdf asdf asdf asdf asdf asdf asdf asdf asdf asdf asdf asdf asdf asdf asdf asdf asdf asdf asdf asdf asdf asdf asdf asdf asdf asdf asdf asdf asdf asdf asdf asdf asdf asdf asdf asdf asdf asdf asdf asdf asdf asdf asdf";
    public static final String GROUP_NAME_2 = "Personnel Items for Review";
    public static final String GROUP_NAME_3 = "Project Details";
    public static final String BILLING_ELEMENT_VALUE = "This is billing element";
    public static final String GRADUATE_STUDENT_COUNT_VALUE = "5";
    public static final String LOCAL_REVIEW_DATE_VALUE = "02/08/2008";
    public static final String TENURED_VALUE = "tdurkin";
    private static final String DEFAULT_TEST_PLATFORM = "oracle";
    private static final String BUILD_PROPERTIES = "build.properties";
    private static final String TEST_PLATFORM = "test.platform";
    private static final String GROUP_NAME_4 = "Other";

    private TestUtilities() {
    }

    public static InputStream loadResource(Class packageClass, String resourceName) {
        return packageClass.getResourceAsStream(resourceName);
    }

    public static void verifyTestEnvironment(DataSource dataSource) {
        if (dataSource == null) {
            Assert.fail((String)"Could not locate the EDEN data source.");
        }
        JdbcTemplate template = new JdbcTemplate(dataSource);
        template.execute(new ConnectionCallback(){

            public Object doInConnection(Connection connection) throws SQLException {
                ResultSet resultSet = connection.getMetaData().getTables(null, null, TestUtilities.TEST_TABLE_NAME, null);
                if (!resultSet.next()) {
                    LOG.error((Object)"No table named 'EN_UNITTEST_T' was found in the configured database.  You are attempting to run tests against a non-test database!!!");
                    LOG.error((Object)"The test environment will not start up properly!!!");
                    Assert.fail((String)"No table named 'EN_UNITTEST_T' was found in the configured database.  You are attempting to run tests against a non-test database!!!");
                }
                return null;
            }
        });
    }

    public static void clearTables(PlatformTransactionManager transactionManager, final DataSource dataSource, final String edenSchemaName, final List<String> dontClear) {
        LOG.info((Object)("Clearing tables for schema " + edenSchemaName));
        if (dataSource == null) {
            Assert.fail((String)"Null data source given");
        }
        if (edenSchemaName == null || edenSchemaName.equals("")) {
            Assert.fail((String)"Empty eden schema name given");
        }
        new TransactionTemplate(transactionManager).execute(new TransactionCallback(){

            public Object doInTransaction(TransactionStatus status) {
                TestUtilities.verifyTestEnvironment(dataSource);
                JdbcTemplate template = new JdbcTemplate(dataSource);
                return template.execute(new StatementCallback(){

                    public Object doInStatement(Statement statement) throws SQLException {
                        ArrayList<String> reEnableConstraints = new ArrayList<String>();
                        ResultSet resultSet = statement.getConnection().getMetaData().getTables(null, edenSchemaName, null, new String[]{"TABLE"});
                        while (resultSet.next()) {
                            String tableName = resultSet.getString("TABLE_NAME");
                            if (!tableName.startsWith("EN_") || dontClear.contains(tableName)) continue;
                            ResultSet keyResultSet = statement.getConnection().getMetaData().getExportedKeys(null, edenSchemaName, tableName);
                            while (keyResultSet.next()) {
                                String fkName = keyResultSet.getString("FK_NAME");
                                String fkTableName = keyResultSet.getString("FKTABLE_NAME");
                                statement.addBatch("ALTER TABLE " + fkTableName + " DISABLE CONSTRAINT " + fkName);
                                reEnableConstraints.add("ALTER TABLE " + fkTableName + " ENABLE CONSTRAINT " + fkName);
                            }
                            keyResultSet.close();
                            statement.addBatch("DELETE FROM " + tableName.toUpperCase());
                        }
                        for (String constraint : reEnableConstraints) {
                            statement.addBatch(constraint);
                        }
                        statement.executeBatch();
                        resultSet.close();
                        return null;
                    }
                });
            }
        });
        LOG.info((Object)("Tables successfully cleared for schema " + edenSchemaName));
    }

    public static Set<String> createNodeInstanceNameSet(Collection nodeInstances) {
        HashSet<String> nameSet = new HashSet<String>();
        for (RouteNodeInstance nodeInstance : nodeInstances) {
            nameSet.add(nodeInstance.getName());
        }
        return nameSet;
    }

    public static void assertAtNode(String message, WorkflowDocument document, String nodeName) throws WorkflowException {
        Set nodeNames = document.getNodeNames();
        for (String docNodeName : nodeNames) {
            if (!docNodeName.equals(nodeName)) continue;
            return;
        }
        throw new AssertionFailedError((StringUtils.isEmpty((String)message) ? "" : message + ": ") + "Was [" + StringUtils.join((Collection)nodeNames, (String)", ") + "], Expected " + nodeName);
    }

    public static void assertAtNode(WorkflowDocument document, String nodeName) throws WorkflowException {
        TestUtilities.assertAtNode("", document, nodeName);
    }

    public static void assertInActionList(String principalName, Long documentId) {
        Person user = KEWServiceLocator.getIdentityHelperService().getPersonByPrincipalName(principalName);
        Assert.assertNotNull((String)("Given principalName was invalid: " + principalName), (Object)user);
        Collection actionList = KEWServiceLocator.getActionListService().findByPrincipalId(user.getPrincipalId());
        for (ActionItem actionItem : actionList) {
            if (!actionItem.getDocumentId().equals(documentId)) continue;
            return;
        }
        Assert.fail((String)"Could not locate an action item in the user's action list for the given document id.");
    }

    public static void assertNotInActionList(String principalName, Long documentId) {
        Person user = KEWServiceLocator.getIdentityHelperService().getPersonByPrincipalName(principalName);
        Assert.assertNotNull((String)("Given principalName was invalid: " + principalName), (Object)user);
        Collection actionList = KEWServiceLocator.getActionListService().findByPrincipalId(user.getPrincipalId());
        for (ActionItem actionItem : actionList) {
            if (!actionItem.getDocumentId().equals(documentId)) continue;
            Assert.fail((String)"Found an action item in the user's acton list for the given document id.");
        }
    }

    public static void assertNumberOfPendingRequests(String documentId, int numberOfPendingRequests) {
        List actionRequests = KEWServiceLocator.getActionRequestService().findPendingByDoc(documentId);
        Assert.assertEquals((String)("Wrong number of pending requests for document: " + documentId), (int)numberOfPendingRequests, (int)actionRequests.size());
    }

    public static void assertApprovals(String docId, String[] users, boolean shouldHaveApproval) throws WorkflowException {
        ArrayList<String> failedUsers = new ArrayList<String>();
        for (String user : users) {
            WorkflowDocument doc = WorkflowDocumentFactory.loadDocument((String)user, (String)docId);
            boolean appRqsted = doc.isApprovalRequested();
            if (shouldHaveApproval != appRqsted) {
                failedUsers.add(user);
            }
            LOG.info((Object)("User " + user + (appRqsted ? " HAS " : " HAS NO ") + "approval request"));
        }
        for (String user : failedUsers) {
            LOG.error((Object)("User " + user + (shouldHaveApproval ? " should have " : " should NOT have ") + " approval"));
        }
        if (failedUsers.size() > 0) {
            Assert.fail((String)"Outstanding approvals are incorrect");
        }
    }

    public static void logActionRequests(String docId) {
        List actionRequests = KEWServiceLocator.getActionRequestService().findAllActionRequestsByDocumentId(docId);
        LOG.info((Object)"Current action requests:");
        for (ActionRequestValue ar : actionRequests) {
            LOG.info((Object)ar);
        }
    }

    public static void waitForExceptionRouting() {
        TestUtilities.waitForExceptionRouting(300000L);
    }

    public static void waitForExceptionRouting(long milliseconds) {
        try {
            TestUtilities.getExceptionThreader().join(milliseconds);
        }
        catch (InterruptedException e) {
            Assert.fail((String)"This thread was interuppted while waiting for exception routing.");
        }
        if (TestUtilities.getExceptionThreader().isAlive()) {
            Assert.fail((String)("Document was not put into exception routing within the specified amount of time " + milliseconds));
        }
    }

    public static Thread getExceptionThreader() {
        return exceptionThreader;
    }

    public static void setExceptionThreader(Thread exceptionThreader) {
        TestUtilities.exceptionThreader = exceptionThreader;
    }

    public static String getTestPlatform() throws IOException {
        Properties properties;
        Properties properties2;
        File userBuildProperties = new File(SystemUtils.USER_HOME + "/" + BUILD_PROPERTIES);
        if (userBuildProperties.isFile() && (properties2 = TestUtilities.loadProperties(userBuildProperties)).containsKey(TEST_PLATFORM)) {
            return properties2.getProperty(TEST_PLATFORM).toLowerCase();
        }
        File localBuildProperties = new File(BUILD_PROPERTIES);
        if (localBuildProperties.isFile() && (properties = TestUtilities.loadProperties(localBuildProperties)).containsKey(TEST_PLATFORM)) {
            return properties.getProperty(TEST_PLATFORM).toLowerCase();
        }
        return DEFAULT_TEST_PLATFORM.toLowerCase();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties loadProperties(File file) throws IOException {
        Properties properties = new Properties();
        FileInputStream fis = new FileInputStream(file);
        try {
            properties.load(fis);
        }
        finally {
            fis.close();
        }
        return properties;
    }

    public static File createTempDir() throws Exception {
        File tmpFile = File.createTempFile("wfUnitTest", "");
        Assert.assertTrue((boolean)tmpFile.delete());
        File tmpDir = new File(new File(SystemUtils.JAVA_IO_TMPDIR), tmpFile.getName());
        Assert.assertTrue((boolean)tmpDir.mkdir());
        tmpDir.deleteOnExit();
        return tmpDir;
    }

    public static File getEnPluginsDirectory() {
        return new File("./work/unit-test/en-plugins");
    }

    public static File getPluginsDirectory() {
        return new File("./work/unit-test/plugins");
    }

    public static void initializePluginDirectories() throws Exception {
        File pluginDir;
        File enPluginDir = TestUtilities.getEnPluginsDirectory();
        if (enPluginDir.exists()) {
            FileUtils.forceDelete((File)enPluginDir);
        }
        if ((pluginDir = TestUtilities.getPluginsDirectory()).exists()) {
            FileUtils.forceDelete((File)pluginDir);
        }
        FileUtils.forceMkdir((File)enPluginDir);
        FileUtils.forceMkdir((File)pluginDir);
        FileUtils.forceDeleteOnExit((File)enPluginDir);
        FileUtils.forceDeleteOnExit((File)pluginDir);
    }

    public static void cleanupPluginDirectories() throws Exception {
        FileUtils.deleteDirectory((File)TestUtilities.getEnPluginsDirectory());
        FileUtils.deleteDirectory((File)TestUtilities.getPluginsDirectory());
    }

    public static <T extends Throwable> T findExceptionInStack(Throwable topLevelException, Class<T> exceptionClass) {
        for (Throwable t = topLevelException; t != null; t = t.getCause()) {
            if (!exceptionClass.isAssignableFrom(t.getClass())) continue;
            return (T)t;
        }
        return null;
    }

    public static Map<String, CustomAttributeDocument> setupTestCustomAttributeDocuments() {
        HashMap<String, CustomAttributeDocument> customAttributeDocuments = new HashMap<String, CustomAttributeDocument>();
        CustomAttribute customAttribute = TestUtilities.buildCustomAttribute(1, "billingElement", "Billing Element", "1", new Integer(40), GROUP_NAME_1);
        CustomAttributeDocument customAttributeDocument = TestUtilities.buildCustomAttributeDocument("PRDV", true, customAttribute);
        customAttributeDocuments.put("1", customAttributeDocument);
        customAttribute = TestUtilities.buildCustomAttribute(2, "costSharingBudget", "Cost Sharing Budget", "1", new Integer(30), GROUP_NAME_1);
        customAttributeDocument = TestUtilities.buildCustomAttributeDocument("PRDV", false, customAttribute);
        customAttributeDocuments.put("2", customAttributeDocument);
        customAttribute = TestUtilities.buildCustomAttribute(3, "numberOfTrainees", "# of Trainees", "2", new Integer(6), GROUP_NAME_1);
        customAttributeDocument = TestUtilities.buildCustomAttributeDocument("PRDV", false, customAttribute);
        customAttributeDocuments.put("3", customAttributeDocument);
        customAttribute = TestUtilities.buildCustomAttribute(4, "graduateStudentCount", "Graduate Student Count", "2", new Integer(6), GROUP_NAME_2);
        customAttributeDocument = TestUtilities.buildCustomAttributeDocument("PRDV", true, customAttribute);
        customAttributeDocuments.put("4", customAttributeDocument);
        customAttribute = TestUtilities.buildCustomAttribute(5, "tenured", "Tenured", "1", new Integer(30), GROUP_NAME_2, "org.kuali.kra.bo.KcPerson", "userName");
        customAttributeDocument = TestUtilities.buildCustomAttributeDocument("PRDV", false, customAttribute);
        customAttributeDocuments.put(GRADUATE_STUDENT_COUNT_VALUE, customAttributeDocument);
        customAttribute = TestUtilities.buildCustomAttribute(6, "exportControls", "Export Controls", "1", new Integer(30), GROUP_NAME_3);
        customAttributeDocument = TestUtilities.buildCustomAttributeDocument("PRDV", false, customAttribute);
        customAttributeDocuments.put("6", customAttributeDocument);
        customAttribute = TestUtilities.buildCustomAttribute(7, "inventions", "Inventions", "1", new Integer(30), GROUP_NAME_3, "org.kuali.kra.bo.KcPerson", "userName");
        customAttributeDocument = TestUtilities.buildCustomAttributeDocument("PRDV", false, customAttribute);
        customAttributeDocuments.put("7", customAttributeDocument);
        customAttribute = TestUtilities.buildCustomAttribute(8, "localReviewDate", "Local Review Date", "3", new Integer(10), GROUP_NAME_1);
        customAttributeDocument = TestUtilities.buildCustomAttributeDocument("PRDV", false, customAttribute);
        customAttributeDocuments.put("8", customAttributeDocument);
        customAttribute = TestUtilities.buildCustomAttribute(11, "ARRA_FUNDING", "ARRA Funding", "1", new Integer(3), GROUP_NAME_4, "org.kuali.kra.bo.ArgValueLookup", "yes_no_flag");
        customAttributeDocument = TestUtilities.buildCustomAttributeDocument("PRDV", false, customAttribute);
        customAttributeDocuments.put("9", customAttributeDocument);
        return customAttributeDocuments;
    }

    private static CustomAttributeDocument buildCustomAttributeDocument(String documentTypeCode, boolean required, CustomAttribute customAttribute) {
        CustomAttributeDocument customAttributeDocument = new CustomAttributeDocument();
        customAttributeDocument.setCustomAttributeId(customAttribute.getId());
        customAttributeDocument.setDocumentTypeName(documentTypeCode);
        customAttributeDocument.setRequired(required);
        customAttributeDocument.setCustomAttribute(customAttribute);
        return customAttributeDocument;
    }

    private static CustomAttribute buildCustomAttribute(Integer id, String name, String label, String dataTypeCode, Integer dataLength, String groupName) {
        return TestUtilities.buildCustomAttribute(id, name, label, dataTypeCode, dataLength, groupName, null, null);
    }

    private static CustomAttribute buildCustomAttribute(Integer id, String name, String label, String dataTypeCode, Integer dataLength, String groupName, String lookupClass, String lookupReturn) {
        CustomAttribute customAttribute = new CustomAttribute();
        customAttribute.setId(id);
        customAttribute.setName(name);
        customAttribute.setLabel(label);
        customAttribute.setDataTypeCode(dataTypeCode);
        customAttribute.setDataLength(dataLength);
        customAttribute.setGroupName(groupName);
        customAttribute.setLookupClass(lookupClass);
        customAttribute.setLookupReturn(lookupReturn);
        return customAttribute;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getContentsAsString(String fileLoc) throws Exception {
        DefaultResourceLoader resourceLoader = new DefaultResourceLoader();
        String data = "";
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new InputStreamReader(resourceLoader.getResource(fileLoc).getInputStream()));
            String line = "";
            while ((line = reader.readLine()) != null) {
                data = data + line + "\r\n ";
            }
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (Exception e) {
                    LOG.error((Object)e);
                }
            }
        }
        return data;
    }

    static {
        BUS_TABLES = new ArrayList<String>();
        BUS_TABLES.add("EN_SERVICE_DEF_T");
        BUS_TABLES.add("EN_SERVICE_DEF_DUEX_T");
        BUS_TABLES.add("EN_SERVICE_DEF_INTER_T");
        BUS_TABLES.add("EN_MESSAGE_QUE_T");
        BUS_TABLES.add("EN_BAM_T");
        BUS_TABLES.add("EN_BAM_PARAM_T");
    }
}

