/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.infrastructure;

import java.util.ArrayList;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kra.infrastructure.TimeFormatter;

public class TimeFormatterTest {
    private static final ArrayList<String> TIME_LIST = new ArrayList();
    private TimeFormatter formatter;
    private static String[][] valueChecks = new String[][]{{"11:59 AM", "11:59 AM"}, {"01:59 AM", "1:59 AM"}, {"1:59 AM", "1:59 AM"}, {"1AM", "1:00 AM"}, {"3:00", "3:00 AM"}, {"3", "3:00 AM"}, {"12:00", "12:00 PM"}, {"17:00", "5:00 PM"}, {"1730", "5:30 PM"}, {"0800", "8:00 AM"}, {"5P", "5:00 PM"}, {"6:00a", "6:00 AM"}, {"6:00AM", "6:00 AM"}, {"8.30", "8:30 AM"}, {"2 p.m.", "2:00 PM"}, {"00:00", "12:00 AM"}, {null, ""}, {"23:36 pm", "11:36 PM"}, {"23:36 aM", "11:36 PM"}, {"   ", ""}};

    @Before
    public void setUp() {
        this.formatter = new TimeFormatter();
        TIME_LIST.add("11:59 AM");
        TIME_LIST.add("1:00 AM");
        TIME_LIST.add("12:00 PM");
    }

    @After
    public void tearDown() {
        this.formatter = null;
        TIME_LIST.clear();
    }

    @Test
    public void testConvertToObject() {
        Assert.assertTrue((boolean)TIME_LIST.contains((String)this.formatter.convertToObject("1A")));
        Assert.assertTrue((boolean)TIME_LIST.contains((String)this.formatter.convertToObject("11:59")));
    }

    @Test
    public void testConvertToObject2() {
        for (String[] values : valueChecks) {
            String canonicalized = (String)this.formatter.convertToObject(values[0]);
            System.err.println("Original Value: '" + values[0] + "'  calculated value: '" + canonicalized + "'  expected value: '" + values[1] + "'");
            Assert.assertEquals((Object)values[1], (Object)canonicalized);
        }
    }
}

