/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.institutionalproposal.contacts;

import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kra.award.contacts.ContactRoleFixtureFactory;
import org.kuali.kra.bo.Unit;
import org.kuali.kra.institutionalproposal.contacts.InstitutionalProposalPerson;
import org.kuali.kra.institutionalproposal.contacts.InstitutionalProposalPersonUnit;

public class InstitutionalProposalPersonTest {
    private InstitutionalProposalPerson contact;
    private Unit unitA;
    private Unit unitB;

    @Before
    public void setUp() throws Exception {
        this.contact = new InstitutionalProposalPerson();
        this.unitA = new Unit();
        this.unitA.setUnitName("UnitA");
        this.unitB = new Unit();
        this.unitB.setUnitName("UnitB");
    }

    @After
    public void tearDown() throws Exception {
        this.contact = null;
        this.unitA = null;
        this.unitB = null;
    }

    @Test
    public void testAddingUnits() throws Exception {
        Assert.assertEquals((long)0L, (long)this.contact.getUnits().size());
        this.contact.add(new InstitutionalProposalPersonUnit(this.contact, this.unitA, InstitutionalProposalPersonUnit.IS_NOT_LEAD_UNIT));
        this.contact.add(new InstitutionalProposalPersonUnit(this.contact, this.unitB, InstitutionalProposalPersonUnit.IS_LEAD_UNIT));
        Assert.assertEquals((long)2L, (long)this.contact.getUnits().size());
    }

    @Test
    public void testFindingLeadUnit() throws Exception {
        this.contact.add(new InstitutionalProposalPersonUnit(this.contact, this.unitA, InstitutionalProposalPersonUnit.IS_NOT_LEAD_UNIT));
        this.contact.add(new InstitutionalProposalPersonUnit(this.contact, this.unitB, InstitutionalProposalPersonUnit.IS_LEAD_UNIT));
        Assert.assertEquals((Object)this.unitB.getUnitName(), (Object)this.contact.findLeadUnit().getUnitName());
    }

    @Test
    public void testFindingPrincipalInvestigator() {
        this.contact.setContactRole(ContactRoleFixtureFactory.MOCK_COI);
        Assert.assertFalse((String)"PI misidentified", (boolean)this.contact.isPrincipalInvestigator());
        this.contact.setContactRole(ContactRoleFixtureFactory.MOCK_PI);
        Assert.assertTrue((String)"PI not identified", (boolean)this.contact.isPrincipalInvestigator());
    }
}

