/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.institutionalproposal.contacts;

import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kra.award.contacts.ContactRoleFixtureFactory;
import org.kuali.kra.bo.KcPerson;
import org.kuali.kra.bo.KcPersonFixtureFactory;
import org.kuali.kra.bo.NonOrganizationalRolodex;
import org.kuali.kra.institutionalproposal.contacts.InstitutionalProposalPerson;
import org.kuali.kra.institutionalproposal.contacts.InstitutionalProposalProjectPersonAddRuleImpl;
import org.kuali.kra.institutionalproposal.home.InstitutionalProposal;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.krad.util.MessageMap;

public class InstitutionalProposalProjectPersonAddRuleImplTest {
    private static final int ROLODEX_ID = 1002;
    private InstitutionalProposal institutionalProposal;
    private InstitutionalProposalProjectPersonAddRuleImpl rule;
    private KcPerson person1;
    private static final String PERSON_ID = "1001";

    @Before
    public void setUp() {
        this.rule = new InstitutionalProposalProjectPersonAddRuleImpl();
        this.institutionalProposal = new InstitutionalProposal();
        this.person1 = KcPersonFixtureFactory.createKcPerson(PERSON_ID);
        NonOrganizationalRolodex person2 = new NonOrganizationalRolodex();
        person2.setRolodexId(Integer.valueOf(1002));
        this.institutionalProposal.add(new InstitutionalProposalPerson(this.person1, ContactRoleFixtureFactory.MOCK_PI));
        this.institutionalProposal.add(new InstitutionalProposalPerson(person2, ContactRoleFixtureFactory.MOCK_COI));
        GlobalVariables.setMessageMap((MessageMap)new MessageMap());
    }

    @After
    public void tearDown() {
        this.rule = null;
        this.institutionalProposal = null;
    }

    @Test
    public void testCheckForExistingPI_DuplicateFound() {
        InstitutionalProposalPerson newPerson = new InstitutionalProposalPerson(new KcPerson(), ContactRoleFixtureFactory.MOCK_PI);
        Assert.assertFalse((String)"Duplicate PI not identified", (boolean)this.rule.checkForExistingPrincipalInvestigators(this.institutionalProposal, newPerson));
    }

    @Test
    public void testCheckForExistingPI_NoDuplicateFound() {
        InstitutionalProposalPerson newPerson = new InstitutionalProposalPerson(new KcPerson(), ContactRoleFixtureFactory.MOCK_KEY_PERSON);
        Assert.assertTrue((String)"Duplicate PI misidentified", (boolean)this.rule.checkForExistingPrincipalInvestigators(this.institutionalProposal, newPerson));
    }

    @Test
    public void testCheckForDuplicateContact_DuplicatePersonFound() {
        KcPerson duplicatePerson = KcPersonFixtureFactory.createKcPerson(PERSON_ID);
        duplicatePerson.setPersonId(this.person1.getPersonId());
        InstitutionalProposalPerson newPerson = new InstitutionalProposalPerson(duplicatePerson, ContactRoleFixtureFactory.MOCK_COI);
        Assert.assertFalse((String)"Duplicate Person not identified", (boolean)this.rule.checkForDuplicatePerson(this.institutionalProposal, newPerson));
    }

    @Test
    public void testCheckForDuplicateContact_DuplicateRolodexFound() {
        NonOrganizationalRolodex duplicatePerson = new NonOrganizationalRolodex();
        duplicatePerson.setRolodexId(Integer.valueOf(1002));
        InstitutionalProposalPerson newPerson = new InstitutionalProposalPerson(duplicatePerson, ContactRoleFixtureFactory.MOCK_COI);
        Assert.assertFalse((String)"Duplicate Rolodex not identified", (boolean)this.rule.checkForDuplicatePerson(this.institutionalProposal, newPerson));
    }
}

