/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.institutionalproposal.contacts;

import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kra.award.contacts.ContactRoleFixtureFactory;
import org.kuali.kra.bo.KcPerson;
import org.kuali.kra.bo.NonOrganizationalRolodex;
import org.kuali.kra.bo.Unit;
import org.kuali.kra.institutionalproposal.contacts.InstitutionalProposalPerson;
import org.kuali.kra.institutionalproposal.contacts.InstitutionalProposalPersonAuditRule;
import org.kuali.kra.institutionalproposal.home.InstitutionalProposal;
import org.kuali.kra.test.infrastructure.KcUnitTestBase;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.krad.util.MessageMap;

public class InstitutionalProposalProjectPersonsAuditRuleTest
extends KcUnitTestBase {
    private static final String MISSING_UNIT_DETAILS_NOT_IDENTIFIED = "Missing unit Details not identified";
    private static final int ROLODEX_ID = 1002;
    private InstitutionalProposal institutionalProposal;
    private InstitutionalProposalPersonAuditRule rule;
    private KcPerson person1;
    private NonOrganizationalRolodex person2;
    private Unit unitA;
    private Unit unitB;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.rule = new InstitutionalProposalPersonAuditRule();
        this.institutionalProposal = new InstitutionalProposal();
        this.person1 = new KcPerson();
        this.person1.setPersonId("1001");
        this.person2 = new NonOrganizationalRolodex();
        this.person2.setRolodexId(Integer.valueOf(1002));
        this.institutionalProposal.add(new InstitutionalProposalPerson(this.person1, ContactRoleFixtureFactory.MOCK_PI));
        this.institutionalProposal.add(new InstitutionalProposalPerson(this.person2, ContactRoleFixtureFactory.MOCK_COI));
        this.unitA = new Unit();
        this.unitA.setUnitName("a");
        this.unitA.setUnitNumber("1");
        this.unitB = new Unit();
        this.unitB.setUnitName("b");
        this.unitB.setUnitNumber("2");
        GlobalVariables.setMessageMap((MessageMap)new MessageMap());
    }

    @Override
    @After
    public void tearDown() throws Exception {
        super.tearDown();
        this.rule = null;
        this.institutionalProposal = null;
    }

    @Test
    public void testCheckForExistingPI_DuplicateFound() {
        InstitutionalProposalPerson newPerson = new InstitutionalProposalPerson(new KcPerson(), ContactRoleFixtureFactory.MOCK_PI);
        this.institutionalProposal.add(newPerson);
        Assert.assertFalse((String)"Duplicate PI not identified", (boolean)this.rule.checkPrincipalInvestigators(this.institutionalProposal.getProjectPersons()));
    }

    @Test
    public void testCheckForExistingPI_NoDuplicateFound() {
        InstitutionalProposalPerson newPerson = new InstitutionalProposalPerson(new KcPerson(), ContactRoleFixtureFactory.MOCK_KEY_PERSON);
        this.institutionalProposal.add(newPerson);
        Assert.assertTrue((String)"Duplicate PI misidentified", (boolean)this.rule.checkPrincipalInvestigators(this.institutionalProposal.getProjectPersons()));
    }

    @Test
    public void testCheckForUnitDetails_RequiredForPI() {
        ((InstitutionalProposalPerson)this.institutionalProposal.getProjectPersons().get(1)).setContactRole(ContactRoleFixtureFactory.MOCK_KEY_PERSON);
        Assert.assertFalse((String)MISSING_UNIT_DETAILS_NOT_IDENTIFIED, (boolean)this.rule.checkUnits(this.institutionalProposal.getProjectPersons()));
    }

    @Test
    public void testCheckForUnitDetails_RequiredForCoI() {
        ((InstitutionalProposalPerson)this.institutionalProposal.getProjectPersons().get(0)).setContactRole(ContactRoleFixtureFactory.MOCK_KEY_PERSON);
        Assert.assertFalse((String)MISSING_UNIT_DETAILS_NOT_IDENTIFIED, (boolean)this.rule.checkUnits(this.institutionalProposal.getProjectPersons()));
    }

    @Test
    public void testCheckForUnitDetails_NotRequiredForKeyPerson() {
        ((InstitutionalProposalPerson)this.institutionalProposal.getProjectPersons().get(0)).setContactRole(ContactRoleFixtureFactory.MOCK_KEY_PERSON);
        ((InstitutionalProposalPerson)this.institutionalProposal.getProjectPersons().get(1)).setContactRole(ContactRoleFixtureFactory.MOCK_KEY_PERSON);
        Assert.assertTrue((String)"Unit details are not required for key person", (boolean)this.rule.checkLeadUnits(this.institutionalProposal.getProjectPersons()));
    }
}

