/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.institutionalproposal.contacts;

import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kra.award.contacts.ContactRoleFixtureFactory;
import org.kuali.kra.bo.KcPerson;
import org.kuali.kra.bo.KcPersonFixtureFactory;
import org.kuali.kra.bo.NonOrganizationalRolodex;
import org.kuali.kra.bo.Unit;
import org.kuali.kra.institutionalproposal.contacts.InstitutionalProposalPerson;
import org.kuali.kra.institutionalproposal.contacts.InstitutionalProposalPersonSaveRuleImpl;
import org.kuali.kra.institutionalproposal.contacts.InstitutionalProposalPersonUnit;
import org.kuali.kra.institutionalproposal.home.InstitutionalProposal;
import org.kuali.rice.krad.util.ErrorMessage;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.krad.util.MessageMap;
import org.springframework.util.AutoPopulatingList;

public class InstitutionalProposalProjectPersonsSaveRuleImplTest {
    private static final String MISSING_UNIT_DETAILS_NOT_IDENTIFIED = "Missing unit Details not identified";
    private static final int ROLODEX_ID = 1002;
    private InstitutionalProposal institutionalProposal;
    private InstitutionalProposalPersonSaveRuleImpl rule;
    private Unit unitA;
    private Unit unitB;
    private static final String PERSON_ID = "1001";
    private static final String KP_PERSON_ID = "1002";
    private InstitutionalProposalPerson piPerson;
    private InstitutionalProposalPerson coiPerson;
    private InstitutionalProposalPerson kpPerson;

    @Before
    public void setUp() {
        this.rule = new InstitutionalProposalPersonSaveRuleImpl();
        this.institutionalProposal = new InstitutionalProposal();
        this.unitA = new Unit();
        this.unitA.setUnitName("a");
        this.unitA.setUnitNumber("1");
        this.unitB = new Unit();
        this.unitB.setUnitName("b");
        this.unitB.setUnitNumber("2");
        KcPerson employee = KcPersonFixtureFactory.createKcPerson(PERSON_ID);
        this.piPerson = new InstitutionalProposalPerson(employee, ContactRoleFixtureFactory.MOCK_PI);
        this.piPerson.add(new InstitutionalProposalPersonUnit(this.piPerson, this.unitA, true));
        NonOrganizationalRolodex nonEmployee = new NonOrganizationalRolodex();
        nonEmployee.setRolodexId(Integer.valueOf(1002));
        this.coiPerson = new InstitutionalProposalPerson(nonEmployee, ContactRoleFixtureFactory.MOCK_COI);
        this.coiPerson.add(new InstitutionalProposalPersonUnit(this.coiPerson, this.unitA, false));
        KcPerson employee2 = KcPersonFixtureFactory.createKcPerson(KP_PERSON_ID);
        this.kpPerson = new InstitutionalProposalPerson(employee2, ContactRoleFixtureFactory.MOCK_KEY_PERSON);
        this.kpPerson.setKeyPersonRole("Tester");
        this.kpPerson.add(new InstitutionalProposalPersonUnit(this.kpPerson, this.unitA, false));
        this.institutionalProposal.add(this.piPerson);
        this.institutionalProposal.add(this.coiPerson);
        this.institutionalProposal.add(this.kpPerson);
        GlobalVariables.setMessageMap((MessageMap)new MessageMap());
    }

    @After
    public void tearDown() {
        this.rule = null;
        this.institutionalProposal = null;
    }

    @Test
    public void testCheckForExistingPI() {
        Assert.assertTrue((String)"PI not found or more than one found", (boolean)this.rule.checkForOnePrincipalInvestigator(this.institutionalProposal.getProjectPersons()));
        this.institutionalProposal.getProjectPersons().remove(0);
        Assert.assertFalse((String)"PI existence check failed", (boolean)this.rule.checkForOnePrincipalInvestigator(this.institutionalProposal.getProjectPersons()));
        this.checkErrorState("projectPersons", "error.awardProjectPerson.no.pi.exists");
    }

    @Test
    public void testCheckForMultiplePIs() {
        InstitutionalProposalPerson newPerson = new InstitutionalProposalPerson(KcPersonFixtureFactory.createKcPerson(KP_PERSON_ID), ContactRoleFixtureFactory.MOCK_PI);
        this.institutionalProposal.add(newPerson);
        Assert.assertFalse((String)"Multiple PIs not detected", (boolean)this.rule.checkForOnePrincipalInvestigator(this.institutionalProposal.getProjectPersons()));
        this.checkErrorState("projectPersons", "error.awardProjectPerson.pi.exists");
    }

    @Test
    public void testCheckForRequiredUnitDetails_PI() {
        Assert.assertTrue((String)MISSING_UNIT_DETAILS_NOT_IDENTIFIED, (boolean)this.rule.checkForRequiredUnitDetails(this.institutionalProposal.getProjectPersons()));
        this.piPerson.getUnits().clear();
        Assert.assertFalse((String)MISSING_UNIT_DETAILS_NOT_IDENTIFIED, (boolean)this.rule.checkForRequiredUnitDetails(this.institutionalProposal.getProjectPersons()));
        this.checkErrorState("projectPersons", "error.awardProjectPerson.unit.details.required");
    }

    @Test
    public void testCheckForRequiredUnitDetails_COI() {
        Assert.assertTrue((String)MISSING_UNIT_DETAILS_NOT_IDENTIFIED, (boolean)this.rule.checkForRequiredUnitDetails(this.institutionalProposal.getProjectPersons()));
        this.coiPerson.getUnits().clear();
        Assert.assertFalse((String)MISSING_UNIT_DETAILS_NOT_IDENTIFIED, (boolean)this.rule.checkForRequiredUnitDetails(this.institutionalProposal.getProjectPersons()));
        this.checkErrorState("projectPersons", "error.awardProjectPerson.unit.details.required");
    }

    @Test
    public void testCheckForUnitDetailsNotRequired_KP() {
        Assert.assertTrue((String)MISSING_UNIT_DETAILS_NOT_IDENTIFIED, (boolean)this.rule.checkForRequiredUnitDetails(this.institutionalProposal.getProjectPersons()));
        this.kpPerson.getUnits().clear();
        Assert.assertTrue((String)MISSING_UNIT_DETAILS_NOT_IDENTIFIED, (boolean)this.rule.checkForRequiredUnitDetails(this.institutionalProposal.getProjectPersons()));
        Assert.assertEquals((long)0L, (long)GlobalVariables.getMessageMap().getErrorCount());
    }

    @Test
    public void testCheckForDuplicateUnits_NoneFound() {
        this.piPerson.add(new InstitutionalProposalPersonUnit(this.piPerson, this.unitB, false));
        Assert.assertTrue((boolean)this.rule.checkForDuplicateUnits(this.institutionalProposal.getProjectPersons()));
    }

    @Test
    public void testCheckForDuplicateUnits_DupeFound() {
        this.piPerson.add(new InstitutionalProposalPersonUnit(this.piPerson, this.unitA, false));
        Assert.assertFalse((String)"Duplicate should have been found", (boolean)this.rule.checkForDuplicateUnits(this.institutionalProposal.getProjectPersons()));
        this.checkErrorState("projectPersons", "error.awardProjectPerson.duplicate.units");
    }

    @Test
    public void testCheckForLeadUnit_NoneFound() {
        Assert.assertTrue((String)"No lead unit was found", (boolean)this.rule.checkForLeadUnitForPI(this.institutionalProposal.getProjectPersons()));
        this.piPerson.getUnit(0).setLeadUnit(false);
        Assert.assertFalse((String)"No lead unit should have been found", (boolean)this.rule.checkForLeadUnitForPI(this.institutionalProposal.getProjectPersons()));
        this.checkErrorState("projectPersons", "error.awardProjectPerson.lead.unit.required");
    }

    @Test
    public void testCheckForKeyPersonRole_NotFound() {
        this.kpPerson.setKeyPersonRole(null);
        Assert.assertFalse((String)"Key Person Role not checked for", (boolean)this.rule.checkForKeyPersonProjectRoles(this.institutionalProposal.getProjectPersons()));
        this.checkErrorState("projectPersons[" + this.institutionalProposal.getProjectPersons().indexOf(this.kpPerson) + "].keyPersonRole", "error.awardProjectPerson.keyperson.role.required");
    }

    @Test
    public void testCheckForKeyPersonRole_Found() {
        Assert.assertTrue((String)"Key Person Role not checked for", (boolean)this.rule.checkForKeyPersonProjectRoles(this.institutionalProposal.getProjectPersons()));
    }

    private void checkErrorState(String errorProperty, String errorMessageKey) {
        MessageMap messageMap = GlobalVariables.getMessageMap();
        Assert.assertEquals((long)1L, (long)messageMap.getErrorCount());
        AutoPopulatingList errors = messageMap.getErrorMessagesForProperty(errorProperty);
        if (errors != null) {
            Assert.assertEquals((long)1L, (long)errors.size());
            Assert.assertEquals((Object)errorMessageKey, (Object)((ErrorMessage)errors.get(0)).getErrorKey());
        } else {
            Assert.fail((String)"No errors posted");
        }
        Assert.assertFalse((String)"rule should return false", (boolean)this.rule.processSaveInstitutionalProposalProjectPersonsBusinessRules(this.institutionalProposal.getProjectPersons()));
    }
}

