/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.institutionalproposal.rules;

import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.kuali.kra.costshare.CostShareService;
import org.kuali.kra.costshare.CostShareServiceTest;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.institutionalproposal.document.InstitutionalProposalDocument;
import org.kuali.kra.institutionalproposal.home.InstitutionalProposalCostShare;
import org.kuali.kra.institutionalproposal.rules.InstitutionalProposalAddCostShareRuleEvent;
import org.kuali.kra.institutionalproposal.rules.InstitutionalProposalAddCostShareRuleImpl;
import org.kuali.kra.test.infrastructure.KcUnitTestBase;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.krad.util.MessageMap;

public class InstitutionalProposalCostShareRuleTest
extends KcUnitTestBase {
    private static final String TEST_SOURCE = "54321";
    private static final String TEST_FISCAL_YEAR = "2008";
    private static final String TEST_INVALID_FISCAL_YEAR = "1500";
    private static final Integer PERCENTAGE = 50;
    private static final Integer AMOUNT = 10000;
    InstitutionalProposalAddCostShareRuleImpl institutionalProposalAddCostShareRule;
    InstitutionalProposalCostShare institutionalProposalCostShare;
    InstitutionalProposalDocument institutionalProposalDocument;
    InstitutionalProposalAddCostShareRuleEvent institutionalProposalCostShareRuleEvent;

    @Override
    @Before
    public void setUp() throws Exception {
        this.institutionalProposalAddCostShareRule = new InstitutionalProposalAddCostShareRuleImpl();
        this.institutionalProposalCostShare = new InstitutionalProposalCostShare();
        this.institutionalProposalCostShare.setCostSharePercentage(new KualiDecimal(PERCENTAGE.intValue()));
        this.institutionalProposalCostShare.setProjectPeriod(TEST_FISCAL_YEAR);
        this.institutionalProposalCostShare.setSourceAccount(TEST_SOURCE);
        this.institutionalProposalCostShare.setAmount(new KualiDecimal(AMOUNT.intValue()));
        GlobalVariables.setMessageMap((MessageMap)new MessageMap());
    }

    @Override
    @After
    public void tearDown() throws Exception {
        this.institutionalProposalAddCostShareRule = null;
        this.institutionalProposalCostShare = null;
    }

    @Test
    public final void testProcessCommonValidations() {
        Assert.assertTrue((boolean)this.institutionalProposalAddCostShareRule.processCommonValidations(this.institutionalProposalCostShare));
    }

    @Ignore
    @Test
    public final void testValidateCostShareFiscalYearRange() {
        this.updateParameterForTesting(CostShareServiceTest.class, "CostShareProjectPeriodNameLabel", "Fiscal Year");
        CostShareService costShareService = (CostShareService)KraServiceLocator.getService(CostShareService.class);
        costShareService.getCostShareLabel();
        this.institutionalProposalAddCostShareRule.setCostShareService(costShareService);
        Assert.assertTrue((boolean)this.institutionalProposalAddCostShareRule.validateCostShareFiscalYearRange(this.institutionalProposalCostShare));
        this.institutionalProposalCostShare.setProjectPeriod(TEST_INVALID_FISCAL_YEAR);
        Assert.assertFalse((boolean)this.institutionalProposalAddCostShareRule.validateCostShareFiscalYearRange(this.institutionalProposalCostShare));
        this.institutionalProposalCostShare.setSourceAccount(TEST_FISCAL_YEAR);
    }
}

