/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.institutionalproposal.rules;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.jmock.Expectations;
import org.jmock.Mockery;
import org.jmock.integration.junit4.JMock;
import org.jmock.integration.junit4.JUnit4Mockery;
import org.jmock.internal.ExpectationBuilder;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kuali.kra.institutionalproposal.IndirectcostRateType;
import org.kuali.kra.institutionalproposal.document.InstitutionalProposalDocument;
import org.kuali.kra.institutionalproposal.home.InstitutionalProposalUnrecoveredFandA;
import org.kuali.kra.institutionalproposal.rules.InstitutionalProposalUnrecoveredFandARuleImpl;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.krad.util.MessageMap;

@RunWith(value=JMock.class)
public class InstitutionalProposalUnrecoveredFanARuleTest {
    final Map<String, Object> queryMap = new HashMap<String, Object>();
    private Mockery context = new JUnit4Mockery();
    private static final String TEST_SOURCE = "54321";
    private static final String TEST_FISCAL_YEAR = "2008";
    private static final String TEST_INVALID_FISCAL_YEAR = "1000";
    private static final Integer PERCENTAGE = 50;
    private static final Integer AMOUNT = 10000;
    private static final Integer RATE_TYPE_CODE = 1;
    InstitutionalProposalUnrecoveredFandARuleImpl institutionalProposalUnrecoveredFandARuleImpl;
    InstitutionalProposalUnrecoveredFandA institutionalProposalUnrecoveredFandA;
    InstitutionalProposalDocument institutionalProposalDocument;

    @Before
    public void setUp() throws Exception {
        this.institutionalProposalUnrecoveredFandARuleImpl = new InstitutionalProposalUnrecoveredFandARuleImpl();
        this.institutionalProposalUnrecoveredFandA = new InstitutionalProposalUnrecoveredFandA();
        this.institutionalProposalUnrecoveredFandA.setApplicableIndirectcostRate(new KualiDecimal(PERCENTAGE.intValue()));
        this.institutionalProposalUnrecoveredFandA.setFiscalYear(TEST_FISCAL_YEAR);
        this.institutionalProposalUnrecoveredFandA.setSourceAccount(TEST_SOURCE);
        this.institutionalProposalUnrecoveredFandA.setUnderrecoveryOfIndirectcost(new KualiDecimal(AMOUNT.intValue()));
        this.institutionalProposalUnrecoveredFandA.setIndirectcostRateTypeCode(RATE_TYPE_CODE);
        this.queryMap.put("indirectcostRateTypeCode", 1);
        GlobalVariables.setMessageMap((MessageMap)new MessageMap());
    }

    @After
    public void tearDown() throws Exception {
        this.institutionalProposalUnrecoveredFandARuleImpl = null;
        this.institutionalProposalUnrecoveredFandA = null;
    }

    @Test
    public final void testProcessCommonValidations() {
        final BusinessObjectService MOCKED_BUSINESS_OBJECT_SERVICE = (BusinessObjectService)this.context.mock(BusinessObjectService.class);
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((BusinessObjectService)this.one(MOCKED_BUSINESS_OBJECT_SERVICE)).countMatching(IndirectcostRateType.class, InstitutionalProposalUnrecoveredFanARuleTest.this.queryMap);
                this.will(1.returnValue((Object)1));
            }
        });
        this.institutionalProposalUnrecoveredFandARuleImpl.setBusinessObjectService(MOCKED_BUSINESS_OBJECT_SERVICE);
        Assert.assertTrue((boolean)this.institutionalProposalUnrecoveredFandARuleImpl.processCommonValidations(this.institutionalProposalUnrecoveredFandA, new ArrayList()));
    }

    @Test
    public final void testValidateCostShareFiscalYearRange() {
        Assert.assertTrue((boolean)this.institutionalProposalUnrecoveredFandARuleImpl.validateUnrecoveredFandAFiscalYearRange(this.institutionalProposalUnrecoveredFandA));
        this.institutionalProposalUnrecoveredFandA.setFiscalYear(TEST_INVALID_FISCAL_YEAR);
        Assert.assertFalse((boolean)this.institutionalProposalUnrecoveredFandARuleImpl.validateUnrecoveredFandAFiscalYearRange(this.institutionalProposalUnrecoveredFandA));
        this.institutionalProposalUnrecoveredFandA.setSourceAccount(TEST_FISCAL_YEAR);
    }
}

