/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.institutionalproposal.web;

import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kra.institutionalproposal.web.InstitutionalProposalSeleniumHelper;
import org.kuali.kra.test.infrastructure.KcSeleniumTestBase;

public class InstitutionalProposalContactsSeleniumTest
extends KcSeleniumTestBase {
    private static final String PROJECT_PERSONNEL_TAG_ID = "ProjectPersonnel";
    private static final String BEAN_PREFIX = "projectPersonnelBean.";
    private static final String PERSON_ID_TAG = "projectPersonnelBean.personId";
    private static final String ROLODEX_ID_TAG = "projectPersonnelBean.rolodexId";
    private static final String PERSON_ID_ID = "personId";
    private static final String ROLODEX_ID_ID = "rolodexId";
    private static final String CONTACT_ROLE_CODE_ID = "projectPersonnelBean.contactRoleCode";
    private static final String KEY_PERSON_ROLE_ID = "projectPersonnelBean.newInstitutionalProposalContact.keyPersonRole";
    private static final String PERSON_ID = "10000000002";
    private static final String ROLODEX_ID = "1727";
    private static final String EMPLOYEE_FULL_NAME = "Joe Tester";
    private static final String ROLODEX_FULL_NAME = "Ho, Pauline";
    private static final String CO_INVESTIGATOR_CONTACT_ROLE_CODE = "Co-Investigator";
    private static final String KEY_PERSON_CONTACT_ROLE_CODE = "Key Person";
    private static final String OBSERVER_KEY_PERSON_ROLE = "Observer";
    private static final String ADD_PROJECT_PERSON_BUTTON = "methodToCall.addProjectPerson";
    private static final String DELETE_PROJECT_PERSON_BUTTON = "methodToCall.deleteProjectPerson.line%d";
    private InstitutionalProposalSeleniumHelper helper;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.helper = InstitutionalProposalSeleniumHelper.instance(driver);
    }

    @Override
    @After
    public void tearDown() throws Exception {
        this.helper = null;
        super.tearDown();
    }

    @Test
    public void testAddRemoveEmployeeContact() throws Exception {
        this.helper.createInstitutionalProposal();
        this.helper.clickInstitutionalProposalContactsPage();
        this.helper.openTab(PROJECT_PERSONNEL_TAG_ID);
        this.helper.lookup(PERSON_ID_TAG, PERSON_ID_ID, PERSON_ID);
        this.helper.set(CONTACT_ROLE_CODE_ID, CO_INVESTIGATOR_CONTACT_ROLE_CODE);
        this.helper.click(ADD_PROJECT_PERSON_BUTTON);
        this.helper.assertNoPageErrors();
        this.helper.assertPageContains(EMPLOYEE_FULL_NAME);
        this.helper.click(String.format(DELETE_PROJECT_PERSON_BUTTON, 1));
        this.helper.assertPageDoesNotContain(EMPLOYEE_FULL_NAME);
    }

    @Test
    public void testAddRemoveRolodexContact() throws Exception {
        this.helper.createInstitutionalProposal();
        this.helper.clickInstitutionalProposalContactsPage();
        this.helper.openTab(PROJECT_PERSONNEL_TAG_ID);
        this.helper.lookup(ROLODEX_ID_TAG, ROLODEX_ID_ID, ROLODEX_ID);
        this.helper.set(CONTACT_ROLE_CODE_ID, KEY_PERSON_CONTACT_ROLE_CODE);
        this.helper.set(KEY_PERSON_ROLE_ID, OBSERVER_KEY_PERSON_ROLE);
        this.helper.click(ADD_PROJECT_PERSON_BUTTON);
        this.helper.assertNoPageErrors();
        this.helper.assertPageContains(ROLODEX_FULL_NAME);
        this.helper.click(String.format(DELETE_PROJECT_PERSON_BUTTON, 1));
        this.helper.assertPageDoesNotContain(ROLODEX_FULL_NAME);
    }
}

