/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.institutionalproposal.web;

import org.kuali.kra.test.infrastructure.KcSeleniumHelper;
import org.openqa.selenium.WebDriver;

public class InstitutionalProposalSeleniumHelper
extends KcSeleniumHelper {
    private static final String PROPOSAL_LOG_PAGE_TITLE = "Kuali :: Proposal Log";
    private static final String CREATE_PROPOSAL_LOG_LINK_NAME = "Proposal Log";
    private static final String INSTITUTIONAL_PROPOSAL_PAGE_TITLE = "Kuali :: KC Institutional Proposal";
    private static final String CREATE_INSTITUTIONAL_PROPOSAL_LINK_NAME = "Institutional Proposal";
    private static final String HOME_LINK_NAME = "home";
    private static final String CONTACTS_LINK_NAME = "contacts";
    private static final String CUSTOM_DATA_LINK_NAME = "customData";
    private static final String SPECIAL_REVIEW_LINK_NAME = "specialReview";
    private static final String INTELLECTUAL_PROPERTY_REVIEW = "intellectualPropertyReview";
    private static final String DISTRIBUTION_LINK_NAME = "distribution";
    private static final String ACTIONS_LINK_NAME = "institutionalProposalActions";
    private static final String INSTITUTIONAL_PROPOSAL_TAB_ID = "Institutional Proposal";
    private static final String SPONSOR_PROGRAM_INFORMATION_TAB_ID = "Sponsor Program Information";
    private static final String PERSONNEL_ITEMS_FOR_REVIEW_TAB_ID = "Personnel Items for Review";
    private static final String ASDF_TAB_ID = "asdf asdf asdf asdf asdf asdf asdf asdf asdf asdf asdf asdf asdf asdf asdf asdf asdf asdf";
    private static final String DOCUMENT_DESCRIPTION_ID = "document.documentHeader.documentDescription";
    private static final String PL_DEFAULT_DOCUMENT_DESCRIPTION = "Proposal Log Web Test";
    private static final String PL_LIST_PREFIX = "document.newMaintainableObject.";
    private static final String PL_PROPOSAL_TYPE_CODE_ID = "document.newMaintainableObject.proposalTypeCode";
    private static final String PL_TITLE_ID = "document.newMaintainableObject.title";
    private static final String PL_PERSON_USER_NAME_ID = "document.newMaintainableObject.person.userName";
    private static final String PL_LEAD_UNIT_ID = "document.newMaintainableObject.leadUnit";
    private static final String IP_LIST_PREFIX = "document.institutionalProposalList[0].";
    private static final String IP_STATUS_CODE_ID = "document.institutionalProposal.statusCode";
    private static final String IP_ACTIVITY_TYPE_CODE_ID = "document.institutionalProposalList[0].activityTypeCode";
    private static final String IP_PROPOSAL_TYPE_CODE_ID = "document.institutionalProposalList[0].proposalTypeCode";
    private static final String IP_TITLE_ID = "document.institutionalProposalList[0].title";
    private static final String IP_SPONSOR_CODE_ID = "document.institutionalProposalList[0].sponsorCode";
    private static final String IP_CREDIT_SPLITS_ID = "document.institutionalProposalList[0].projectPersons[0].creditSplit[%d].credit";
    private static final String IP_UNIT_CREDIT_SPLITS_ID = "document.institutionalProposalList[0].projectPersons[0].unit[0].creditSplit[%d].credit";
    private static final String IP_GRADUATE_STUDENT_COUNT_ID = "institutionalProposalCustomDataFormHelper.customDataValues[3].value";
    private static final String IP_BILLING_ELEMENT_ID = "institutionalProposalCustomDataFormHelper.customDataValues[0].value";
    private static final String PL_DEFAULT_PROPSAL_TYPE = "New";
    private static final String PL_DEFAULT_TITLE = "Test Project";
    private static final String PL_DEFAULT_PERSON_USER_NAME = "majors";
    private static final String PL_DEFAULT_LEAD_UNIT = "000001";
    private static final String IP_DEFAULT_DOCUMENT_DESCRIPTION = "Institutional Proposal Web Test";
    private static final String IP_DEFAULT_STATUS = "Pending";
    private static final String IP_DEFAULT_PROPOSAL_TYPE = "New";
    private static final String IP_DEFAULT_ACTIVITY_TYPE = "Instruction";
    private static final String IP_DEFAULT_PROJECT_TITLE = "Test Project";
    private static final String IP_DEFAULT_SPONSOR_CODE = "005891";
    private static final String IP_DEFAULT_TOTAL_CREDIT_SPLIT = "100.00";
    private static final String IP_DEFAULT_GRADUATE_STUDENT_COUNT = "5";
    private static final String IP_DEFAULT_BILLING_ELEMENT = "College";
    private static InstitutionalProposalSeleniumHelper helper;

    public static InstitutionalProposalSeleniumHelper instance(WebDriver driver) {
        if (helper == null) {
            helper = new InstitutionalProposalSeleniumHelper(driver);
        }
        return helper;
    }

    private InstitutionalProposalSeleniumHelper(WebDriver driver) {
        super(driver);
    }

    public void clickInstitutionalProposalHomePage() {
        this.click(HOME_LINK_NAME);
    }

    public void clickInstitutionalProposalContactsPage() {
        this.click(CONTACTS_LINK_NAME);
    }

    public void clickInstitutionalProposalCustomDataPage() {
        this.click(CUSTOM_DATA_LINK_NAME);
    }

    public void clickInstitutionalProposalSpecialReviewPage() {
        this.click(SPECIAL_REVIEW_LINK_NAME);
    }

    public void clickInstitutionalProposalIntellectualPropertyReviewPage() {
        this.click(INTELLECTUAL_PROPERTY_REVIEW);
    }

    public void clickInstitutionalProposalDistributionPage() {
        this.click(DISTRIBUTION_LINK_NAME);
    }

    public void clickInstitutionalProposalActionsPage() {
        this.click(ACTIONS_LINK_NAME);
    }

    public final void createProposalLog() {
        this.clickCentralAdminTab();
        this.click(CREATE_PROPOSAL_LOG_LINK_NAME);
        this.assertTitleContains(PROPOSAL_LOG_PAGE_TITLE);
        this.set(DOCUMENT_DESCRIPTION_ID, PL_DEFAULT_DOCUMENT_DESCRIPTION);
        this.set(PL_PROPOSAL_TYPE_CODE_ID, "New");
        this.set(PL_TITLE_ID, "Test Project");
        this.set(PL_PERSON_USER_NAME_ID, PL_DEFAULT_PERSON_USER_NAME);
        this.set(PL_LEAD_UNIT_ID, PL_DEFAULT_LEAD_UNIT);
        this.blanketApproveDocument();
    }

    public final void createInstitutionalProposal() {
        this.clickCentralAdminTab();
        this.createProposalLog();
        this.clickCentralAdminTab();
        this.lookupProposalLog();
        this.assertTitleContains(INSTITUTIONAL_PROPOSAL_PAGE_TITLE);
        this.setDefaultRequiredFields();
        this.saveDocument();
        this.assertSave();
    }

    public final void lookupProposalLog() {
        this.click("Institutional Proposal");
        this.click("methodToCall.search");
        this.assertTableCellValueContains("row", 0, 0, "select");
        this.click("select", true);
    }

    private void setDefaultRequiredFields() {
        this.set(DOCUMENT_DESCRIPTION_ID, IP_DEFAULT_DOCUMENT_DESCRIPTION);
        this.openTab("Institutional Proposal");
        this.set(IP_STATUS_CODE_ID, IP_DEFAULT_STATUS);
        this.set(IP_PROPOSAL_TYPE_CODE_ID, "New");
        this.set(IP_ACTIVITY_TYPE_CODE_ID, IP_DEFAULT_ACTIVITY_TYPE);
        this.set(IP_TITLE_ID, "Test Project");
        this.openTab(SPONSOR_PROGRAM_INFORMATION_TAB_ID);
        this.set(IP_SPONSOR_CODE_ID, IP_DEFAULT_SPONSOR_CODE);
    }

    public void addContacts() {
        this.clickInstitutionalProposalContactsPage();
        this.openTab(0);
        for (int i = 0; i < 4; ++i) {
            this.set(String.format(IP_CREDIT_SPLITS_ID, i), IP_DEFAULT_TOTAL_CREDIT_SPLIT);
            this.set(String.format(IP_UNIT_CREDIT_SPLITS_ID, i), IP_DEFAULT_TOTAL_CREDIT_SPLIT);
        }
    }

    public void addCustomData() {
        this.clickInstitutionalProposalCustomDataPage();
        this.openTab(PERSONNEL_ITEMS_FOR_REVIEW_TAB_ID);
        this.set(IP_GRADUATE_STUDENT_COUNT_ID, IP_DEFAULT_GRADUATE_STUDENT_COUNT);
        this.openTab(ASDF_TAB_ID);
        this.set(IP_BILLING_ELEMENT_ID, IP_DEFAULT_BILLING_ELEMENT);
    }

    public void submit() {
        this.clickInstitutionalProposalActionsPage();
        this.routeDocument();
        this.assertRoute();
    }
}

