/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.irb;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.kuali.kra.award.awardhierarchy.AwardHierarchy;
import org.kuali.kra.award.home.Award;
import org.kuali.kra.institutionalproposal.home.InstitutionalProposal;
import org.kuali.kra.service.impl.adapters.BusinessObjectServiceAdapter;
import org.kuali.kra.service.impl.adapters.DocumentServiceAdapter;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.krad.bo.DocumentHeader;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.document.Document;

public class IrbMockServicesHelper {

    static class MockDocumentService
    extends DocumentServiceAdapter {
        MockDocumentService() {
        }

        @Override
        public Document getByDocumentHeaderId(String documentHeaderId) throws WorkflowException {
            return null;
        }

        public Document getNewDocument(Class documentClass) throws WorkflowException {
            return null;
        }
    }

    public static class MockBusinessObjectService
    extends BusinessObjectServiceAdapter {
        Map<String, AwardHierarchy> awardHierarchyMap = new TreeMap<String, AwardHierarchy>();
        Map<String, Award> awardMap = new TreeMap<String, Award>();
        Map<Long, InstitutionalProposal> institutionalProposalMap = new TreeMap<Long, InstitutionalProposal>();

        public PersistableBusinessObject findByPrimaryKey(Class klass, Map identifiers) {
            if (klass.equals(Award.class)) {
                String awardNumber = (String)identifiers.get("awardNumber");
                return awardNumber != null ? this.awardMap.get(awardNumber) : null;
            }
            if (klass.equals(AwardHierarchy.class)) {
                String awardNumber = (String)identifiers.get("awardNumber");
                return awardNumber != null ? this.awardHierarchyMap.get(awardNumber) : null;
            }
            if (klass.equals(InstitutionalProposal.class)) {
                String proposalId = (String)identifiers.get("proposalId");
                return proposalId != null ? this.institutionalProposalMap.get(Long.valueOf(proposalId)) : null;
            }
            return null;
        }

        @Override
        public PersistableBusinessObject save(PersistableBusinessObject bo) {
            if (bo instanceof AwardHierarchy) {
                AwardHierarchy awardHierarchy = (AwardHierarchy)bo;
                this.awardHierarchyMap.put(awardHierarchy.getAwardNumber(), awardHierarchy);
            }
            if (bo instanceof Award) {
                Award award;
                award.setAwardId(Long.valueOf((award = (Award)bo).getAwardId() == null ? 1L : award.getAwardId() + 1L));
                this.awardMap.put(award.getAwardNumber(), award);
            } else if (bo instanceof InstitutionalProposal) {
                InstitutionalProposal instProp;
                instProp.setProposalId(Long.valueOf((instProp = (InstitutionalProposal)bo).getProposalId() == null ? 1L : instProp.getProposalId()));
                this.institutionalProposalMap.put(instProp.getProposalId(), instProp);
            }
            return bo;
        }

        @Override
        public List<? extends PersistableBusinessObject> save(List<? extends PersistableBusinessObject> bizObjects) {
            for (PersistableBusinessObject persistableBusinessObject : bizObjects) {
                this.save(persistableBusinessObject);
            }
            return bizObjects;
        }

        public Collection findMatching(Class klass, Map fieldValues) {
            ArrayList<Object> c;
            if (klass.equals(AwardHierarchy.class)) {
                ArrayList<AwardHierarchy> awardHierarchyNodes = new ArrayList<AwardHierarchy>();
                awardHierarchyNodes.add(this.awardHierarchyMap.get(fieldValues.get("awardNumber")));
                c = awardHierarchyNodes;
            } else if (klass.equals(Award.class)) {
                ArrayList<Award> awards = new ArrayList<Award>();
                awards.add(this.awardMap.get(fieldValues.get("awardNumber")));
                c = awards;
            } else if (klass.equals(InstitutionalProposal.class)) {
                ArrayList<InstitutionalProposal> proposals = new ArrayList<InstitutionalProposal>();
                proposals.add(this.institutionalProposalMap.get(fieldValues.get("proposalId")));
                c = proposals;
            } else {
                c = klass.equals(DocumentHeader.class) ? new ArrayList() : null;
            }
            return c;
        }

        public Collection findMatchingOrderBy(Class klass, Map fieldValues, String sortField, boolean sortAscending) {
            if (klass.equals(AwardHierarchy.class)) {
                String parentAwardNumber = (String)fieldValues.get("parentAwardNumber");
                TreeMap<String, AwardHierarchy> matching = new TreeMap<String, AwardHierarchy>();
                for (AwardHierarchy node : this.awardHierarchyMap.values()) {
                    if (!node.getParentAwardNumber().equals(parentAwardNumber)) continue;
                    matching.put(node.getAwardNumber(), node);
                }
                ArrayList list = new ArrayList();
                for (String awardNumber : matching.keySet()) {
                    list.add(matching.get(awardNumber));
                }
                return list;
            }
            if (klass.equals(Award.class)) {
                ArrayList<Award> list = new ArrayList<Award>();
                list.add(this.awardMap.get(fieldValues.get("awardNumber")));
                return list;
            }
            if (klass.equals(InstitutionalProposal.class)) {
                ArrayList<InstitutionalProposal> list = new ArrayList<InstitutionalProposal>();
                list.add(this.institutionalProposalMap.get(fieldValues.get("awardNumber")));
                return list;
            }
            return null;
        }
    }
}

