/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.irb;

import java.util.ArrayList;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kra.bo.ResearchAreaBase;
import org.kuali.kra.irb.ProtocolDocument;
import org.kuali.kra.irb.ProtocolDocumentRule;
import org.kuali.kra.irb.ResearchArea;
import org.kuali.kra.irb.protocol.research.ProtocolResearchArea;
import org.kuali.kra.irb.test.ProtocolRuleTestBase;
import org.kuali.kra.protocol.ProtocolDocumentBase;
import org.kuali.rice.kns.service.DictionaryValidationService;
import org.kuali.rice.kns.service.KNSServiceLocator;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.krad.util.MessageMap;

public class ProtocolDocumentRuleTest
extends ProtocolRuleTestBase {
    private static final String PROTOCOL_LUN_FORM_ELEMENT = "protocolHelper.leadUnitNumber";
    private static final String ERROR_PROPERTY_ORGANIZATION_ID = "protocolHelper.newProtocolLocation.organizationId";
    private static final String INACTIVE_RESEARCH_AREAS_PREFIX = "document.protocolList[0].protocolResearchAreas.inactive";
    private static final String SEPERATOR = ".";
    private ProtocolDocumentRule rule = null;
    private DictionaryValidationService dictionaryValidationService = null;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.rule = new ProtocolDocumentRule();
        this.dictionaryValidationService = KNSServiceLocator.getKNSDictionaryValidationService();
    }

    @Override
    @After
    public void tearDown() throws Exception {
        this.rule = null;
        this.dictionaryValidationService = null;
        super.tearDown();
    }

    @Test
    public void testRequiredBusinessRuleOK() throws Exception {
        ProtocolDocument document = this.getNewProtocolDocument();
        this.setProtocolRequiredFields(document);
        MessageMap messageMap = GlobalVariables.getMessageMap();
        messageMap.addToErrorPath("document");
        this.dictionaryValidationService.validateDocumentAndUpdatableReferencesRecursively((Document)document, 10, true, true);
        ProtocolDocumentRuleTest.assertTrue((boolean)messageMap.hasNoErrors());
        messageMap.removeFromErrorPath("document");
        ProtocolDocumentRuleTest.assertTrue((boolean)this.rule.processLeadUnitBusinessRules((ProtocolDocumentBase)document));
    }

    @Test
    public void testMissingRequiredFields() throws Exception {
        ProtocolDocument document = this.getNewProtocolDocument();
        document.getDocumentHeader().setDocumentDescription("Protocol Document");
        MessageMap errorMap = GlobalVariables.getMessageMap();
        errorMap.addToErrorPath("document");
        this.dictionaryValidationService.validateDocumentAndUpdatableReferencesRecursively((Document)document, 10, true, true);
        ProtocolDocumentRuleTest.assertEquals((long)3L, (long)errorMap.getErrorMessages().size());
        this.assertError("document.protocolList[0].leadUnitNumber", "error.required");
        this.assertError("document.protocolList[0].title", "error.required");
        this.assertError("document.protocolList[0].principalInvestigatorId", "error.required");
    }

    @Test
    public void testInvalidLU() throws Exception {
        ProtocolDocument document = this.getNewProtocolDocument();
        this.setProtocolRequiredFields(document);
        document.getProtocol().setLeadUnitNumber("bogus");
        ProtocolDocumentRuleTest.assertFalse((boolean)this.rule.processLeadUnitBusinessRules((ProtocolDocumentBase)document));
        this.assertError(PROTOCOL_LUN_FORM_ELEMENT, "error.protocolRequiredFields.leadUnitNum.invalid");
    }

    @Test
    public void testProcessProtocolLocationBusinessRules() throws Exception {
        ProtocolDocument document = this.getNewProtocolDocument();
        this.setProtocolRequiredFields(document);
        document.getProtocol().getProtocolLocations().clear();
        ProtocolDocumentRuleTest.assertFalse((boolean)this.rule.processProtocolLocationBusinessRules((ProtocolDocumentBase)document));
        this.assertError(ERROR_PROPERTY_ORGANIZATION_ID, "error.protocolLocation.shouldExist");
    }

    @Test
    public void testProcessProtocolResearchAreaBusinessRules() throws Exception {
        ProtocolDocument document = this.getNewProtocolDocument();
        this.setProtocolRequiredFields(document);
        ProtocolDocumentRuleTest.assertTrue((boolean)this.rule.processProtocolResearchAreaBusinessRules((ProtocolDocumentBase)document));
        ProtocolResearchArea dummyPRA0 = new ProtocolResearchArea();
        ResearchArea dummyRA0 = new ResearchArea();
        dummyRA0.setActive(true);
        dummyPRA0.setResearchAreas((ResearchAreaBase)dummyRA0);
        ProtocolResearchArea dummyPRA1 = new ProtocolResearchArea();
        ResearchArea dummyRA1 = new ResearchArea();
        dummyRA1.setActive(true);
        dummyPRA1.setResearchAreas((ResearchAreaBase)dummyRA1);
        ProtocolResearchArea dummyPRA2 = new ProtocolResearchArea();
        ResearchArea dummyRA2 = new ResearchArea();
        dummyRA2.setActive(true);
        dummyPRA2.setResearchAreas((ResearchAreaBase)dummyRA2);
        ProtocolResearchArea dummyPRA3 = new ProtocolResearchArea();
        ResearchArea dummyRA3 = new ResearchArea();
        dummyRA3.setActive(true);
        dummyPRA3.setResearchAreas((ResearchAreaBase)dummyRA3);
        ArrayList<ProtocolResearchArea> pras = new ArrayList<ProtocolResearchArea>();
        pras.add(dummyPRA0);
        pras.add(dummyPRA1);
        pras.add(dummyPRA2);
        pras.add(dummyPRA3);
        document.getProtocol().setProtocolResearchAreas(pras);
        ProtocolDocumentRuleTest.assertTrue((boolean)document.getProtocol().getProtocolResearchAreas(0).getResearchAreas().isActive());
        ProtocolDocumentRuleTest.assertTrue((boolean)document.getProtocol().getProtocolResearchAreas(1).getResearchAreas().isActive());
        ProtocolDocumentRuleTest.assertTrue((boolean)document.getProtocol().getProtocolResearchAreas(2).getResearchAreas().isActive());
        ProtocolDocumentRuleTest.assertTrue((boolean)document.getProtocol().getProtocolResearchAreas(3).getResearchAreas().isActive());
        ProtocolDocumentRuleTest.assertTrue((boolean)this.rule.processProtocolResearchAreaBusinessRules((ProtocolDocumentBase)document));
        ProtocolDocumentRuleTest.assertTrue((boolean)document.getProtocol().getProtocolResearchAreas(0).getResearchAreas().isActive());
        dummyRA1.setActive(false);
        ProtocolDocumentRuleTest.assertFalse((boolean)document.getProtocol().getProtocolResearchAreas(1).getResearchAreas().isActive());
        ProtocolDocumentRuleTest.assertTrue((boolean)document.getProtocol().getProtocolResearchAreas(2).getResearchAreas().isActive());
        dummyRA3.setActive(false);
        ProtocolDocumentRuleTest.assertFalse((boolean)document.getProtocol().getProtocolResearchAreas(3).getResearchAreas().isActive());
        ProtocolDocumentRuleTest.assertFalse((boolean)this.rule.processProtocolResearchAreaBusinessRules((ProtocolDocumentBase)document));
        String errorPropertyKey = "document.protocolList[0].protocolResearchAreas.inactive.1.3.";
        this.assertError(errorPropertyKey, "error.protocol.researchArea.inactive");
    }
}

