/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.irb;

import java.util.List;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.irb.Protocol;
import org.kuali.kra.irb.ProtocolDocument;
import org.kuali.kra.irb.ProtocolFinderDao;
import org.kuali.kra.irb.test.ProtocolFactory;
import org.kuali.kra.test.infrastructure.KcUnitTestBase;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.krad.UserSession;
import org.kuali.rice.krad.util.GlobalVariables;

public class ProtocolFinderDaoOjbTest
extends KcUnitTestBase {
    private static final String PROTOCOL_NUMBER = "0906000001";
    private static final String PROTOCOL_NUMBER2 = "0906000002";
    private ProtocolFinderDao protocolFinder;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.protocolFinder = (ProtocolFinderDao)KraServiceLocator.getService(ProtocolFinderDao.class);
        GlobalVariables.setUserSession((UserSession)new UserSession("quickstart"));
    }

    @Override
    @After
    public void tearDown() throws Exception {
        GlobalVariables.setUserSession(null);
        super.tearDown();
    }

    @Test
    public void testFinder() throws WorkflowException {
        ProtocolFactory.createProtocolDocument(PROTOCOL_NUMBER, 1);
        ProtocolDocument protocolDocument1 = ProtocolFactory.createProtocolDocument(PROTOCOL_NUMBER, 2);
        ProtocolDocument protocolDocument2 = ProtocolFactory.createProtocolDocument(PROTOCOL_NUMBER2, 1);
        Protocol protocol = this.protocolFinder.findCurrentProtocolByNumber(PROTOCOL_NUMBER2);
        ProtocolFinderDaoOjbTest.assertNotNull((Object)protocol);
        ProtocolFinderDaoOjbTest.assertEquals((Object)protocolDocument2.getProtocol().getProtocolId(), (Object)protocol.getProtocolId());
        protocol = this.protocolFinder.findCurrentProtocolByNumber(PROTOCOL_NUMBER);
        ProtocolFinderDaoOjbTest.assertNotNull((Object)protocol);
        ProtocolFinderDaoOjbTest.assertEquals((Object)protocolDocument1.getProtocol().getProtocolId(), (Object)protocol.getProtocolId());
    }

    @Test
    public void testFindProtocol() throws WorkflowException {
        ProtocolFactory.createProtocolDocument(PROTOCOL_NUMBER, 1);
        ProtocolDocument protocolDocument1 = ProtocolFactory.createProtocolDocument(PROTOCOL_NUMBER, 2);
        ProtocolDocument protocolDocument2 = ProtocolFactory.createProtocolDocument("0906000001A001", 1);
        List protocols = this.protocolFinder.findProtocols(PROTOCOL_NUMBER);
        ProtocolFinderDaoOjbTest.assertEquals((long)3L, (long)protocols.size());
        ProtocolFinderDaoOjbTest.assertEquals((Object)PROTOCOL_NUMBER, (Object)((Protocol)protocols.get(0)).getProtocolNumber());
    }
}

