/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.irb;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.jmock.Expectations;
import org.jmock.Mockery;
import org.jmock.integration.junit4.JUnit4Mockery;
import org.jmock.internal.ExpectationBuilder;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kra.bo.KcPerson;
import org.kuali.kra.common.permissions.Permissionable;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.irb.Protocol;
import org.kuali.kra.irb.ProtocolDao;
import org.kuali.kra.irb.ProtocolDocument;
import org.kuali.kra.irb.ProtocolLookupableHelperServiceImpl;
import org.kuali.kra.irb.personnel.ProtocolPerson;
import org.kuali.kra.irb.test.ProtocolFactory;
import org.kuali.kra.protocol.ProtocolDocumentBase;
import org.kuali.kra.service.KcPersonService;
import org.kuali.kra.service.KraAuthorizationService;
import org.kuali.kra.test.infrastructure.KcUnitTestBase;
import org.kuali.rice.kns.lookup.HtmlData;
import org.kuali.rice.kns.web.ui.Field;
import org.kuali.rice.kns.web.ui.Row;
import org.kuali.rice.krad.UserSession;
import org.kuali.rice.krad.bo.BusinessObject;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.util.GlobalVariables;

public class ProtocolLookupHelperServiceTest
extends KcUnitTestBase {
    private static final String EDIT_URL = "../protocolProtocol.do?viewDocument=false&docId=101&docTypeName=ProtocolDocument&methodToCall=docHandler&command=displayDocSearchView";
    private static final String VIEW_URL = "../protocolProtocol.do?viewDocument=true&docId=101&docTypeName=ProtocolDocument&methodToCall=docHandler&command=displayDocSearchView";
    private static final String COPY_URL = "../DocCopyHandler.do?docId=101&command=displayDocSearchView&documentTypeName=ProtocolDocument";
    private static final String UNIT_INQ_URL = "inquiry.do?businessObjectClassName=org.kuali.kra.bo.Unit&unitNumber=000001&methodToCall=start";
    private static final String PERSON_INQ_URL = "inquiry.do?businessObjectClassName=org.kuali.kra.bo.KcPerson&personId=10000000001&methodToCall=start";
    private static final String ROLODEX_INQ_URL = "inquiry.do?businessObjectClassName=org.kuali.kra.bo.Rolodex&rolodexId=1727&methodToCall=start";
    private static final int NUMBER_LOOKUP_CRITERIA_FIELDS = 23;
    private ProtocolLookupableHelperServiceImpl protocolLookupableHelperServiceImpl;
    private Mockery context = new JUnit4Mockery();

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.protocolLookupableHelperServiceImpl = new ProtocolLookupableHelperServiceImpl();
        this.protocolLookupableHelperServiceImpl.setBusinessObjectClass(Protocol.class);
        GlobalVariables.setUserSession((UserSession)new UserSession("quickstart"));
    }

    @Override
    @After
    public void tearDown() throws Exception {
        super.tearDown();
        this.protocolLookupableHelperServiceImpl = null;
        GlobalVariables.setUserSession(null);
    }

    @Test
    public void testGetRows() {
        List rows = this.protocolLookupableHelperServiceImpl.getRows();
        ProtocolLookupHelperServiceTest.assertEquals((long)23L, (long)rows.size());
        for (Row row : rows) {
            for (Field field : row.getFields()) {
                if (!field.getPropertyName().equals("researchAreaCode")) continue;
                this.assertDropDownField(field, "researchAreaCode", "org.kuali.kra.irb.ResearchArea");
            }
        }
    }

    private void assertDropDownField(Field field, String keyName, String className) {
        ProtocolLookupHelperServiceTest.assertEquals((Object)field.getFieldConversions(), (Object)(keyName + ":" + field.getPropertyName()));
        ProtocolLookupHelperServiceTest.assertEquals((Object)field.getLookupParameters(), (Object)(field.getPropertyName() + ":" + keyName));
        ProtocolLookupHelperServiceTest.assertEquals((Object)field.getInquiryParameters(), (Object)(field.getPropertyName() + ":" + keyName));
        ProtocolLookupHelperServiceTest.assertEquals((Object)field.getQuickFinderClassNameImpl(), (Object)className);
    }

    @Test
    public void testGetInquiryUrl() {
        Protocol protocol = this.initProtocol();
        final KcPersonService kcPersonService = (KcPersonService)this.context.mock(KcPersonService.class);
        final String principalId = GlobalVariables.getUserSession().getPrincipalId();
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((KcPersonService)this.one(kcPersonService)).getKcPersonByPersonId(principalId);
                this.will(1.returnValue((Object)KcPerson.fromPersonId((String)principalId)));
            }
        });
        this.protocolLookupableHelperServiceImpl.setKcPersonService(kcPersonService);
        HtmlData inquiryUrl = this.protocolLookupableHelperServiceImpl.getInquiryUrl((BusinessObject)protocol, "leadUnitNumber");
        ProtocolLookupHelperServiceTest.assertEquals((Object)((HtmlData.AnchorHtmlData)inquiryUrl).getHref(), (Object)UNIT_INQ_URL);
        inquiryUrl = this.protocolLookupableHelperServiceImpl.getInquiryUrl((BusinessObject)protocol, "investigator");
        ProtocolLookupHelperServiceTest.assertEquals((Object)((HtmlData.AnchorHtmlData)inquiryUrl).getHref(), (Object)PERSON_INQ_URL);
        ProtocolPerson protocolPerson = (ProtocolPerson)protocol.getProtocolPersons().get(0);
        protocolPerson.setPersonId("");
        protocolPerson.setRolodexId(new Integer(1727));
        protocol.getProtocolPersons().clear();
        protocol.getProtocolPersons().add(protocolPerson);
        inquiryUrl = this.protocolLookupableHelperServiceImpl.getInquiryUrl((BusinessObject)protocol, "investigator");
        ProtocolLookupHelperServiceTest.assertEquals((Object)((HtmlData.AnchorHtmlData)inquiryUrl).getHref(), (Object)ROLODEX_INQ_URL);
    }

    @Test
    public void testGetCustomActionUrls() {
        ArrayList<String> pkNames = new ArrayList<String>();
        pkNames.add("protocolId");
        final Protocol protocol = new Protocol();
        protocol.setProtocolNumber("100");
        ProtocolDocument document = new ProtocolDocument();
        document.setDocumentNumber("101");
        protocol.setProtocolDocument((ProtocolDocumentBase)document);
        final KraAuthorizationService kraAuthorizationService = (KraAuthorizationService)this.context.mock(KraAuthorizationService.class);
        final String principalId = GlobalVariables.getUserSession().getPrincipalId();
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                HashMap fieldValues = new HashMap();
                ((KraAuthorizationService)this.one(kraAuthorizationService)).hasPermission(principalId, (Permissionable)protocol, "Modify Protocol");
                this.will(2.returnValue((Object)true));
                ((KraAuthorizationService)this.one(kraAuthorizationService)).hasPermission(principalId, (Permissionable)protocol, "View Protocol");
                this.will(2.returnValue((Object)true));
            }
        });
        this.protocolLookupableHelperServiceImpl.setKraAuthorizationService(kraAuthorizationService);
        List actionUrls = this.protocolLookupableHelperServiceImpl.getCustomActionUrls((BusinessObject)protocol, pkNames);
        for (HtmlData htmlData : actionUrls) {
            HtmlData.AnchorHtmlData actionUrl = (HtmlData.AnchorHtmlData)htmlData;
            if (actionUrl.getMethodToCall().equals("copy")) {
                ProtocolLookupHelperServiceTest.assertEquals((Object)actionUrl.getHref(), (Object)COPY_URL);
                continue;
            }
            if (actionUrl.getDisplayText().equals("edit")) {
                ProtocolLookupHelperServiceTest.assertEquals((Object)actionUrl.getHref(), (Object)EDIT_URL);
                continue;
            }
            if (!actionUrl.getDisplayText().equals("view")) continue;
            ProtocolLookupHelperServiceTest.assertEquals((Object)actionUrl.getHref(), (Object)VIEW_URL);
        }
    }

    @Test
    public void testGetSearchResults() throws Exception {
        String newProtocolNumber = "123456132";
        Protocol prot = ProtocolFactory.createProtocolDocument(newProtocolNumber).getProtocol();
        ((BusinessObjectService)KraServiceLocator.getService(BusinessObjectService.class)).save((PersistableBusinessObject)prot);
        ProtocolDao protocolDao = (ProtocolDao)KraServiceLocator.getService(ProtocolDao.class);
        this.protocolLookupableHelperServiceImpl.setProtocolDao((org.kuali.kra.protocol.ProtocolDao)protocolDao);
        HashMap<String, String> searchStuff = new HashMap<String, String>();
        searchStuff.put("protocolNumber", newProtocolNumber);
        List searchResults = this.protocolLookupableHelperServiceImpl.getSearchResults(searchStuff);
        ProtocolLookupHelperServiceTest.assertEquals((String)("searchResults.size(): '" + searchResults.size() + "'"), (long)1L, (long)searchResults.size());
    }

    private Protocol initProtocol() {
        Protocol protocol = new Protocol();
        protocol.setLeadUnitNumber("000001");
        protocol.setPrincipalInvestigatorId("10000000001");
        ProtocolPerson protocolPerson = new ProtocolPerson();
        protocolPerson.setPersonId("10000000001");
        protocol.getProtocolPersons().add(protocolPerson);
        protocolPerson.setProtocolPersonRoleId("PI");
        return protocol;
    }
}

