/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.irb;

import java.util.ArrayList;
import java.util.List;
import org.jmock.Expectations;
import org.jmock.Mockery;
import org.jmock.integration.junit4.JUnit4Mockery;
import org.jmock.internal.ExpectationBuilder;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kra.bo.KcPerson;
import org.kuali.kra.committee.bo.Committee;
import org.kuali.kra.committee.document.CommitteeDocument;
import org.kuali.kra.common.committee.bo.CommitteeBase;
import org.kuali.kra.common.committee.document.CommitteeDocumentBase;
import org.kuali.kra.common.permissions.Permissionable;
import org.kuali.kra.irb.Protocol;
import org.kuali.kra.irb.ProtocolDocument;
import org.kuali.kra.irb.ProtocolSubmissionLookupableHelperServiceImpl;
import org.kuali.kra.irb.actions.submit.ProtocolSubmission;
import org.kuali.kra.irb.personnel.ProtocolPerson;
import org.kuali.kra.protocol.ProtocolBase;
import org.kuali.kra.protocol.ProtocolDocumentBase;
import org.kuali.kra.service.KcPersonService;
import org.kuali.kra.service.KraAuthorizationService;
import org.kuali.kra.test.infrastructure.KcUnitTestBase;
import org.kuali.rice.kns.lookup.HtmlData;
import org.kuali.rice.krad.UserSession;
import org.kuali.rice.krad.bo.BusinessObject;
import org.kuali.rice.krad.util.GlobalVariables;

public class ProtocolSubmissionLookupHelperServiceTest
extends KcUnitTestBase {
    private static final String EDIT_URL = "../protocolProtocol.do?viewDocument=false&docId=101&submissionId=102&docTypeName=ProtocolDocument&methodToCall=docHandler&command=displayDocSearchView";
    private static final String VIEW_URL = "../protocolProtocol.do?viewDocument=true&docId=101&submissionId=102&docTypeName=ProtocolDocument&methodToCall=docHandler&command=displayDocSearchView";
    private static final String PROTOCOL_INQ_URL = "inquiry.do?businessObjectClassName=org.kuali.kra.irb.Protocol&methodToCall=start&protocolId=104";
    private static final String COMMITTEE_INQ_URL = "inquiry.do?businessObjectClassName=org.kuali.kra.committee.bo.Committee&methodToCall=start&id=103";
    private static final String PERSON_INQ_URL = "inquiry.do?businessObjectClassName=org.kuali.kra.bo.KcPerson&personId=10000000001&methodToCall=start";
    private static final String ROLODEX_INQ_URL = "inquiry.do?businessObjectClassName=org.kuali.kra.bo.Rolodex&rolodexId=1727&methodToCall=start";
    private ProtocolSubmissionLookupableHelperServiceImpl protocolSubmissionLookupableHelperServiceImpl;
    private Mockery context = new JUnit4Mockery();

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.protocolSubmissionLookupableHelperServiceImpl = new ProtocolSubmissionLookupableHelperServiceImpl();
        this.protocolSubmissionLookupableHelperServiceImpl.setBusinessObjectClass(ProtocolSubmission.class);
        GlobalVariables.setUserSession((UserSession)new UserSession("quickstart"));
    }

    @Override
    @After
    public void tearDown() throws Exception {
        super.tearDown();
        this.protocolSubmissionLookupableHelperServiceImpl = null;
        GlobalVariables.setUserSession(null);
    }

    @Test
    public void testGetCustomActionUrls() {
        ArrayList<String> pkNames = new ArrayList<String>();
        pkNames.add("protocolId");
        final ProtocolSubmission protocolSubmission = this.initProtocolSubmission();
        final KraAuthorizationService kraAuthorizationService = (KraAuthorizationService)this.context.mock(KraAuthorizationService.class);
        final String principalId = GlobalVariables.getUserSession().getPrincipalId();
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((KraAuthorizationService)this.one(kraAuthorizationService)).hasPermission(principalId, (Permissionable)protocolSubmission.getProtocol(), "Modify Protocol");
                this.will(1.returnValue((Object)true));
                ((KraAuthorizationService)this.one(kraAuthorizationService)).hasPermission(principalId, (Permissionable)protocolSubmission.getProtocol(), "View Protocol");
                this.will(1.returnValue((Object)true));
            }
        });
        this.protocolSubmissionLookupableHelperServiceImpl.setKraAuthorizationService(kraAuthorizationService);
        List actionUrls = this.protocolSubmissionLookupableHelperServiceImpl.getCustomActionUrls((BusinessObject)protocolSubmission, pkNames);
        ProtocolSubmissionLookupHelperServiceTest.assertTrue((actionUrls.size() == 2 ? 1 : 0) != 0);
        ProtocolSubmissionLookupHelperServiceTest.assertTrue((boolean)((HtmlData)actionUrls.get(0)).getDisplayText().equals("edit"));
        ProtocolSubmissionLookupHelperServiceTest.assertEquals((Object)((HtmlData.AnchorHtmlData)actionUrls.get(0)).getHref(), (Object)EDIT_URL);
        ProtocolSubmissionLookupHelperServiceTest.assertTrue((boolean)((HtmlData)actionUrls.get(1)).getDisplayText().equals("view"));
        ProtocolSubmissionLookupHelperServiceTest.assertEquals((Object)((HtmlData.AnchorHtmlData)actionUrls.get(1)).getHref(), (Object)VIEW_URL);
    }

    @Test
    public void testGetInquiryUrl() {
        ProtocolSubmission protocolSubmission = this.initProtocolSubmission();
        final KcPersonService kcPersonService = (KcPersonService)this.context.mock(KcPersonService.class);
        final String principalId = GlobalVariables.getUserSession().getPrincipalId();
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((KcPersonService)this.one(kcPersonService)).getKcPersonByPersonId(principalId);
                this.will(2.returnValue((Object)KcPerson.fromPersonId((String)principalId)));
            }
        });
        this.protocolSubmissionLookupableHelperServiceImpl.setKcPersonService(kcPersonService);
        HtmlData inquiryUrl = this.protocolSubmissionLookupableHelperServiceImpl.getInquiryUrl((BusinessObject)protocolSubmission, "protocolNumber");
        ProtocolSubmissionLookupHelperServiceTest.assertEquals((Object)((HtmlData.AnchorHtmlData)inquiryUrl).getHref(), (Object)PROTOCOL_INQ_URL);
        inquiryUrl = this.protocolSubmissionLookupableHelperServiceImpl.getInquiryUrl((BusinessObject)protocolSubmission, "committeeId");
        ProtocolSubmissionLookupHelperServiceTest.assertEquals((Object)((HtmlData.AnchorHtmlData)inquiryUrl).getHref(), (Object)COMMITTEE_INQ_URL);
        inquiryUrl = this.protocolSubmissionLookupableHelperServiceImpl.getInquiryUrl((BusinessObject)protocolSubmission, "piName");
        ProtocolSubmissionLookupHelperServiceTest.assertEquals((Object)((HtmlData.AnchorHtmlData)inquiryUrl).getHref(), (Object)PERSON_INQ_URL);
        ProtocolPerson protocolPerson = (ProtocolPerson)protocolSubmission.getProtocol().getProtocolPersons().get(0);
        protocolPerson.setPersonId("");
        protocolPerson.setRolodexId(new Integer(1727));
        protocolSubmission.getProtocol().getProtocolPersons().clear();
        protocolSubmission.getProtocol().getProtocolPersons().add(protocolPerson);
        inquiryUrl = this.protocolSubmissionLookupableHelperServiceImpl.getInquiryUrl((BusinessObject)protocolSubmission, "piName");
        ProtocolSubmissionLookupHelperServiceTest.assertEquals((Object)((HtmlData.AnchorHtmlData)inquiryUrl).getHref(), (Object)ROLODEX_INQ_URL);
    }

    private ProtocolSubmission initProtocolSubmission() {
        Protocol protocol = new Protocol();
        protocol.setLeadUnitNumber("000001");
        protocol.setProtocolId(Long.valueOf(104L));
        protocol.setPrincipalInvestigatorId("10000000001");
        ProtocolPerson protocolPerson = new ProtocolPerson();
        protocolPerson.setPersonId("10000000001");
        protocol.getProtocolPersons().add(protocolPerson);
        protocolPerson.setProtocolPersonRoleId("PI");
        protocol.setProtocolNumber("100");
        ProtocolDocument protocolDocument = new ProtocolDocument();
        protocolDocument.setDocumentNumber("101");
        protocol.setProtocolDocument((ProtocolDocumentBase)protocolDocument);
        ProtocolSubmission protocolSubmission = new ProtocolSubmission();
        ArrayList<ProtocolSubmission> submissions = new ArrayList<ProtocolSubmission>();
        protocolSubmission.setSubmissionId(Long.valueOf(102L));
        Committee committee = new Committee();
        committee.setCommitteeId("100");
        CommitteeDocument document = new CommitteeDocument();
        document.setDocumentNumber("101");
        committee.setCommitteeDocument((CommitteeDocumentBase)document);
        committee.setId(Long.valueOf(103L));
        protocolSubmission.setCommittee((CommitteeBase)committee);
        submissions.add(protocolSubmission);
        protocol.setProtocolSubmissions(submissions);
        protocolSubmission.setProtocol((ProtocolBase)protocol);
        return protocolSubmission;
    }
}

