/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.irb;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsEqual;
import org.hamcrest.core.IsNot;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.kuali.kra.SeparateAssociate;
import org.kuali.kra.SeparatelySequenceableAssociate;
import org.kuali.kra.SequenceOwner;
import org.kuali.kra.bo.AttachmentFile;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.irb.Protocol;
import org.kuali.kra.irb.ProtocolDocument;
import org.kuali.kra.irb.noteattachment.ProtocolAttachmentProtocol;
import org.kuali.kra.irb.protocol.location.ProtocolLocation;
import org.kuali.kra.irb.test.ProtocolFactory;
import org.kuali.kra.protocol.ProtocolAssociateBase;
import org.kuali.kra.protocol.ProtocolBase;
import org.kuali.kra.protocol.noteattachment.ProtocolAttachmentBase;
import org.kuali.kra.protocol.noteattachment.ProtocolAttachmentProtocolBase;
import org.kuali.kra.service.VersioningService;
import org.kuali.kra.test.infrastructure.KcUnitTestBase;
import org.kuali.rice.kns.util.KNSGlobalVariables;
import org.kuali.rice.krad.UserSession;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.service.DocumentService;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.krad.util.MessageMap;

public class ProtocolVersioningTest
extends KcUnitTestBase {
    private BusinessObjectService bos;
    private DocumentService documentService;
    private VersioningService versioningService;
    private ProtocolDocument ver1;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        GlobalVariables.setUserSession((UserSession)new UserSession("quickstart"));
        GlobalVariables.setMessageMap((MessageMap)new MessageMap());
        KNSGlobalVariables.setAuditErrorMap(new HashMap());
        this.locateServices();
        this.ver1 = ProtocolFactory.createProtocolDocument();
    }

    @Test
    public void test_basic_versioning() throws Exception {
        this.assertIsVersioned(this.ver1, this.createAndSaveVersion(this.ver1));
    }

    @Test
    @Ignore(value="Protocol doesn't have any BO strutures to test this yet")
    public void test_one_associate_versioning() throws Exception {
    }

    @Test
    public void test_many_associates_versioning() throws Exception {
        ArrayList<ProtocolLocation> locations = new ArrayList<ProtocolLocation>();
        ProtocolLocation location = new ProtocolLocation();
        location.setProtocol((ProtocolBase)this.ver1.getProtocol());
        location.setOrganizationId("000001");
        location.setProtocolOrganizationTypeCode("1");
        locations.add(location);
        ProtocolLocation location2 = new ProtocolLocation();
        location2.setProtocol((ProtocolBase)this.ver1.getProtocol());
        location2.setOrganizationId("000002");
        location2.setProtocolOrganizationTypeCode("2");
        locations.add(location2);
        this.ver1.getProtocol().setProtocolLocations(locations);
        this.documentService.saveDocument((Document)this.ver1);
        ProtocolDocument ver2 = this.createAndSaveVersion(this.ver1);
        this.assertIsVersioned(this.ver1, ver2);
        this.assertIsVersioned(this.ver1.getProtocol().getProtocolLocations(), ver2.getProtocol().getProtocolLocations());
    }

    @Test
    public void test_many_separate_sequenced_associates_version_protocol_only() throws Exception {
        this.ver1.getProtocol().addAttachmentsByType((ProtocolAttachmentBase)this.createAttachment1());
        this.ver1.getProtocol().addAttachmentsByType((ProtocolAttachmentBase)this.createAttachment2());
        this.documentService.saveDocument((Document)this.ver1);
        ProtocolDocument ver2 = this.createAndSaveVersion(this.ver1);
        this.assertIsVersioned(this.ver1, ver2);
        for (int i = 0; i < this.ver1.getProtocol().getAttachmentProtocols().size(); ++i) {
            this.assertNotVersioned(((ProtocolAttachmentProtocolBase)this.ver1.getProtocol().getAttachmentProtocols().get(i)).getFile(), ((ProtocolAttachmentProtocolBase)ver2.getProtocol().getAttachmentProtocols().get(i)).getFile());
        }
    }

    @Test
    public void test_separate_sequenced_associate_version() throws Exception {
        ProtocolAttachmentProtocol attachment1 = this.createAttachment1();
        this.ver1.getProtocol().addAttachmentsByType((ProtocolAttachmentBase)attachment1);
        this.documentService.saveDocument((Document)this.ver1);
        ProtocolDocument ver2 = this.createAndSaveVersion(this.ver1);
        this.assertIsVersioned(this.ver1, ver2);
        AttachmentFile oldVersion = attachment1.getFile();
        AttachmentFile newVersion = (AttachmentFile)this.versioningService.versionAssociate((SeparatelySequenceableAssociate)oldVersion);
        attachment1.setFile(newVersion);
        Assert.assertThat((Object)ver2.getProtocol().getAttachmentProtocols().size(), (Matcher)Is.is((Object)1));
        this.assertIsVersioned(oldVersion, newVersion);
    }

    private ProtocolAttachmentProtocol createAttachment1() {
        ProtocolAttachmentProtocol attachment = new ProtocolAttachmentProtocol(this.ver1.getProtocol());
        attachment.setTypeCode("1");
        attachment.setDocumentId(Integer.valueOf(1));
        attachment.setDescription("desc1");
        attachment.setFile(new AttachmentFile("junk.txt", "txt", new byte[]{0, 1, 2, 3, 4, 5}));
        return attachment;
    }

    private ProtocolAttachmentProtocol createAttachment2() {
        ProtocolAttachmentProtocol attachment2 = new ProtocolAttachmentProtocol(this.ver1.getProtocol());
        attachment2.setTypeCode("2");
        attachment2.setDocumentId(Integer.valueOf(1));
        attachment2.setDescription("desc2");
        attachment2.setFile(new AttachmentFile("more_junk.java", "java", new byte[]{0}));
        return attachment2;
    }

    private ProtocolDocument createAndSaveVersion(ProtocolDocument oldDoc) throws Exception {
        Protocol newVersion = (Protocol)this.versioningService.createNewVersion((SequenceOwner)oldDoc.getProtocol());
        ProtocolDocument protocolDocument = (ProtocolDocument)this.documentService.getNewDocument(ProtocolDocument.class);
        protocolDocument.getDocumentHeader().setDocumentDescription("A new version");
        protocolDocument.setDocumentNextvalues(new ArrayList());
        protocolDocument.setProtocol((ProtocolBase)newVersion);
        this.documentService.saveDocument((Document)protocolDocument);
        return protocolDocument;
    }

    private void locateServices() {
        this.documentService = (DocumentService)KraServiceLocator.getService(DocumentService.class);
        this.bos = (BusinessObjectService)KraServiceLocator.getService(BusinessObjectService.class);
        this.versioningService = (VersioningService)KraServiceLocator.getService(VersioningService.class);
    }

    private void assertIsVersioned(ProtocolDocument ver1, ProtocolDocument ver2) {
        Assert.assertThat((Object)ver2.getProtocol().getSequenceNumber(), (Matcher)Is.is((Object)(ver1.getProtocol().getSequenceNumber() + 1)));
        Assert.assertThat((Object)ver2.getProtocol().getProtocolNumber(), (Matcher)IsEqual.equalTo((Object)ver1.getProtocol().getProtocolNumber()));
        Assert.assertThat((Object)ver2.getProtocol().getProtocolId(), (Matcher)IsNot.not((Matcher)IsEqual.equalTo((Object)ver1.getProtocol().getProtocolId())));
    }

    private void assertIsVersioned(ProtocolAssociateBase ver1, ProtocolAssociateBase ver2) {
        Assert.assertThat((Object)ver2.getSequenceNumber(), (Matcher)Is.is((Object)(ver1.getSequenceNumber() + 1)));
        Assert.assertThat((Object)ver2.getProtocolNumber(), (Matcher)IsEqual.equalTo((Object)ver1.getProtocol().getProtocolNumber()));
        Assert.assertThat((Object)ver2.getProtocolId(), (Matcher)IsNot.not((Matcher)IsEqual.equalTo((Object)ver1.getProtocolId())));
        Assert.assertThat((Object)ver2.getSequenceNumber(), (Matcher)IsEqual.equalTo((Object)ver2.getProtocol().getSequenceNumber()));
        Assert.assertThat((Object)ver2.getProtocolNumber(), (Matcher)IsEqual.equalTo((Object)ver2.getProtocol().getProtocolNumber()));
        Assert.assertThat((Object)ver2.getProtocolId(), (Matcher)IsEqual.equalTo((Object)ver2.getProtocol().getProtocolId()));
    }

    private <T extends SeparateAssociate> void assertIsVersioned(T ver1, T ver2) {
        Assert.assertThat((Object)ver2.getSequenceNumber(), (Matcher)Is.is((Object)(ver1.getSequenceNumber() + 1)));
        Assert.assertThat((Object)ver2.getId(), (Matcher)IsNot.not((Matcher)IsEqual.equalTo((Object)ver1.getId())));
    }

    private <T extends SeparateAssociate> void assertNotVersioned(T ver1, T ver2) {
        Assert.assertThat((Object)ver2.getSequenceNumber(), (Matcher)Is.is((Object)ver1.getSequenceNumber()));
        Assert.assertThat((Object)ver2.getId(), (Matcher)IsEqual.equalTo((Object)ver1.getId()));
    }

    private <T extends ProtocolAssociateBase> void assertIsVersioned(List<T> ver1, List<T> ver2) {
        Assert.assertThat((Object)ver2.size(), (Matcher)IsEqual.equalTo((Object)ver1.size()));
        for (int i = 0; i < ver1.size(); ++i) {
            this.assertIsVersioned((ProtocolAssociateBase)ver1.get(i), (ProtocolAssociateBase)ver2.get(i));
        }
    }
}

