/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.irb.actions.abandon;

import java.sql.Date;
import org.jmock.Expectations;
import org.jmock.Mockery;
import org.jmock.integration.junit4.JUnit4Mockery;
import org.jmock.internal.ExpectationBuilder;
import org.jmock.lib.legacy.ClassImposteriser;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.irb.ProtocolDocument;
import org.kuali.kra.irb.actions.ProtocolAction;
import org.kuali.kra.irb.actions.abandon.ProtocolAbandonServiceImpl;
import org.kuali.kra.irb.actions.genericactions.ProtocolGenericActionBean;
import org.kuali.kra.irb.actions.submit.ProtocolActionService;
import org.kuali.kra.irb.actions.submit.ProtocolSubmission;
import org.kuali.kra.irb.test.ProtocolFactory;
import org.kuali.kra.protocol.ProtocolBase;
import org.kuali.kra.test.infrastructure.KcUnitTestBase;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.krad.service.DocumentService;

public class ProtocolAbandonServiceTest
extends KcUnitTestBase {
    private static final String BASIC_COMMENT = "some dummy comments here";
    private static final Date BASIC_ACTION_DATE = new Date(System.currentTimeMillis());
    private ProtocolAbandonServiceImpl service;
    private Mockery context = new JUnit4Mockery(){
        {
            this.setImposteriser(ClassImposteriser.INSTANCE);
        }
    };

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.service = new ProtocolAbandonServiceImpl();
        this.service.setProtocolActionService((org.kuali.kra.protocol.actions.submit.ProtocolActionService)KraServiceLocator.getService(ProtocolActionService.class));
        this.service.setDocumentService(this.getMockDocumentService());
    }

    @Override
    @After
    public void tearDown() throws Exception {
        this.service = null;
        super.tearDown();
    }

    @Test
    public void testAbandonProtocol() throws WorkflowException {
        this.runTest(this.getMockProtocolGenericActionBean());
    }

    private void runTest(ProtocolGenericActionBean protocolAbandonBean) throws WorkflowException {
        ProtocolDocument protocolDocument = ProtocolFactory.createProtocolDocument();
        this.service.abandonProtocol((ProtocolBase)protocolDocument.getProtocol(), (org.kuali.kra.protocol.actions.genericactions.ProtocolGenericActionBean)protocolAbandonBean);
        ProtocolSubmission protocolSubmission = protocolDocument.getProtocol().getProtocolSubmission();
        ProtocolAbandonServiceTest.assertNotNull((Object)protocolSubmission);
        ProtocolAction protocolAction = protocolDocument.getProtocol().getLastProtocolAction();
        ProtocolAbandonServiceTest.assertNotNull((Object)protocolAction);
        ProtocolAbandonServiceTest.assertEquals((Object)"313", (Object)protocolDocument.getProtocol().getProtocolStatusCode());
        this.verifyAction(protocolAction, protocolAbandonBean, protocolSubmission);
    }

    private void verifyAction(ProtocolAction action, ProtocolGenericActionBean requestBean, ProtocolSubmission submission) {
        ProtocolAbandonServiceTest.assertEquals((Object)"119", (Object)action.getProtocolActionTypeCode());
        ProtocolAbandonServiceTest.assertEquals((Object)submission.getSubmissionId(), (Object)action.getSubmissionIdFk());
        ProtocolAbandonServiceTest.assertEquals((Object)BASIC_COMMENT, (Object)action.getComments());
    }

    private DocumentService getMockDocumentService() {
        final DocumentService service = (DocumentService)this.context.mock(DocumentService.class);
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                this.ignoring(service);
            }
        });
        return service;
    }

    private ProtocolGenericActionBean getMockProtocolGenericActionBean() {
        final ProtocolGenericActionBean bean = (ProtocolGenericActionBean)this.context.mock(ProtocolGenericActionBean.class);
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((ProtocolGenericActionBean)this.allowing(bean)).getComments();
                this.will(3.returnValue((Object)ProtocolAbandonServiceTest.BASIC_COMMENT));
                ((ProtocolGenericActionBean)this.allowing(bean)).getActionDate();
                this.will(3.returnValue((Object)BASIC_ACTION_DATE));
            }
        });
        return bean;
    }
}

