/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.irb.actions.amendrenew;

import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.jmock.Expectations;
import org.jmock.Mockery;
import org.jmock.integration.junit4.JUnit4Mockery;
import org.jmock.internal.ExpectationBuilder;
import org.jmock.lib.legacy.ClassImposteriser;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kra.dao.KraLookupDao;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.irb.Protocol;
import org.kuali.kra.irb.ProtocolDocument;
import org.kuali.kra.irb.ProtocolFinderDao;
import org.kuali.kra.irb.actions.ProtocolAction;
import org.kuali.kra.irb.actions.amendrenew.ProtocolAmendRenewModule;
import org.kuali.kra.irb.actions.amendrenew.ProtocolAmendRenewServiceImpl;
import org.kuali.kra.irb.actions.amendrenew.ProtocolAmendRenewal;
import org.kuali.kra.irb.actions.amendrenew.ProtocolAmendmentBean;
import org.kuali.kra.irb.test.ProtocolFactory;
import org.kuali.kra.protocol.ProtocolDocumentBase;
import org.kuali.kra.protocol.actions.copy.ProtocolCopyService;
import org.kuali.kra.questionnaire.answer.QuestionnaireAnswerService;
import org.kuali.kra.test.infrastructure.KcUnitTestBase;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.service.DocumentService;
import org.kuali.rice.krad.service.SequenceAccessorService;

public class ProtocolAmendRenewServiceTest
extends KcUnitTestBase {
    private static final String SUMMARY = "my test summary";
    private ProtocolAmendRenewServiceImpl service;
    private Mockery context = new JUnit4Mockery(){
        {
            this.setImposteriser(ClassImposteriser.INSTANCE);
        }
    };

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.service = new ProtocolAmendRenewServiceImpl();
        this.service.setDocumentService((DocumentService)KraServiceLocator.getService(DocumentService.class));
        this.service.setProtocolCopyService((ProtocolCopyService)KraServiceLocator.getService(org.kuali.kra.irb.actions.copy.ProtocolCopyService.class));
        this.service.setKraLookupDao((KraLookupDao)KraServiceLocator.getService(KraLookupDao.class));
        this.service.setProtocolFinderDao((org.kuali.kra.protocol.ProtocolFinderDao)KraServiceLocator.getService(ProtocolFinderDao.class));
        this.service.setSequenceAccessorService((SequenceAccessorService)KraServiceLocator.getService(SequenceAccessorService.class));
        this.service.setQuestionnaireAnswerService((QuestionnaireAnswerService)KraServiceLocator.getService(QuestionnaireAnswerService.class));
        this.service.setBusinessObjectService((BusinessObjectService)KraServiceLocator.getService(BusinessObjectService.class));
    }

    @Override
    @After
    public void tearDown() throws Exception {
        this.service = null;
        super.tearDown();
    }

    @Test
    public void testAmendment() throws Exception {
        ProtocolAmendmentBean protocolAmendmentBean = this.getMockProtocolAmendmentBean(false, false, false, true, false, true, false, false, false, false, false, false);
        ProtocolDocument protocolDocument = ProtocolFactory.createProtocolDocument();
        String docNbr = this.service.createAmendment((ProtocolDocumentBase)protocolDocument, (org.kuali.kra.protocol.actions.amendrenew.ProtocolAmendmentBean)protocolAmendmentBean);
        ProtocolDocument amendmentDocument = (ProtocolDocument)this.getDocumentService().getByDocumentHeaderId(docNbr);
        ProtocolAmendRenewServiceTest.assertEquals((Object)(protocolDocument.getProtocol().getProtocolNumber() + "A001"), (Object)amendmentDocument.getProtocol().getProtocolNumber());
        this.verifyAction(protocolDocument.getProtocol(), "103", "Amendment-001: Created");
        this.verifyAmendmentRenewal(amendmentDocument.getProtocol(), SUMMARY, 2);
    }

    @Test
    public void testRenewal() throws Exception {
        ProtocolDocument protocolDocument = ProtocolFactory.createProtocolDocument();
        String docNbr = this.service.createRenewal((ProtocolDocumentBase)protocolDocument, SUMMARY);
        ProtocolDocument amendmentDocument = (ProtocolDocument)this.getDocumentService().getByDocumentHeaderId(docNbr);
        ProtocolAmendRenewServiceTest.assertEquals((Object)(protocolDocument.getProtocol().getProtocolNumber() + "R001"), (Object)amendmentDocument.getProtocol().getProtocolNumber());
        this.verifyAction(protocolDocument.getProtocol(), "102", "Renewal-001: Created");
        this.verifyAmendmentRenewal(amendmentDocument.getProtocol(), SUMMARY, 0);
    }

    @Test
    public void testRenewalWithAmendment() throws Exception {
        ProtocolAmendmentBean protocolAmendmentBean = this.getMockProtocolAmendmentBean(false, false, false, true, false, true, false, false, false, false, false, false);
        ProtocolDocument protocolDocument = ProtocolFactory.createProtocolDocument();
        String docNbr = this.service.createRenewalWithAmendment((ProtocolDocumentBase)protocolDocument, (org.kuali.kra.protocol.actions.amendrenew.ProtocolAmendmentBean)protocolAmendmentBean);
        ProtocolDocument amendmentDocument = (ProtocolDocument)this.getDocumentService().getByDocumentHeaderId(docNbr);
        ProtocolAmendRenewServiceTest.assertEquals((Object)(protocolDocument.getProtocol().getProtocolNumber() + "R001"), (Object)amendmentDocument.getProtocol().getProtocolNumber());
        this.verifyAction(protocolDocument.getProtocol(), "102", "Renewal-001: Created");
        this.verifyAmendmentRenewal(amendmentDocument.getProtocol(), SUMMARY, 2);
    }

    private void verifyAction(Protocol protocol, String expectedActionType, String expectedComment) {
        ProtocolAction action = protocol.getLastProtocolAction();
        ProtocolAmendRenewServiceTest.assertEquals((Object)expectedActionType, (Object)action.getProtocolActionTypeCode());
        ProtocolAmendRenewServiceTest.assertEquals((Object)action.getProtocolId(), (Object)protocol.getProtocolId());
        ProtocolAmendRenewServiceTest.assertEquals(null, (Object)action.getSubmissionIdFk());
        ProtocolAmendRenewServiceTest.assertEquals((Object)expectedComment, (Object)action.getComments());
    }

    private void verifyAmendmentRenewal(Protocol protocol, String expectedSummary, int moduleCount) {
        ProtocolAmendRenewal amendRenewal = (ProtocolAmendRenewal)protocol.getProtocolAmendRenewal();
        ProtocolAmendRenewServiceTest.assertEquals((Object)amendRenewal.getProtocolId(), (Object)protocol.getProtocolId());
        ProtocolAmendRenewServiceTest.assertEquals((Object)expectedSummary, (Object)amendRenewal.getSummary());
        this.verifyModules(amendRenewal, moduleCount);
    }

    private void verifyModules(ProtocolAmendRenewal amendRenewal, int moduleCount) {
        List modules = amendRenewal.getModules();
        ProtocolAmendRenewServiceTest.assertEquals((long)moduleCount, (long)modules.size());
        if (moduleCount > 0) {
            this.assertContains("008", modules);
            this.assertContains("017", modules);
        }
    }

    private void assertContains(String moduleTypeCode, List<ProtocolAmendRenewModule> modules) {
        for (ProtocolAmendRenewModule module : modules) {
            if (!StringUtils.equals((String)moduleTypeCode, (String)module.getProtocolModuleTypeCode())) continue;
            return;
        }
        ProtocolAmendRenewServiceTest.assertTrue((boolean)false);
    }

    @Test
    public void testGetAmendmentsAndRenewals() throws Exception {
        ProtocolDocument a1 = ProtocolFactory.createProtocolDocument("0906000001A001");
        ProtocolDocument a2 = ProtocolFactory.createProtocolDocument("0906000001A002");
        ProtocolDocument r1 = ProtocolFactory.createProtocolDocument("0906000001R001");
        List protocols = this.service.getAmendmentAndRenewals("0906000001");
        ProtocolAmendRenewServiceTest.assertEquals((long)3L, (long)protocols.size());
        ProtocolAmendRenewServiceTest.assertTrue((boolean)this.containsProtocol(protocols, a1));
        ProtocolAmendRenewServiceTest.assertTrue((boolean)this.containsProtocol(protocols, a2));
        ProtocolAmendRenewServiceTest.assertTrue((boolean)this.containsProtocol(protocols, r1));
    }

    private boolean containsProtocol(List<Protocol> protocols, ProtocolDocument a1) {
        for (Protocol protocol : protocols) {
            if (!StringUtils.equals((String)protocol.getProtocolNumber(), (String)a1.getProtocol().getProtocolNumber())) continue;
            return true;
        }
        return false;
    }

    @Test
    public void testAvailableModules() throws Exception {
        ProtocolAmendmentBean protocolAmendmentBean = this.getMockProtocolAmendmentBean(false, false, false, true, false, true, true, false, false, false, false, false);
        ProtocolDocument protocolDocument = ProtocolFactory.createProtocolDocument("0906000001");
        this.service.createAmendment((ProtocolDocumentBase)protocolDocument, (org.kuali.kra.protocol.actions.amendrenew.ProtocolAmendmentBean)protocolAmendmentBean);
        List modules = this.service.getAvailableModules("0906000001");
        ProtocolAmendRenewServiceTest.assertEquals((long)9L, (long)modules.size());
        ProtocolAmendRenewServiceTest.assertTrue((boolean)modules.contains("024"));
        ProtocolAmendRenewServiceTest.assertTrue((boolean)modules.contains("001"));
        ProtocolAmendRenewServiceTest.assertTrue((boolean)modules.contains("023"));
        ProtocolAmendRenewServiceTest.assertTrue((boolean)modules.contains("002"));
        ProtocolAmendRenewServiceTest.assertTrue((boolean)modules.contains("016"));
        ProtocolAmendRenewServiceTest.assertTrue((boolean)modules.contains("007"));
        ProtocolAmendRenewServiceTest.assertTrue((boolean)modules.contains("006"));
        ProtocolAmendRenewServiceTest.assertTrue((boolean)modules.contains("025"));
        ProtocolAmendRenewServiceTest.assertTrue((boolean)modules.contains("026"));
    }

    private ProtocolAmendmentBean getMockProtocolAmendmentBean(final boolean generalInfo, final boolean fundingSource, final boolean protocolReferencesAndOtherIdentifiers, final boolean protocolOrganizations, final boolean subjects, final boolean addModifyAttachments, final boolean areasOfResearch, final boolean specialReview, final boolean protocolPersonnel, final boolean others, final boolean protocolPermissions, final boolean questionnaire) {
        final ProtocolAmendmentBean bean = (ProtocolAmendmentBean)this.context.mock(ProtocolAmendmentBean.class);
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((ProtocolAmendmentBean)this.allowing(bean)).getSummary();
                this.will(2.returnValue((Object)ProtocolAmendRenewServiceTest.SUMMARY));
                ((ProtocolAmendmentBean)this.allowing(bean)).getGeneralInfo();
                this.will(2.returnValue((Object)generalInfo));
                ((ProtocolAmendmentBean)this.allowing(bean)).getFundingSource();
                this.will(2.returnValue((Object)fundingSource));
                ((ProtocolAmendmentBean)this.allowing(bean)).getProtocolReferencesAndOtherIdentifiers();
                this.will(2.returnValue((Object)protocolReferencesAndOtherIdentifiers));
                ((ProtocolAmendmentBean)this.allowing(bean)).getProtocolOrganizations();
                this.will(2.returnValue((Object)protocolOrganizations));
                ((ProtocolAmendmentBean)this.allowing(bean)).getSubjects();
                this.will(2.returnValue((Object)subjects));
                ((ProtocolAmendmentBean)this.allowing(bean)).getAddModifyAttachments();
                this.will(2.returnValue((Object)addModifyAttachments));
                ((ProtocolAmendmentBean)this.allowing(bean)).getAreasOfResearch();
                this.will(2.returnValue((Object)areasOfResearch));
                ((ProtocolAmendmentBean)this.allowing(bean)).getSpecialReview();
                this.will(2.returnValue((Object)specialReview));
                ((ProtocolAmendmentBean)this.allowing(bean)).getProtocolPersonnel();
                this.will(2.returnValue((Object)protocolPersonnel));
                ((ProtocolAmendmentBean)this.allowing(bean)).getOthers();
                this.will(2.returnValue((Object)others));
                ((ProtocolAmendmentBean)this.allowing(bean)).getProtocolPermissions();
                this.will(2.returnValue((Object)protocolPermissions));
                ((ProtocolAmendmentBean)this.allowing(bean)).getQuestionnaire();
                this.will(2.returnValue((Object)questionnaire));
            }
        });
        return bean;
    }
}

