/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.irb.actions.amendrenew;

import org.jmock.Expectations;
import org.jmock.Mockery;
import org.jmock.integration.junit4.JUnit4Mockery;
import org.jmock.internal.ExpectationBuilder;
import org.jmock.lib.legacy.ClassImposteriser;
import org.junit.Test;
import org.kuali.kra.irb.actions.amendrenew.CreateAmendmentEvent;
import org.kuali.kra.irb.actions.amendrenew.CreateAmendmentRule;
import org.kuali.kra.irb.actions.amendrenew.ProtocolAmendmentBean;
import org.kuali.kra.irb.test.ProtocolRuleTestBase;
import org.kuali.kra.rules.TemplateRuleTest;

public class ProtocolCreateAmendmentRuleTest
extends ProtocolRuleTestBase {
    private static final String PROPERTY_KEY = "key";
    private static final String SUMMARY = "summary";
    private Mockery context = new JUnit4Mockery(){
        {
            this.setImposteriser(ClassImposteriser.INSTANCE);
        }
    };

    @Test
    public void testOK() {
        new TemplateRuleTest<CreateAmendmentEvent, CreateAmendmentRule>(){

            @Override
            protected void prerequisite() {
                ProtocolAmendmentBean bean = ProtocolCreateAmendmentRuleTest.this.getMockProtocolAmendmentBean(ProtocolCreateAmendmentRuleTest.SUMMARY, true);
                this.event = new CreateAmendmentEvent(null, ProtocolCreateAmendmentRuleTest.PROPERTY_KEY, bean);
                this.rule = new CreateAmendmentRule();
                this.expectedReturnValue = true;
            }
        };
    }

    @Test
    public void testSummary() {
        new TemplateRuleTest<CreateAmendmentEvent, CreateAmendmentRule>(){

            @Override
            protected void prerequisite() {
                ProtocolAmendmentBean bean = ProtocolCreateAmendmentRuleTest.this.getMockProtocolAmendmentBean("", true);
                this.event = new CreateAmendmentEvent(null, ProtocolCreateAmendmentRuleTest.PROPERTY_KEY, bean);
                this.rule = new CreateAmendmentRule();
                this.expectedReturnValue = false;
            }

            @Override
            public void checkRuleAssertions() {
                ProtocolCreateAmendmentRuleTest.this.assertError(ProtocolCreateAmendmentRuleTest.PROPERTY_KEY, "error.amendment.required.summary");
            }
        };
    }

    @Test
    public void testSelection() {
        new TemplateRuleTest<CreateAmendmentEvent, CreateAmendmentRule>(){

            @Override
            protected void prerequisite() {
                ProtocolAmendmentBean bean = ProtocolCreateAmendmentRuleTest.this.getMockProtocolAmendmentBean(ProtocolCreateAmendmentRuleTest.SUMMARY, false);
                this.event = new CreateAmendmentEvent(null, ProtocolCreateAmendmentRuleTest.PROPERTY_KEY, bean);
                this.rule = new CreateAmendmentRule();
                this.expectedReturnValue = false;
            }

            @Override
            public void checkRuleAssertions() {
                ProtocolCreateAmendmentRuleTest.this.assertError(ProtocolCreateAmendmentRuleTest.PROPERTY_KEY, "error.amendment.select.module");
            }
        };
    }

    private ProtocolAmendmentBean getMockProtocolAmendmentBean(final String summary, final boolean someSelected) {
        final ProtocolAmendmentBean bean = (ProtocolAmendmentBean)this.context.mock(ProtocolAmendmentBean.class);
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((ProtocolAmendmentBean)this.allowing(bean)).getSummary();
                this.will(5.returnValue((Object)summary));
                ((ProtocolAmendmentBean)this.allowing(bean)).isSomeSelected();
                this.will(5.returnValue((Object)someSelected));
            }
        });
        return bean;
    }
}

